/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class HexDumper {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void main(String[] args) {
        try {
            byte[] ba = null;
            if (args.length > 0) {
                ba = HexDumper.getFileBytes(args[0]);
            }
            if (ba != null) {
                HexDumper.dumpBytes(System.out, ba);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static byte[] getFileBytes(String name) throws IOException {
        FileInputStream cin = new FileInputStream(name);
        if (cin == null) {
            throw new IOException("File " + name + " cannot be found");
        }
        byte[] bytes = new byte[((InputStream)cin).available()];
        if (((InputStream)cin).read(bytes) != bytes.length) {
            throw new IOException("Could not read file");
        }
        return bytes;
    }

    public static void dumpBytes(PrintStream out, byte[] ba) {
        StringBuffer hex = new StringBuffer();
        StringBuffer asc = new StringBuffer();
        for (int i = 0; i < ba.length; ++i) {
            byte b = ba[i];
            int d1 = b >> 4 & 0xF;
            int d0 = b >> 0 & 0xF;
            hex.append(hexDigits[d1]).append(hexDigits[d0]).append(' ');
            asc.append((char)(Character.isISOControl((char)b) ? 46 : (char)b));
            if (i % 16 != 15) continue;
            hex.append(' ').append(asc.toString());
            out.println(hex.toString());
            hex = new StringBuffer();
            asc = new StringBuffer();
        }
        for (int j = ba.length % 16; j < 16; ++j) {
            hex.append("   ");
        }
        hex.append(' ').append(asc.toString());
        out.println(hex.toString());
    }
}

