/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wst.adaptive.example;

import hj.runtime.wst.adaptive.ActivationFrame;
import hj.runtime.wst.adaptive.BfAsyncFrame;
import hj.runtime.wst.adaptive.DelayedAsync;
import hj.runtime.wst.adaptive.Worker;
import hj.runtime.wst.adaptive.WorkerException;

public class DelayedAsyncsExample {
    static volatile boolean completeA = false;
    static volatile boolean completeB = false;
    static volatile boolean completeC = false;
    static volatile boolean completeD = false;
    static volatile boolean completeE = false;

    private static void mainSlow(Worker worker, MainActivationFrame mainAf) throws WorkerException {
        int n = mainAf.n;
        String[] args = mainAf.args;
        switch (mainAf.pc) {
            case 0: {
                worker.startFinish();
                worker.pushDelayedAsync(new AsyncB(worker));
                worker.pushBfAsync(new AsyncA(worker));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                worker.pushDelayedAsync(new AsyncE(worker));
                worker.pushDelayedAsync(new AsyncC(worker));
                worker.pushDelayedAsync(new AsyncD(worker));
                mainAf.pc = 1;
                worker.stopFinish();
                worker.endMethodSlow();
            }
        }
    }

    public static final class MainActivationFrame
    extends ActivationFrame {
        String[] args;
        int n;

        public MainActivationFrame(String[] args) {
            this.args = args;
        }

        public void execute(Worker worker) throws WorkerException {
            DelayedAsyncsExample.mainSlow(worker, this);
        }

        public void setReturnResult(Object v) {
            assert (false);
        }

        public String toString() {
            return "MainAf[n=" + this.n + " pc=" + this.pc + "]";
        }
    }

    public static final class AsyncE
    extends DelayedAsync {
        public AsyncE(Worker worker) {
            super(worker.getCurrentFinishScope());
        }

        public void execute(Worker worker) throws WorkerException {
            System.out.println("Hello from E");
            completeE = true;
        }

        public boolean isHjTaskReady() {
            return completeA && completeB;
        }

        public String toString() {
            return "E (" + this.taken + ")";
        }
    }

    public static final class AsyncD
    extends DelayedAsync {
        public AsyncD(Worker worker) {
            super(worker.getCurrentFinishScope());
        }

        public void execute(Worker worker) throws WorkerException {
            System.out.println("Hello from D");
            completeD = true;
        }

        public boolean isHjTaskReady() {
            return completeB;
        }

        public String toString() {
            return "D (" + this.taken + ")";
        }
    }

    public static final class AsyncC
    extends DelayedAsync {
        public AsyncC(Worker worker) {
            super(worker.getCurrentFinishScope());
        }

        public void execute(Worker worker) throws WorkerException {
            System.out.println("Hello from C");
            completeC = true;
        }

        public boolean isHjTaskReady() {
            return completeD;
        }

        public String toString() {
            return "C (" + this.taken + ")";
        }
    }

    public static final class AsyncB
    extends DelayedAsync {
        public AsyncB(Worker worker) {
            super(worker.getCurrentFinishScope());
        }

        public void execute(Worker worker) throws WorkerException {
            System.out.println("Hello from B");
            completeB = true;
        }

        public boolean isHjTaskReady() {
            return completeA;
        }

        public String toString() {
            return "B (" + this.taken + ")";
        }
    }

    public static final class AsyncA
    extends BfAsyncFrame {
        public AsyncA(Worker worker) {
            super(worker.getCurrentFinishScope());
        }

        public void execute(Worker worker) throws WorkerException {
            System.out.println("Hello from A");
            completeA = true;
        }

        public String toString() {
            return "A";
        }
    }
}

