/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wst.adaptive.example;

import hj.runtime.wst.adaptive.ActivationFrame;
import hj.runtime.wst.adaptive.Worker;
import hj.runtime.wst.adaptive.WorkerAbortException;
import hj.runtime.wst.adaptive.WorkerException;

public final class FibWorkFirstUnOpt {
    public static final int[] fibsol = new int[]{0, 1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233, 377, 610, 987, 1597, 2584, 4181, 6765, 10946, 17711, 28657, 46368, 75025, 121393, 196418, 317811, 514229, 832040, 1346269, 2178309, 3524578, 5702887, 0x8CCCC9, 14930352, 24157817, 39088169, 63245986, 102334155, 165580141, 267914296, 433494437, 701408733, 1134903170};

    private static void Fib_WorkFirst(Worker worker, BoxInteger res, int n) throws WorkerAbortException {
        BoxInteger x;
        if (n < 2) {
            res.v = n;
            return;
        }
        FibActivationFrame fibAf = new FibActivationFrame(res, n);
        worker.beginMethod(fibAf);
        worker.startFinish();
        fibAf.x = x = new BoxInteger();
        fibAf.pc = 1;
        worker.pushContinuation();
        FibActivationFrame a1 = new FibActivationFrame(res, n);
        worker.beginMethod(a1);
        a1.pc = 4;
        FibWorkFirstUnOpt.Fib_WorkFirst(worker, x, n - 1);
        worker.endMethodFast();
        worker.popAndAbortOnSteal();
        BoxInteger y = new BoxInteger();
        fibAf.x = x;
        fibAf.y = y;
        fibAf.pc = 2;
        worker.pushContinuation();
        FibActivationFrame a2 = new FibActivationFrame(res, n);
        worker.beginMethod(a2);
        a2.pc = 5;
        FibWorkFirstUnOpt.Fib_WorkFirst(worker, y, n - 2);
        worker.endMethodFast();
        worker.popAndAbortOnSteal();
        fibAf.x = x;
        fibAf.y = y;
        fibAf.pc = 3;
        worker.stopFinishFast();
        res.v = x.v + y.v;
        worker.endMethodFast();
    }

    private static void Fib_WorkFirstSlow(Worker worker, FibActivationFrame fibAf) throws WorkerException {
        BoxInteger res = fibAf.res;
        int n = fibAf.n;
        BoxInteger x = fibAf.x;
        BoxInteger y = fibAf.y;
        switch (fibAf.pc) {
            case 1: {
                y = new BoxInteger();
                fibAf.x = x;
                fibAf.y = y;
                fibAf.pc = 2;
                worker.pushContinuation();
                FibWorkFirstUnOpt.Fib_WorkFirst(worker, y, n - 2);
                worker.popAndAbortOnSteal();
            }
            case 2: {
                fibAf.x = x;
                fibAf.y = y;
                fibAf.pc = 3;
                worker.stopFinishSlow();
            }
            case 3: {
                res.v = x.v + y.v;
                assert (res.v == fibsol[n]);
            }
            case 4: 
            case 5: {
                worker.endMethodSlow();
            }
        }
    }

    private static void mainSlow(Worker worker, MainActivationFrame mainAf) throws WorkerException {
        int n = mainAf.n;
        int ans = mainAf.ans;
        String[] args = mainAf.args;
        switch (mainAf.pc) {
            case 0: {
                n = Integer.parseInt(args[0]);
                mainAf.pc = 1;
                mainAf.n = n;
                ans = FibWorkFirstUnOpt.DoFast(worker, n);
            }
            case 1: {
                System.out.println("Fib(" + n + ") = " + ans + " " + (ans == fibsol[n] ? "OK" : "FAILURE"));
                worker.endMethodSlow();
            }
        }
    }

    private static int DoFast(Worker worker, int n) throws WorkerException {
        BoxInteger ret;
        DoActivationFrame doCf = new DoActivationFrame(n);
        worker.beginMethod(doCf);
        doCf.ret = ret = new BoxInteger();
        doCf.pc = 1;
        FibWorkFirstUnOpt.Fib_WorkFirst(worker, ret, n);
        worker.endMethodFast();
        return ret.v;
    }

    private static void DoSlow(Worker worker, DoActivationFrame doCf) throws WorkerException {
        BoxInteger ret = doCf.ret;
        switch (doCf.pc) {
            case 1: {
                worker.endMethodSlow(ret.v);
            }
        }
    }

    public static final class MainActivationFrame
    extends ActivationFrame {
        String[] args;
        int ans;
        int n;

        public MainActivationFrame(String[] args) {
            this.args = args;
        }

        public void execute(Worker worker) throws WorkerException {
            FibWorkFirstUnOpt.mainSlow(worker, this);
        }

        public void setReturnResult(Object v) {
            switch (this.pc) {
                case 1: {
                    this.ans = (Integer)v;
                    return;
                }
            }
            assert (false);
        }

        public String toString() {
            return "MainAf[n=" + this.n + " pc=" + this.pc + "]";
        }
    }

    public static final class DoActivationFrame
    extends ActivationFrame {
        int n;
        Object retObject;
        BoxInteger ret;

        public DoActivationFrame(int n) {
            this.n = n;
        }

        public void execute(Worker worker) throws WorkerException {
            FibWorkFirstUnOpt.DoSlow(worker, this);
        }

        public void setReturnResult(Object v) {
            assert (v == null);
        }

        public String toString() {
            return "DoAF[n=" + this.n + " pc=" + this.pc + "]";
        }
    }

    public static final class FibActivationFrame
    extends ActivationFrame {
        public BoxInteger res;
        public int n;
        public BoxInteger x;
        public BoxInteger y;

        FibActivationFrame(BoxInteger res, int n) {
            this.res = res;
            this.n = n;
        }

        public void execute(Worker worker) throws WorkerException {
            FibWorkFirstUnOpt.Fib_WorkFirstSlow(worker, this);
        }

        public void setReturnResult(Object v) {
        }

        public String toString() {
            return "FibAF[n=" + this.n + " pc=" + this.pc + "]";
        }
    }

    public static final class BoxInteger {
        public int v;
    }
}

