/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.ProcedureInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class ConstructorCall_c
extends Stmt_c
implements ConstructorCall {
    protected ConstructorCall.Kind kind;
    protected Expr qualifier;
    protected List arguments;
    protected ConstructorInstance ci;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConstructorCall_c(Position pos, ConstructorCall.Kind kind, Expr qualifier, List arguments) {
        super(pos);
        if (!($assertionsDisabled || kind != null && arguments != null)) {
            throw new AssertionError();
        }
        this.kind = kind;
        this.qualifier = qualifier;
        this.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
    }

    public Expr qualifier() {
        return this.qualifier;
    }

    public ConstructorCall qualifier(Expr qualifier) {
        ConstructorCall_c n = (ConstructorCall_c)this.copy();
        n.qualifier = qualifier;
        return n;
    }

    public ConstructorCall.Kind kind() {
        return this.kind;
    }

    public ConstructorCall kind(ConstructorCall.Kind kind) {
        ConstructorCall_c n = (ConstructorCall_c)this.copy();
        n.kind = kind;
        return n;
    }

    public List arguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public ProcedureCall arguments(List arguments) {
        ConstructorCall_c n = (ConstructorCall_c)this.copy();
        n.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
        return n;
    }

    public ProcedureInstance procedureInstance() {
        return this.constructorInstance();
    }

    public ConstructorInstance constructorInstance() {
        return this.ci;
    }

    public ConstructorCall constructorInstance(ConstructorInstance ci) {
        if (ci == this.ci) {
            return this;
        }
        ConstructorCall_c n = (ConstructorCall_c)this.copy();
        n.ci = ci;
        return n;
    }

    public Context enterScope(Context c) {
        return c.pushStatic();
    }

    protected ConstructorCall_c reconstruct(Expr qualifier, List arguments) {
        if (qualifier != this.qualifier || !CollectionUtil.equals(arguments, this.arguments)) {
            ConstructorCall_c n = (ConstructorCall_c)this.copy();
            n.qualifier = qualifier;
            n.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr qualifier = (Expr)this.visitChild(this.qualifier, v);
        List arguments = this.visitList(this.arguments, v);
        return this.reconstruct(qualifier, arguments);
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        if (this.kind == SUPER && tb.currentClass() == ts.Object()) {
            return tb.nodeFactory().Empty(this.position());
        }
        ConstructorCall_c n = (ConstructorCall_c)super.buildTypes(tb);
        ArrayList<UnknownType> l = new ArrayList<UnknownType>(this.arguments.size());
        for (int i = 0; i < this.arguments.size(); ++i) {
            l.add(ts.unknownType(this.position()));
        }
        ConstructorInstance ci = ts.constructorInstance(this.position(), ts.Object(), Flags.NONE, l, Collections.EMPTY_LIST);
        return n.constructorInstance(ci);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Copy e;
        ConstructorCall_c n = this;
        TypeSystem ts = tc.typeSystem();
        Context c = tc.context();
        ClassType ct = c.currentClass();
        Type superType = ct.superType();
        Expr qualifier = n.qualifier;
        ConstructorCall.Kind kind = n.kind;
        if (qualifier != null) {
            if (!qualifier.isDisambiguated()) {
                return n;
            }
            if (kind != SUPER) {
                throw new SemanticException("Can only qualify a \"super\"constructor invocation.", this.position());
            }
            if (!superType.isClass() || !superType.toClass().isInnerClass() || superType.toClass().inStaticContext()) {
                throw new SemanticException("The class \"" + superType + "\"" + " is not an inner class, or was declared in a static " + "context; a qualified constructor invocation cannot " + "be used.", this.position());
            }
            Type qt = qualifier.type();
            if (!qt.isClass() || !qt.isSubtype(superType.toClass().outer())) {
                throw new SemanticException("The type of the qualifier \"" + qt + "\" does not match the immediately enclosing " + "class  of the super class \"" + superType.toClass().outer() + "\".", qualifier.position());
            }
        }
        if (kind == SUPER) {
            if (!superType.isClass()) {
                throw new SemanticException("Super type of " + ct + " is not a class.", this.position());
            }
            Expr q = qualifier;
            if (q == null && superType.isClass() && superType.toClass().isInnerClass()) {
                ClassType superContainer = superType.toClass().outer();
                for (e = ct; e != null; e = e.outer()) {
                    if (!e.isSubtype(superContainer) || !ct.hasEnclosingInstance((ClassType)e)) continue;
                    NodeFactory nf = tc.nodeFactory();
                    q = nf.This(this.position(), nf.CanonicalTypeNode(this.position(), (Type)e)).type((Type)e);
                    break;
                }
                if (e == null) {
                    throw new SemanticException(ct + " must have an enclosing instance" + " that is a subtype of " + superContainer, this.position());
                }
                if (e == ct) {
                    throw new SemanticException(ct + " is a subtype of " + superContainer + "; an enclosing instance that is a subtype of " + superContainer + " must be specified in the super constructor call.", this.position());
                }
            }
            if (qualifier != q) {
                n = (ConstructorCall_c)n.qualifier(q);
            }
        }
        LinkedList<Type> argTypes = new LinkedList<Type>();
        Iterator iter = n.arguments.iterator();
        while (iter.hasNext()) {
            e = (Expr)iter.next();
            if (!e.isDisambiguated()) {
                return this;
            }
            argTypes.add(e.type());
        }
        if (kind == SUPER) {
            ct = ct.superType().toClass();
        }
        ConstructorInstance ci = ts.findConstructor(ct, argTypes, c.currentClass());
        return n.constructorInstance(ci);
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.qualifier) {
            return ts.Object();
        }
        Iterator i = this.arguments.iterator();
        Iterator j = this.ci.formalTypes().iterator();
        while (i.hasNext() && j.hasNext()) {
            Expr e = (Expr)i.next();
            Type t = (Type)j.next();
            if (e != child) continue;
            return t;
        }
        return child.type();
    }

    public String toString() {
        return (this.qualifier != null ? this.qualifier + "." : "") + this.kind + "(...)";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.qualifier != null) {
            this.print(this.qualifier, w, tr);
            w.write(".");
        }
        w.write(this.kind + "(");
        w.begin(0);
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            this.print(e, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0);
        }
        w.end();
        w.write(");");
    }

    public Term firstChild() {
        if (this.qualifier != null) {
            return this.qualifier;
        }
        return ConstructorCall_c.listChild(this.arguments, null);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.qualifier != null) {
            if (!this.arguments.isEmpty()) {
                v.visitCFG(this.qualifier, ConstructorCall_c.listChild(this.arguments, null), 1);
                v.visitCFGList(this.arguments, this, 0);
            } else {
                v.visitCFG(this.qualifier, this, 0);
            }
        } else if (!this.arguments.isEmpty()) {
            v.visitCFGList(this.arguments, this, 0);
        }
        return succs;
    }

    public List throwTypes(TypeSystem ts) {
        LinkedList l = new LinkedList();
        l.addAll(this.ci.throwTypes());
        l.addAll(ts.uncheckedExceptions());
        return l;
    }

    public Node copy(NodeFactory nf) {
        return nf.ConstructorCall(this.position, this.kind, this.qualifier, this.arguments);
    }

    static {
        $assertionsDisabled = !ConstructorCall_c.class.desiredAssertionStatus();
    }
}

