/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Do;
import polyglot.ast.Expr;
import polyglot.ast.Loop_c;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.NodeList;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Do_c
extends Loop_c
implements Do {
    protected Stmt body;
    protected Expr cond;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Do_c(Position pos, Stmt body, Expr cond) {
        super(pos);
        if (!($assertionsDisabled || body != null && cond != null)) {
            throw new AssertionError();
        }
        this.body = body;
        this.cond = cond;
    }

    public Stmt body() {
        return this.body;
    }

    public Do body(Stmt body) {
        Do_c n = (Do_c)this.copy();
        n.body = body;
        return n;
    }

    public Expr cond() {
        return this.cond;
    }

    public Do cond(Expr cond) {
        Do_c n = (Do_c)this.copy();
        n.cond = cond;
        return n;
    }

    protected Do_c reconstruct(Stmt body, Expr cond) {
        if (body != this.body || cond != this.cond) {
            Do_c n = (Do_c)this.copy();
            n.body = body;
            n.cond = cond;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Node body = this.visitChild(this.body, v);
        if (body instanceof NodeList) {
            body = ((NodeList)body).toBlock();
        }
        Expr cond = (Expr)this.visitChild(this.cond, v);
        return this.reconstruct((Stmt)body, cond);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!ts.typeEquals(this.cond.type(), ts.Boolean())) {
            throw new SemanticException("Condition of do statement must have boolean type.", this.cond.position());
        }
        return this;
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.cond) {
            return ts.Boolean();
        }
        return child.type();
    }

    public String toString() {
        return "do { ... } while (" + this.cond + ")";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("do ");
        this.printSubStmt(this.body, w, tr);
        w.write("while(");
        this.printBlock(this.cond, w, tr);
        w.write("); ");
    }

    public Term firstChild() {
        return this.body;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.push(this).visitCFG(this.body, this.cond, 1);
        if (this.condIsConstantTrue()) {
            v.visitCFG(this.cond, this.body, 1);
        } else {
            v.visitCFG(this.cond, FlowGraph.EDGE_KEY_TRUE, this.body, 1, FlowGraph.EDGE_KEY_FALSE, this, 0);
        }
        return succs;
    }

    public Term continueTarget() {
        return this.cond;
    }

    public Node copy(NodeFactory nf) {
        return nf.Do(this.position, this.body, this.cond);
    }

    static {
        $assertionsDisabled = !Do_c.class.desiredAssertionStatus();
    }
}

