/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class Formal_c
extends Term_c
implements Formal {
    protected LocalInstance li;
    protected Flags flags;
    protected TypeNode type;
    protected Id name;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Formal_c(Position pos, Flags flags, TypeNode type, Id name) {
        super(pos);
        if (!($assertionsDisabled || flags != null && type != null && name != null)) {
            throw new AssertionError();
        }
        this.flags = flags;
        this.type = type;
        this.name = name;
    }

    public boolean isDisambiguated() {
        return this.li != null && this.li.isCanonical() && super.isDisambiguated();
    }

    public Type declType() {
        return this.type.type();
    }

    public Flags flags() {
        return this.flags;
    }

    public Formal flags(Flags flags) {
        if (flags.equals(this.flags)) {
            return this;
        }
        Formal_c n = (Formal_c)this.copy();
        n.flags = flags;
        return n;
    }

    public TypeNode type() {
        return this.type;
    }

    public Formal type(TypeNode type) {
        Formal_c n = (Formal_c)this.copy();
        n.type = type;
        return n;
    }

    public Id id() {
        return this.name;
    }

    public Formal id(Id name) {
        Formal_c n = (Formal_c)this.copy();
        n.name = name;
        return n;
    }

    public String name() {
        return this.name.id();
    }

    public Formal name(String name) {
        return this.id(this.name.id(name));
    }

    public LocalInstance localInstance() {
        return this.li;
    }

    public Formal localInstance(LocalInstance li) {
        if (li == this.li) {
            return this;
        }
        Formal_c n = (Formal_c)this.copy();
        n.li = li;
        return n;
    }

    protected Formal_c reconstruct(TypeNode type, Id name) {
        if (this.type != type) {
            Formal_c n = (Formal_c)this.copy();
            n.type = type;
            n.name = name;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        TypeNode type = (TypeNode)this.visitChild(this.type, v);
        Id name = (Id)this.visitChild(this.name, v);
        return this.reconstruct(type, name);
    }

    public void addDecls(Context c) {
        c.addVariable(this.li);
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write(this.flags.translate());
        this.print(this.type, w, tr);
        w.write(" ");
        tr.print(this, this.name, w);
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        Formal_c n = (Formal_c)super.buildTypes(tb);
        TypeSystem ts = tb.typeSystem();
        LocalInstance li = ts.localInstance(this.position(), this.flags(), ts.unknownType(this.position()), this.name());
        return n.localInstance(li);
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (this.li.isCanonical()) {
            return this;
        }
        if (this.declType().isCanonical()) {
            this.li.setType(this.declType());
        }
        this.li.setNotConstant();
        return this;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Context c = tc.context();
        LocalInstance outerLocal = null;
        try {
            outerLocal = c.findLocal(this.li.name());
        }
        catch (SemanticException e) {
            // empty catch block
        }
        if (outerLocal != null && outerLocal != this.li && c.isLocal(this.li.name())) {
            throw new SemanticException("Local variable \"" + this.name + "\" multiply defined.  " + "Previous definition at " + outerLocal.position() + ".", this.position());
        }
        TypeSystem ts = tc.typeSystem();
        try {
            ts.checkLocalFlags(this.flags());
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        return this;
    }

    public Term firstChild() {
        return this.type;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG(this.type, this, 0);
        return succs;
    }

    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.li != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.li + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name " + this.name + ")");
        w.end();
    }

    public String toString() {
        return this.flags.translate() + this.type + " " + this.name;
    }

    public Node copy(NodeFactory nf) {
        return nf.Formal(this.position, this.flags, this.type, this.name);
    }

    static {
        $assertionsDisabled = !Formal_c.class.desiredAssertionStatus();
    }
}

