/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.Import;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Node_c;
import polyglot.main.Options;
import polyglot.types.Named;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.StringUtil;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Import_c
extends Node_c
implements Import {
    protected Import.Kind kind;
    protected String name;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Import_c(Position pos, Import.Kind kind, String name) {
        super(pos);
        if (!($assertionsDisabled || kind != null && name != null)) {
            throw new AssertionError();
        }
        this.name = name;
        this.kind = kind;
    }

    public String name() {
        return this.name;
    }

    public Import name(String name) {
        Import_c n = (Import_c)this.copy();
        n.name = name;
        return n;
    }

    public Import.Kind kind() {
        return this.kind;
    }

    public Import kind(Import.Kind kind) {
        Import_c n = (Import_c)this.copy();
        n.kind = kind;
        return n;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Type t;
        if (this.kind == PACKAGE && tc.typeSystem().packageExists(this.name)) {
            return this;
        }
        String pkgName = StringUtil.getFirstComponent(this.name);
        if (!tc.typeSystem().packageExists(pkgName)) {
            throw new SemanticException("Package \"" + pkgName + "\" not found.", this.position());
        }
        Named nt = tc.typeSystem().forName(this.name);
        if (nt instanceof Type && (t = (Type)((Object)nt)).isClass()) {
            tc.typeSystem().classAccessibleFromPackage(t.toClass(), tc.context().package_());
        }
        return this;
    }

    public String toString() {
        return "import " + this.name + (this.kind == PACKAGE ? ".*" : "");
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (!Options.global.fully_qualified_names) {
            w.write("import ");
            w.write(this.name);
            if (this.kind == PACKAGE) {
                w.write(".*");
            }
            w.write(";");
            w.newline(0);
        }
    }

    public Node copy(NodeFactory nf) {
        return nf.Import(this.position, this.kind, this.name);
    }

    static {
        $assertionsDisabled = !Import_c.class.desiredAssertionStatus();
    }
}

