/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.CodeBlock;
import polyglot.ast.Initializer;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.types.ClassType;
import polyglot.types.CodeInstance;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.InitializerInstance;
import polyglot.types.MemberInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SubtypeSet;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class Initializer_c
extends Term_c
implements Initializer {
    protected Flags flags;
    protected Block body;
    protected InitializerInstance ii;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Initializer_c(Position pos, Flags flags, Block body) {
        super(pos);
        if (!($assertionsDisabled || flags != null && body != null)) {
            throw new AssertionError();
        }
        this.flags = flags;
        this.body = body;
    }

    public boolean isDisambiguated() {
        return this.ii != null && this.ii.isCanonical() && super.isDisambiguated();
    }

    public MemberInstance memberInstance() {
        return this.ii;
    }

    public Flags flags() {
        return this.flags;
    }

    public Initializer flags(Flags flags) {
        if (flags.equals(this.flags)) {
            return this;
        }
        Initializer_c n = (Initializer_c)this.copy();
        n.flags = flags;
        return n;
    }

    public InitializerInstance initializerInstance() {
        return this.ii;
    }

    public CodeInstance codeInstance() {
        return this.initializerInstance();
    }

    public Initializer initializerInstance(InitializerInstance ii) {
        if (ii == this.ii) {
            return this;
        }
        Initializer_c n = (Initializer_c)this.copy();
        n.ii = ii;
        return n;
    }

    public Term codeBody() {
        return this.body;
    }

    public Block body() {
        return this.body;
    }

    public CodeBlock body(Block body) {
        Initializer_c n = (Initializer_c)this.copy();
        n.body = body;
        return n;
    }

    protected Initializer_c reconstruct(Block body) {
        if (body != this.body) {
            Initializer_c n = (Initializer_c)this.copy();
            n.body = body;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Block body = (Block)this.visitChild(this.body, v);
        return this.reconstruct(body);
    }

    public Context enterScope(Context c) {
        return c.pushCode(this.ii);
    }

    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        return tb.pushCode();
    }

    public Term firstChild() {
        return this.body();
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG(this.body(), this, 0);
        return succs;
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        ParsedClassType ct = tb.currentClass();
        InitializerInstance ii = ts.initializerInstance(this.position(), ct, this.flags);
        return this.initializerInstance(ii);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        try {
            ts.checkInitializerFlags(this.flags());
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        if (this.flags().isStatic() && this.initializerInstance().container().toClass().isInnerClass()) {
            throw new SemanticException("Inner classes cannot declare static initializers.", this.position());
        }
        return this;
    }

    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        if (this.initializerInstance().flags().isStatic()) {
            return ec.push(new ExceptionChecker.CodeTypeReporter("static initializer block"));
        }
        if (!this.initializerInstance().container().toClass().isAnonymous()) {
            ec = ec.push(new ExceptionChecker.CodeTypeReporter("instance initializer block"));
            SubtypeSet allowed = null;
            ClassType throwable = ec.typeSystem().Throwable();
            ClassType container = this.initializerInstance().container().toClass();
            Iterator iter = container.constructors().iterator();
            while (iter.hasNext()) {
                Type t;
                ConstructorInstance ci = (ConstructorInstance)iter.next();
                if (allowed == null) {
                    allowed = new SubtypeSet(throwable);
                    allowed.addAll((Collection)ci.throwTypes());
                    continue;
                }
                SubtypeSet other = new SubtypeSet(throwable);
                other.addAll((Collection)ci.throwTypes());
                SubtypeSet inter = new SubtypeSet(throwable);
                Iterator i = allowed.iterator();
                while (i.hasNext()) {
                    t = (Type)i.next();
                    if (!other.contains(t)) continue;
                    inter.add(t);
                }
                i = other.iterator();
                while (i.hasNext()) {
                    t = (Type)i.next();
                    if (!allowed.contains(t)) continue;
                    inter.add(t);
                }
                allowed = inter;
            }
            ec = ec.push(allowed);
            return ec;
        }
        return ec.push();
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        w.write(this.flags.translate());
        this.print(this.body, w, tr);
        w.end();
    }

    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.ii != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.ii + ")");
            w.end();
        }
    }

    public String toString() {
        return this.flags.translate() + "{ ... }";
    }

    public Node copy(NodeFactory nf) {
        return nf.Initializer(this.position, this.flags, this.body);
    }

    static {
        $assertionsDisabled = !Initializer_c.class.desiredAssertionStatus();
    }
}

