/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Id;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ConstantChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class LocalDecl_c
extends Stmt_c
implements LocalDecl {
    protected Flags flags;
    protected TypeNode type;
    protected Id name;
    protected Expr init;
    protected LocalInstance li;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LocalDecl_c(Position pos, Flags flags, TypeNode type, Id name, Expr init) {
        super(pos);
        if (!($assertionsDisabled || flags != null && type != null && name != null)) {
            throw new AssertionError();
        }
        this.flags = flags;
        this.type = type;
        this.name = name;
        this.init = init;
    }

    public boolean isDisambiguated() {
        return this.li != null && this.li.isCanonical() && super.isDisambiguated();
    }

    public Type declType() {
        return this.type.type();
    }

    public Flags flags() {
        return this.flags;
    }

    public LocalDecl flags(Flags flags) {
        if (flags.equals(this.flags)) {
            return this;
        }
        LocalDecl_c n = (LocalDecl_c)this.copy();
        n.flags = flags;
        return n;
    }

    public TypeNode type() {
        return this.type;
    }

    public LocalDecl type(TypeNode type) {
        if (type == this.type) {
            return this;
        }
        LocalDecl_c n = (LocalDecl_c)this.copy();
        n.type = type;
        return n;
    }

    public Id id() {
        return this.name;
    }

    public LocalDecl id(Id name) {
        LocalDecl_c n = (LocalDecl_c)this.copy();
        n.name = name;
        return n;
    }

    public String name() {
        return this.name.id();
    }

    public LocalDecl name(String name) {
        return this.id(this.name.id(name));
    }

    public Expr init() {
        return this.init;
    }

    public LocalDecl init(Expr init) {
        if (init == this.init) {
            return this;
        }
        LocalDecl_c n = (LocalDecl_c)this.copy();
        n.init = init;
        return n;
    }

    public LocalDecl localInstance(LocalInstance li) {
        if (li == this.li) {
            return this;
        }
        LocalDecl_c n = (LocalDecl_c)this.copy();
        n.li = li;
        return n;
    }

    public LocalInstance localInstance() {
        return this.li;
    }

    public VarInstance varInstance() {
        return this.li;
    }

    protected LocalDecl_c reconstruct(TypeNode type, Id name, Expr init) {
        if (this.type != type || this.name != name || this.init != init) {
            LocalDecl_c n = (LocalDecl_c)this.copy();
            n.type = type;
            n.name = name;
            n.init = init;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        TypeNode type = (TypeNode)this.visitChild(this.type, v);
        Id name = (Id)this.visitChild(this.name, v);
        Expr init = (Expr)this.visitChild(this.init, v);
        return this.reconstruct(type, name, init);
    }

    public Context enterChildScope(Node child, Context c) {
        if (child == this.init) {
            c.addVariable(this.li);
        }
        return super.enterChildScope(child, c);
    }

    public void addDecls(Context c) {
        c.addVariable(this.li);
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        LocalDecl_c n = (LocalDecl_c)super.buildTypes(tb);
        TypeSystem ts = tb.typeSystem();
        LocalInstance li = ts.localInstance(this.position(), this.flags(), ts.unknownType(this.position()), this.name());
        return n.localInstance(li);
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (this.li.isCanonical()) {
            return this;
        }
        if (this.declType().isCanonical()) {
            this.li.setType(this.declType());
        }
        return this;
    }

    public NodeVisitor typeCheckEnter(TypeChecker tc) throws SemanticException {
        Context c = tc.context();
        LocalInstance outerLocal = null;
        try {
            outerLocal = c.findLocal(this.li.name());
        }
        catch (SemanticException e) {
            // empty catch block
        }
        if (outerLocal != null && c.isLocal(this.li.name())) {
            throw new SemanticException("Local variable \"" + this.name + "\" multiply defined.  " + "Previous definition at " + outerLocal.position() + ".", this.position());
        }
        return super.typeCheckEnter(tc);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        LocalInstance li = this.li;
        try {
            ts.checkLocalFlags(this.flags);
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        if (this.init != null) {
            if (this.init instanceof ArrayInit) {
                ((ArrayInit)this.init).typeCheckElements(this.type.type());
            } else if (!(ts.isImplicitCastValid(this.init.type(), this.type.type()) || ts.typeEquals(this.init.type(), this.type.type()) || ts.numericConversionValid(this.type.type(), this.init.constantValue()))) {
                throw new SemanticException("The type of the variable initializer \"" + this.init.type() + "\" does not match that of " + "the declaration \"" + this.type.type() + "\".", this.init.position());
            }
        }
        return this.localInstance(li);
    }

    public Node checkConstants(ConstantChecker cc) throws SemanticException {
        if (this.init == null || !this.init.isConstant() || !this.li.flags().isFinal()) {
            this.li.setNotConstant();
        } else {
            this.li.setConstantValue(this.init.constantValue());
        }
        return this;
    }

    public boolean constantValueSet() {
        return this.li != null && this.li.constantValueSet();
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.init) {
            TypeSystem ts = av.typeSystem();
            if (ts.numericConversionValid(this.type.type(), child.constantValue())) {
                return child.type();
            }
            return this.type.type();
        }
        return child.type();
    }

    public String toString() {
        return this.flags.translate() + this.type + " " + this.name + (this.init != null ? " = " + this.init : "") + ";";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        boolean printSemi = tr.appendSemicolon(true);
        boolean printType = tr.printType(true);
        w.write(this.flags.translate());
        if (printType) {
            this.print(this.type, w, tr);
            w.write(" ");
        }
        tr.print(this, this.name, w);
        if (this.init != null) {
            w.write(" =");
            w.allowBreak(2, " ");
            this.print(this.init, w, tr);
        }
        if (printSemi) {
            w.write(";");
        }
        tr.printType(printType);
        tr.appendSemicolon(printSemi);
    }

    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.li != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.li + ")");
            w.end();
        }
    }

    public Term firstChild() {
        return this.type();
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.init() != null) {
            v.visitCFG(this.type(), this.init(), 1);
            v.visitCFG(this.init(), this, 0);
        } else {
            v.visitCFG(this.type(), this, 0);
        }
        return succs;
    }

    public Node copy(NodeFactory nf) {
        return nf.LocalDecl(this.position, this.flags, this.type, this.name, this.init);
    }

    static {
        $assertionsDisabled = !LocalDecl_c.class.desiredAssertionStatus();
    }

    protected static class AddDependenciesVisitor
    extends NodeVisitor {
        protected ConstantChecker cc;
        protected LocalInstance li;

        AddDependenciesVisitor(ConstantChecker cc, LocalInstance li) {
            this.cc = cc;
            this.li = li;
        }

        public Node leave(Node old, Node n, NodeVisitor v) {
            Local l;
            Field f;
            if (n instanceof Field && !(f = (Field)n).fieldInstance().orig().constantValueSet()) {
                Scheduler scheduler = this.cc.job().extensionInfo().scheduler();
                Goal g = scheduler.FieldConstantsChecked(f.fieldInstance().orig());
                throw new MissingDependencyException(g);
            }
            if (n instanceof Local && !(l = (Local)n).localInstance().orig().constantValueSet()) {
                this.li.setNotConstant();
            }
            return n;
        }
    }
}

