/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.CodeBlock;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.main.Report;
import polyglot.types.CodeInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.ProcedureInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class MethodDecl_c
extends Term_c
implements MethodDecl {
    protected Flags flags;
    protected TypeNode returnType;
    protected Id name;
    protected List formals;
    protected List throwTypes;
    protected Block body;
    protected MethodInstance mi;
    private static final Collection TOPICS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MethodDecl_c(Position pos, Flags flags, TypeNode returnType, Id name, List formals, List throwTypes, Block body) {
        super(pos);
        if (!($assertionsDisabled || flags != null && returnType != null && name != null && formals != null && throwTypes != null)) {
            throw new AssertionError();
        }
        this.flags = flags;
        this.returnType = returnType;
        this.name = name;
        this.formals = TypedList.copyAndCheck(formals, Formal.class, true);
        this.throwTypes = TypedList.copyAndCheck(throwTypes, TypeNode.class, true);
        this.body = body;
    }

    public boolean isDisambiguated() {
        return this.mi != null && this.mi.isCanonical() && super.isDisambiguated();
    }

    public MemberInstance memberInstance() {
        return this.mi;
    }

    public Flags flags() {
        return this.flags;
    }

    public MethodDecl flags(Flags flags) {
        if (flags.equals(this.flags)) {
            return this;
        }
        MethodDecl_c n = (MethodDecl_c)this.copy();
        n.flags = flags;
        return n;
    }

    public TypeNode returnType() {
        return this.returnType;
    }

    public MethodDecl returnType(TypeNode returnType) {
        MethodDecl_c n = (MethodDecl_c)this.copy();
        n.returnType = returnType;
        return n;
    }

    public Id id() {
        return this.name;
    }

    public MethodDecl id(Id name) {
        MethodDecl_c n = (MethodDecl_c)this.copy();
        n.name = name;
        return n;
    }

    public String name() {
        return this.name.id();
    }

    public MethodDecl name(String name) {
        return this.id(this.name.id(name));
    }

    public List formals() {
        return Collections.unmodifiableList(this.formals);
    }

    public MethodDecl formals(List formals) {
        MethodDecl_c n = (MethodDecl_c)this.copy();
        n.formals = TypedList.copyAndCheck(formals, Formal.class, true);
        return n;
    }

    public List throwTypes() {
        return Collections.unmodifiableList(this.throwTypes);
    }

    public MethodDecl throwTypes(List throwTypes) {
        MethodDecl_c n = (MethodDecl_c)this.copy();
        n.throwTypes = TypedList.copyAndCheck(throwTypes, TypeNode.class, true);
        return n;
    }

    public Term codeBody() {
        return this.body;
    }

    public Block body() {
        return this.body;
    }

    public CodeBlock body(Block body) {
        MethodDecl_c n = (MethodDecl_c)this.copy();
        n.body = body;
        return n;
    }

    public MethodInstance methodInstance() {
        return this.mi;
    }

    public MethodDecl methodInstance(MethodInstance mi) {
        if (mi == this.mi) {
            return this;
        }
        MethodDecl_c n = (MethodDecl_c)this.copy();
        n.mi = mi;
        return n;
    }

    public CodeInstance codeInstance() {
        return this.procedureInstance();
    }

    public ProcedureInstance procedureInstance() {
        return this.mi;
    }

    protected MethodDecl_c reconstruct(TypeNode returnType, Id name, List formals, List throwTypes, Block body) {
        if (returnType != this.returnType || name != this.name || !CollectionUtil.equals(formals, this.formals) || !CollectionUtil.equals(throwTypes, this.throwTypes) || body != this.body) {
            MethodDecl_c n = (MethodDecl_c)this.copy();
            n.returnType = returnType;
            n.name = name;
            n.formals = TypedList.copyAndCheck(formals, Formal.class, true);
            n.throwTypes = TypedList.copyAndCheck(throwTypes, TypeNode.class, true);
            n.body = body;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Id name = (Id)this.visitChild(this.name, v);
        List formals = this.visitList(this.formals, v);
        TypeNode returnType = (TypeNode)this.visitChild(this.returnType, v);
        List throwTypes = this.visitList(this.throwTypes, v);
        Block body = (Block)this.visitChild(this.body, v);
        return this.reconstruct(returnType, name, formals, throwTypes, body);
    }

    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        return tb.pushCode();
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        ParsedClassType ct = tb.currentClass();
        if (ct == null) {
            return this;
        }
        ArrayList<UnknownType> formalTypes = new ArrayList<UnknownType>(this.formals.size());
        for (int i = 0; i < this.formals.size(); ++i) {
            formalTypes.add(ts.unknownType(this.position()));
        }
        ArrayList<UnknownType> throwTypes = new ArrayList<UnknownType>(this.throwTypes().size());
        for (int i = 0; i < this.throwTypes().size(); ++i) {
            throwTypes.add(ts.unknownType(this.position()));
        }
        Flags f = this.flags;
        if (ct.flags().isInterface()) {
            f = f.Public().Abstract();
        }
        MethodInstance mi = ts.methodInstance(this.position(), ct, f, ts.unknownType(this.position()), this.name.id(), formalTypes, throwTypes);
        ct.addMethod(mi);
        return this.methodInstance(mi);
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (this.mi.isCanonical()) {
            return this;
        }
        if (!this.returnType.isDisambiguated()) {
            return this;
        }
        this.mi.setReturnType(this.returnType.type());
        LinkedList<Type> formalTypes = new LinkedList<Type>();
        LinkedList<Type> throwTypes = new LinkedList<Type>();
        Iterator i = this.formals.iterator();
        while (i.hasNext()) {
            Formal f = (Formal)i.next();
            if (!f.isDisambiguated()) {
                return this;
            }
            formalTypes.add(f.declType());
        }
        this.mi.setFormalTypes(formalTypes);
        i = this.throwTypes().iterator();
        while (i.hasNext()) {
            TypeNode tn = (TypeNode)i.next();
            if (!tn.isDisambiguated()) {
                return this;
            }
            throwTypes.add(tn.type());
        }
        this.mi.setThrowTypes(throwTypes);
        return this;
    }

    public Context enterScope(Context c) {
        if (Report.should_report(TOPICS, 5)) {
            Report.report(5, "enter scope of method " + this.name);
        }
        c = c.pushCode(this.mi);
        return c;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Flags flags = this.mi.flags();
        if (tc.context().currentClass().flags().isInterface() && (flags.isProtected() || flags.isPrivate())) {
            throw new SemanticException("Interface methods must be public.", this.position());
        }
        try {
            ts.checkMethodFlags(flags);
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        if (this.body == null && !flags.isAbstract() && !flags.isNative()) {
            throw new SemanticException("Missing method body.", this.position());
        }
        if (this.body != null && (flags.isAbstract() || flags.isNative())) {
            throw new SemanticException("An abstract method cannot have a body.", this.position());
        }
        if (this.body != null && flags.isNative()) {
            throw new SemanticException("A native method cannot have a body.", this.position());
        }
        Iterator i = this.throwTypes().iterator();
        while (i.hasNext()) {
            TypeNode tn = (TypeNode)i.next();
            Type t = tn.type();
            if (t.isThrowable()) continue;
            throw new SemanticException("Type \"" + t + "\" is not a subclass of \"" + ts.Throwable() + "\".", tn.position());
        }
        if (flags.isStatic() && this.methodInstance().container().toClass().isInnerClass()) {
            throw new SemanticException("Inner classes cannot declare static methods.", this.position());
        }
        this.overrideMethodCheck(tc);
        return this;
    }

    protected void overrideMethodCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Iterator j = this.mi.implemented().iterator();
        while (j.hasNext()) {
            MethodInstance mj = (MethodInstance)j.next();
            if (!ts.isAccessible((MemberInstance)mj, tc.context())) continue;
            ts.checkOverride(this.mi, mj);
        }
    }

    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        return ec.push(this.methodInstance().throwTypes());
    }

    public String toString() {
        return this.flags.translate() + this.returnType + " " + this.name + "(...)";
    }

    public void prettyPrintHeader(Flags flags, CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        w.write(flags.translate());
        this.print(this.returnType, w, tr);
        w.allowBreak(2, 2, " ", 1);
        w.write(this.name + "(");
        w.allowBreak(2, 2, "", 0);
        w.begin(0);
        Iterator i = this.formals.iterator();
        while (i.hasNext()) {
            Formal f = (Formal)i.next();
            this.print(f, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.end();
        w.write(")");
        if (!this.throwTypes().isEmpty()) {
            w.allowBreak(6);
            w.write("throws ");
            i = this.throwTypes().iterator();
            while (i.hasNext()) {
                TypeNode tn = (TypeNode)i.next();
                this.print(tn, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(4, " ");
            }
        }
        w.end();
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.prettyPrintHeader(this.flags(), w, tr);
        if (this.body != null) {
            this.printSubStmt(this.body, w, tr);
        } else {
            w.write(";");
        }
    }

    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.mi != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.mi + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name " + this.name + ")");
        w.end();
    }

    public Term firstChild() {
        return MethodDecl_c.listChild(this.formals(), this.returnType());
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFGList(this.formals(), this.returnType(), 1);
        if (this.body() == null) {
            v.visitCFG(this.returnType(), this, 0);
        } else {
            v.visitCFG(this.returnType(), this.body(), 1);
            v.visitCFG(this.body(), this, 0);
        }
        return succs;
    }

    public Node copy(NodeFactory nf) {
        return nf.MethodDecl(this.position, this.flags, this.returnType, this.name, this.formals, this.throwTypes, this.body);
    }

    static {
        $assertionsDisabled = !MethodDecl_c.class.desiredAssertionStatus();
        TOPICS = CollectionUtil.list("types", "context");
    }
}

