/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Ambiguous;
import polyglot.ast.Block;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.JL;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.NodeList;
import polyglot.ast.Stmt;
import polyglot.frontend.Compiler;
import polyglot.frontend.ExtensionInfo;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.StringUtil;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.ConstantChecker;
import polyglot.visit.DumpAst;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public abstract class Node_c
implements Node {
    protected Position position;
    protected JL del;
    protected Ext ext;
    protected boolean error;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Node_c(Position pos) {
        if (!$assertionsDisabled && pos == null) {
            throw new AssertionError();
        }
        this.position = pos;
        this.error = false;
    }

    public void init(Node node) {
        if (node != this) {
            throw new InternalCompilerError("Cannot use a Node as a delegate or extension.");
        }
    }

    public Node node() {
        return this;
    }

    public JL del() {
        return this.del != null ? this.del : this;
    }

    public Node del(JL del) {
        if (this.del == del) {
            return this;
        }
        JL old = this.del;
        this.del = null;
        Node_c n = (Node_c)this.copy();
        JL jL = n.del = del != this ? del : null;
        if (n.del != null) {
            n.del.init(n);
        }
        this.del = old;
        return n;
    }

    public Ext ext(int n) {
        if (n < 1) {
            throw new InternalCompilerError("n must be >= 1");
        }
        if (n == 1) {
            return this.ext();
        }
        return this.ext(n - 1).ext();
    }

    public Node ext(int n, Ext ext) {
        if (n < 1) {
            throw new InternalCompilerError("n must be >= 1");
        }
        if (n == 1) {
            return this.ext(ext);
        }
        Ext prev = this.ext(n - 1);
        if (prev == null) {
            throw new InternalCompilerError("cannot set the nth extension if there is no (n-1)st extension");
        }
        return this.ext(n - 1, prev.ext(ext));
    }

    public Ext ext() {
        return this.ext;
    }

    public Node ext(Ext ext) {
        if (this.ext == ext) {
            return this;
        }
        Ext old = this.ext;
        this.ext = null;
        Node_c n = (Node_c)this.copy();
        n.ext = ext;
        if (n.ext != null) {
            n.ext.init(n);
        }
        this.ext = old;
        return n;
    }

    public Object copy() {
        try {
            Node_c n = (Node_c)super.clone();
            if (this.del != null) {
                n.del = (JL)this.del.copy();
                n.del.init(n);
            }
            if (this.ext != null) {
                n.ext = (Ext)this.ext.copy();
                n.ext.init(n);
            }
            return n;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("Java clone() weirdness.");
        }
    }

    public Position position() {
        return this.position;
    }

    public Node position(Position position) {
        Node_c n = (Node_c)this.copy();
        n.position = position;
        return n;
    }

    public boolean isDisambiguated() {
        return !(this instanceof Ambiguous);
    }

    public boolean isTypeChecked() {
        return this.isDisambiguated();
    }

    public boolean error() {
        return this.error;
    }

    public Node error(boolean flag) {
        Node_c n = (Node_c)this.copy();
        n.error = flag;
        return n;
    }

    public Node visitChild(Node n, NodeVisitor v) {
        if (n == null) {
            return null;
        }
        return v.visitEdge(this, n);
    }

    public Node visit(NodeVisitor v) {
        return v.visitEdge(null, this);
    }

    public Node visitEdge(Node parent, NodeVisitor v) {
        Node n = v.override(parent, this);
        if (n == null) {
            NodeVisitor v_ = v.enter(parent, this);
            if (v_ == null) {
                throw new InternalCompilerError("NodeVisitor.enter() returned null.");
            }
            n = this.del().visitChildren(v_);
            if (n == null) {
                throw new InternalCompilerError("Node_c.visitChildren() returned null.");
            }
            if ((n = v.leave(parent, this, n, v_)) == null) {
                throw new InternalCompilerError("NodeVisitor.leave() returned null.");
            }
        }
        return n;
    }

    public List visitList(List l, NodeVisitor v) {
        if (l == null) {
            return null;
        }
        ArrayList<Node> result = l;
        ArrayList<Node> vl = new ArrayList<Node>(l.size());
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Node m;
            Node n = (Node)i.next();
            if (n != (m = this.visitChild(n, v))) {
                result = vl;
            }
            if (m instanceof NodeList) {
                vl.addAll(((NodeList)m).nodes());
                continue;
            }
            if (m == null) continue;
            vl.add(m);
        }
        return result;
    }

    public Node visitChildren(NodeVisitor v) {
        return this;
    }

    public Context enterScope(Context c) {
        return c;
    }

    public Context enterChildScope(Node child, Context c) {
        return child.del().enterScope(c);
    }

    public void addDecls(Context c) {
    }

    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        return tb;
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        return this;
    }

    public Node disambiguateOverride(Node parent, AmbiguityRemover ar) throws SemanticException {
        return null;
    }

    public NodeVisitor disambiguateEnter(AmbiguityRemover ar) throws SemanticException {
        return ar;
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        return this;
    }

    public Node typeCheckOverride(Node parent, TypeChecker tc) throws SemanticException {
        return null;
    }

    public NodeVisitor typeCheckEnter(TypeChecker tc) throws SemanticException {
        return tc;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        return this;
    }

    public Node checkConstants(ConstantChecker cc) throws SemanticException {
        return this;
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        return child.type();
    }

    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        return ec.push();
    }

    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        List l = this.del().throwTypes(ec.typeSystem());
        Iterator i = l.iterator();
        while (i.hasNext()) {
            ec.throwsException((Type)i.next(), this.position());
        }
        return this;
    }

    public List throwTypes(TypeSystem ts) {
        return Collections.EMPTY_LIST;
    }

    public void dump(OutputStream os) {
        CodeWriter cw = Compiler.createCodeWriter(os);
        NodeVisitor dumper = new DumpAst(cw);
        dumper = dumper.begin();
        this.visit(dumper);
        cw.newline();
        dumper.finish();
    }

    public void dump(Writer w) {
        CodeWriter cw = Compiler.createCodeWriter(w);
        NodeVisitor dumper = new DumpAst(cw);
        dumper = dumper.begin();
        this.visit(dumper);
        cw.newline();
        dumper.finish();
    }

    public void prettyPrint(OutputStream os) {
        try {
            CodeWriter cw = Compiler.createCodeWriter(os);
            this.del().prettyPrint(cw, new PrettyPrinter());
            cw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void prettyPrint(Writer w) {
        try {
            CodeWriter cw = Compiler.createCodeWriter(w);
            this.del().prettyPrint(cw, new PrettyPrinter());
            cw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter pp) {
    }

    public void printBlock(Node n, CodeWriter w, PrettyPrinter pp) {
        w.begin(0);
        this.print(n, w, pp);
        w.end();
    }

    public void printSubStmt(Stmt stmt, CodeWriter w, PrettyPrinter pp) {
        if (stmt instanceof Block) {
            w.write(" ");
            this.print(stmt, w, pp);
        } else {
            w.allowBreak(4, " ");
            this.printBlock(stmt, w, pp);
        }
    }

    public void print(Node child, CodeWriter w, PrettyPrinter pp) {
        pp.print(this, child, w);
    }

    public void translate(CodeWriter w, Translator tr) {
        this.del().prettyPrint(w, tr);
    }

    public void dump(CodeWriter w) {
        w.write(StringUtil.getShortNameComponent(this.getClass().getName()));
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(del ");
        if (this.del() == this) {
            w.write("*");
        } else {
            w.write(this.del().toString());
        }
        w.write(")");
        w.end();
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(ext ");
        if (this.ext() == null) {
            w.write("null");
        } else {
            this.ext().dump(w);
        }
        w.write(")");
        w.end();
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(position " + (this.position != null ? this.position.toString() : "UNKNOWN") + ")");
        w.end();
    }

    public String toString() {
        return this.getClass().getName();
    }

    public Node copy(NodeFactory nf) {
        throw new InternalCompilerError("Unimplemented operation. This class (" + this.getClass().getName() + ") does " + "not implement copy(NodeFactory). This compiler extension should" + " either implement the method, or not invoke this method.");
    }

    public Node copy(ExtensionInfo extInfo) throws SemanticException {
        return this.del().copy(extInfo.nodeFactory());
    }

    static {
        $assertionsDisabled = !Node_c.class.desiredAssertionStatus();
    }
}

