/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import polyglot.ast.Block;
import polyglot.ast.Catch;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.ast.Try;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.SubtypeSet;
import polyglot.util.TypedList;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class Try_c
extends Stmt_c
implements Try {
    protected Block tryBlock;
    protected List catchBlocks;
    protected Block finallyBlock;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Try_c(Position pos, Block tryBlock, List catchBlocks, Block finallyBlock) {
        super(pos);
        if (!($assertionsDisabled || tryBlock != null && catchBlocks != null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && catchBlocks.isEmpty() && finallyBlock == null) {
            throw new AssertionError();
        }
        this.tryBlock = tryBlock;
        this.catchBlocks = TypedList.copyAndCheck(catchBlocks, Catch.class, true);
        this.finallyBlock = finallyBlock;
    }

    public Block tryBlock() {
        return this.tryBlock;
    }

    public Try tryBlock(Block tryBlock) {
        Try_c n = (Try_c)this.copy();
        n.tryBlock = tryBlock;
        return n;
    }

    public List catchBlocks() {
        return Collections.unmodifiableList(this.catchBlocks);
    }

    public Try catchBlocks(List catchBlocks) {
        Try_c n = (Try_c)this.copy();
        n.catchBlocks = TypedList.copyAndCheck(catchBlocks, Catch.class, true);
        return n;
    }

    public Block finallyBlock() {
        return this.finallyBlock;
    }

    public Try finallyBlock(Block finallyBlock) {
        Try_c n = (Try_c)this.copy();
        n.finallyBlock = finallyBlock;
        return n;
    }

    protected Try_c reconstruct(Block tryBlock, List catchBlocks, Block finallyBlock) {
        if (tryBlock != this.tryBlock || !CollectionUtil.equals(catchBlocks, this.catchBlocks) || finallyBlock != this.finallyBlock) {
            Try_c n = (Try_c)this.copy();
            n.tryBlock = tryBlock;
            n.catchBlocks = TypedList.copyAndCheck(catchBlocks, Catch.class, true);
            n.finallyBlock = finallyBlock;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Block tryBlock = (Block)this.visitChild(this.tryBlock, v);
        List catchBlocks = this.visitList(this.catchBlocks, v);
        Block finallyBlock = (Block)this.visitChild(this.finallyBlock, v);
        return this.reconstruct(tryBlock, catchBlocks, finallyBlock);
    }

    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        ec = (ExceptionChecker)super.exceptionCheckEnter(ec);
        return ec.bypassChildren(this);
    }

    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        TypeSystem ts = ec.typeSystem();
        ExceptionChecker origEC = ec;
        if (this.finallyBlock != null && !this.finallyBlock.reachable()) {
            ec = ec.pushCatchAllThrowable();
        }
        ExceptionChecker newec = ec.push();
        ListIterator i = this.catchBlocks.listIterator(this.catchBlocks.size());
        while (i.hasPrevious()) {
            Catch cb = (Catch)i.previous();
            Type catchType = cb.catchType();
            newec = newec.push(catchType);
        }
        Block tryBlock = (Block)this.visitChild(this.tryBlock, newec);
        SubtypeSet caught = new SubtypeSet(ts.Throwable());
        Iterator i2 = this.catchBlocks.iterator();
        while (i2.hasNext()) {
            Catch cb = (Catch)i2.next();
            Type catchType = cb.catchType();
            if (caught.contains(catchType)) {
                throw new SemanticException("The exception \"" + catchType + "\" has been caught by an earlier catch block.", cb.position());
            }
            caught.add(catchType);
        }
        ArrayList<Catch> catchBlocks = new ArrayList<Catch>(this.catchBlocks.size());
        Iterator i3 = this.catchBlocks.iterator();
        while (i3.hasNext()) {
            Catch cb = (Catch)i3.next();
            ec = ec.push();
            cb = (Catch)this.visitChild(cb, ec);
            catchBlocks.add(cb);
            ec = ec.pop();
        }
        Block finallyBlock = null;
        if (this.finallyBlock != null) {
            ec = origEC;
            finallyBlock = (Block)this.visitChild(this.finallyBlock, ec);
            if (!this.finallyBlock.reachable()) {
                // empty if block
            }
            ec = ec.pop();
        }
        Try_c t = (Try_c)super.exceptionCheck(ec);
        return t.reconstruct(tryBlock, catchBlocks, finallyBlock);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("try ");
        sb.append(this.tryBlock.toString());
        int count = 0;
        Iterator it = this.catchBlocks.iterator();
        while (it.hasNext()) {
            Catch cb = (Catch)it.next();
            if (count++ > 2) {
                sb.append("...");
                break;
            }
            sb.append(" ");
            sb.append(cb.toString());
        }
        if (this.finallyBlock != null) {
            sb.append(" finally ");
            sb.append(this.finallyBlock.toString());
        }
        return sb.toString();
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("try");
        this.printSubStmt(this.tryBlock, w, tr);
        Iterator it = this.catchBlocks.iterator();
        while (it.hasNext()) {
            Catch cb = (Catch)it.next();
            w.newline(0);
            this.printBlock(cb, w, tr);
        }
        if (this.finallyBlock != null) {
            w.newline(0);
            w.write("finally");
            this.printSubStmt(this.finallyBlock, w, tr);
        }
    }

    public Term firstChild() {
        return this.tryBlock;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        TypeSystem ts = v.typeSystem();
        CFGBuilder v1 = v.push(this, false);
        CFGBuilder v2 = v.push(this, true);
        Iterator i = ts.uncheckedExceptions().iterator();
        while (i.hasNext()) {
            Type type = (Type)i.next();
            v1.visitThrow(this.tryBlock, 1, type);
        }
        if (this.finallyBlock != null) {
            v1.visitCFG(this.tryBlock, this.finallyBlock, 1);
            v.visitCFG(this.finallyBlock, this, 0);
        } else {
            v1.visitCFG(this.tryBlock, this, 0);
        }
        Iterator it = this.catchBlocks.iterator();
        while (it.hasNext()) {
            Catch cb = (Catch)it.next();
            if (this.finallyBlock != null) {
                v2.visitCFG(cb, this.finallyBlock, 1);
                continue;
            }
            v2.visitCFG(cb, this, 0);
        }
        return succs;
    }

    public Node copy(NodeFactory nf) {
        return nf.Try(this.position, this.tryBlock, this.catchBlocks, this.finallyBlock);
    }

    static {
        $assertionsDisabled = !Try_c.class.desiredAssertionStatus();
    }
}

