/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Loop_c;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.NodeList;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ast.While;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class While_c
extends Loop_c
implements While {
    protected Expr cond;
    protected Stmt body;
    static final /* synthetic */ boolean $assertionsDisabled;

    public While_c(Position pos, Expr cond, Stmt body) {
        super(pos);
        if (!($assertionsDisabled || cond != null && body != null)) {
            throw new AssertionError();
        }
        this.cond = cond;
        this.body = body;
    }

    public Expr cond() {
        return this.cond;
    }

    public While cond(Expr cond) {
        While_c n = (While_c)this.copy();
        n.cond = cond;
        return n;
    }

    public Stmt body() {
        return this.body;
    }

    public While body(Stmt body) {
        While_c n = (While_c)this.copy();
        n.body = body;
        return n;
    }

    protected While_c reconstruct(Expr cond, Stmt body) {
        if (cond != this.cond || body != this.body) {
            While_c n = (While_c)this.copy();
            n.cond = cond;
            n.body = body;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr cond = (Expr)this.visitChild(this.cond, v);
        Node body = this.visitChild(this.body, v);
        if (body instanceof NodeList) {
            body = ((NodeList)body).toBlock();
        }
        return this.reconstruct(cond, (Stmt)body);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!ts.typeEquals(this.cond.type(), ts.Boolean())) {
            throw new SemanticException("Condition of while statement must have boolean type.", this.cond.position());
        }
        return this;
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.cond) {
            return ts.Boolean();
        }
        return child.type();
    }

    public String toString() {
        return "while (" + this.cond + ") ...";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("while (");
        this.printBlock(this.cond, w, tr);
        w.write(")");
        this.printSubStmt(this.body, w, tr);
    }

    public Term firstChild() {
        return this.cond;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.condIsConstantTrue()) {
            v.visitCFG(this.cond, this.body, 1);
        } else {
            v.visitCFG(this.cond, FlowGraph.EDGE_KEY_TRUE, this.body, 1, FlowGraph.EDGE_KEY_FALSE, this, 0);
        }
        v.push(this).visitCFG(this.body, this.cond, 1);
        return succs;
    }

    public Term continueTarget() {
        return this.cond;
    }

    public Node copy(NodeFactory nf) {
        return nf.While(this.position, this.cond, this.body);
    }

    static {
        $assertionsDisabled = !While_c.class.desiredAssertionStatus();
    }
}

