/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import polyglot.frontend.Pass;
import polyglot.frontend.goals.Goal;
import polyglot.util.StringUtil;

public abstract class AbstractPass
implements Pass {
    protected Goal goal;
    protected long exclusive_time = 0L;
    protected long inclusive_time = 0L;

    public AbstractPass(Goal goal) {
        this.goal = goal;
    }

    public Goal goal() {
        return this.goal;
    }

    public String name() {
        return StringUtil.getShortNameComponent(this.getClass().getName());
    }

    public abstract boolean run();

    public void toggleTimers(boolean exclusive_only) {
        if (!exclusive_only) {
            this.inclusive_time = System.currentTimeMillis() - this.inclusive_time;
        }
        this.exclusive_time = System.currentTimeMillis() - this.exclusive_time;
    }

    public void resetTimers() {
        this.inclusive_time = 0L;
        this.exclusive_time = 0L;
    }

    public long exclusiveTime() {
        return this.exclusive_time;
    }

    public long inclusiveTime() {
        return this.inclusive_time;
    }

    public String toString() {
        return this.name();
    }
}

