/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.FileSource;
import polyglot.main.Report;
import polyglot.util.InternalCompilerError;

public class SourceLoader {
    protected ExtensionInfo sourceExt;
    protected Collection sourcePath;
    protected int caseInsensitive;
    protected Map loadedSources;
    protected Map directoryContentsCache;
    protected static File current_dir = null;

    public SourceLoader(ExtensionInfo sourceExt, Collection sourcePath) {
        this.sourcePath = sourcePath;
        this.sourceExt = sourceExt;
        this.directoryContentsCache = new HashMap();
        this.caseInsensitive = 0;
        this.loadedSources = new HashMap();
    }

    public FileSource fileSource(String fileName) throws IOException {
        return this.fileSource(fileName, false);
    }

    public FileSource fileSource(String fileName, boolean userSpecified) throws IOException {
        FileSource s;
        this.setCaseInsensitive(fileName);
        File sourceFile = new File(fileName);
        if (!sourceFile.exists()) {
            throw new FileNotFoundException(fileName);
        }
        String[] exts = this.sourceExt.fileExtensions();
        boolean ok = false;
        for (int i = 0; i < exts.length; ++i) {
            String ext = exts[i];
            if (!fileName.endsWith("." + ext)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            String extString = "";
            for (int i = 0; i < exts.length; ++i) {
                if (exts.length == 2 && i == exts.length - 1) {
                    extString = extString + " or ";
                } else if (exts.length != 1 && i == exts.length - 1) {
                    extString = extString + ", or ";
                } else if (i != 0) {
                    extString = extString + ", ";
                }
                extString = extString + "\"." + exts[i] + "\"";
            }
            if (exts.length == 1) {
                throw new IOException("Source \"" + fileName + "\" does not have the extension " + extString + ".");
            }
            throw new IOException("Source \"" + fileName + "\" does not have any of the extensions " + extString + ".");
        }
        if (Report.should_report("loader", 2)) {
            Report.report(2, "Loading class from " + sourceFile);
        }
        if ((s = (FileSource)this.loadedSources.get(this.fileKey(sourceFile))) != null) {
            if (!s.userSpecified && userSpecified) {
                s.setUserSpecified(true);
            }
            return s;
        }
        s = this.sourceExt.createFileSource(sourceFile, userSpecified);
        this.loadedSources.put(this.fileKey(sourceFile), s);
        return s;
    }

    protected static File current_dir() {
        if (current_dir == null) {
            current_dir = new File(System.getProperty("user.dir"));
        }
        return current_dir;
    }

    public boolean packageExists(String name) {
        String fileName = name.replace('.', File.separatorChar);
        Iterator i = this.sourcePath.iterator();
        while (i.hasNext()) {
            File directory = (File)i.next();
            File f = new File(directory, fileName);
            if (!f.exists() || !f.isDirectory()) continue;
            return true;
        }
        return false;
    }

    public FileSource classSource(String className) {
        String name = className;
        boolean done = false;
        while (!done) {
            FileSource source = this.checkForSource(name);
            if (source != null) {
                return source;
            }
            int dot = name.lastIndexOf(46);
            if (dot == -1) {
                done = true;
                continue;
            }
            name = name.substring(0, dot);
        }
        return null;
    }

    private FileSource checkForSource(String className) {
        String[] exts = this.sourceExt.fileExtensions();
        for (int k = 0; k < exts.length; ++k) {
            String fileName = className.replace('.', File.separatorChar) + "." + exts[k];
            Iterator i = this.sourcePath.iterator();
            while (i.hasNext()) {
                String firstPart;
                int index;
                File directory = (File)i.next();
                if (!directory.isDirectory()) continue;
                HashSet<String> dirContents = (HashSet<String>)this.directoryContentsCache.get(directory);
                if (dirContents == null) {
                    dirContents = new HashSet<String>();
                    this.directoryContentsCache.put(directory, dirContents);
                    if (directory.exists()) {
                        String[] contents = directory.list();
                        if (contents == null) continue;
                        for (int j = 0; j < contents.length; ++j) {
                            dirContents.add(contents[j]);
                        }
                    }
                }
                if ((index = fileName.indexOf(File.separatorChar)) < 0) {
                    index = fileName.length();
                }
                if (!dirContents.contains(firstPart = fileName.substring(0, index))) continue;
                File sourceFile = directory != null && directory.equals(SourceLoader.current_dir()) ? new File(fileName) : new File(directory, fileName);
                FileSource s = (FileSource)this.loadedSources.get(this.fileKey(sourceFile));
                if (s != null) {
                    return s;
                }
                try {
                    if (Report.should_report("loader", 2)) {
                        Report.report(2, "Loading " + className + " from " + sourceFile);
                    }
                    s = this.sourceExt.createFileSource(sourceFile, false);
                    this.loadedSources.put(this.fileKey(sourceFile), s);
                    return s;
                }
                catch (IOException e) {
                }
            }
        }
        return null;
    }

    public Object fileKey(File file) {
        this.setCaseInsensitive(file.getAbsolutePath());
        if (this.caseInsensitive()) {
            return file.getAbsolutePath().toLowerCase();
        }
        return file.getAbsolutePath();
    }

    public boolean caseInsensitive() {
        if (this.caseInsensitive == 0) {
            throw new InternalCompilerError("unknown case sensitivity");
        }
        return this.caseInsensitive == 1;
    }

    protected void setCaseInsensitive(String fileName) {
        File f2;
        if (this.caseInsensitive != 0) {
            return;
        }
        File f1 = new File(fileName.toUpperCase());
        if (f1.equals(f2 = new File(fileName.toLowerCase()))) {
            this.caseInsensitive = 1;
        } else if (f1.exists() && f2.exists()) {
            boolean f1Exists = false;
            boolean f2Exists = false;
            File dir = f1.getParent() != null ? new File(f1.getParent()) : SourceLoader.current_dir();
            File[] ls = dir.listFiles();
            if (ls != null) {
                for (int i = 0; i < ls.length; ++i) {
                    if (f1.equals(ls[i])) {
                        f1Exists = true;
                    }
                    if (!f2.equals(ls[i])) continue;
                    f2Exists = true;
                }
            }
            this.caseInsensitive = !f1Exists || !f2Exists ? 1 : -1;
        } else {
            this.caseInsensitive = -1;
        }
    }

    protected String canonicalize(String fileName) {
        return fileName;
    }
}

