/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend.goals;

import java.util.ArrayList;
import java.util.Collection;
import polyglot.frontend.AbstractPass;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Pass;
import polyglot.frontend.Scheduler;
import polyglot.frontend.SchedulerException;
import polyglot.frontend.goals.ClassTypeGoal;
import polyglot.frontend.goals.Goal;
import polyglot.frontend.passes.DisambiguateSignaturesPass;
import polyglot.types.ParsedClassType;

public class SignaturesResolved
extends ClassTypeGoal {
    public static Goal create(Scheduler scheduler, ParsedClassType ct) {
        return scheduler.internGoal(new SignaturesResolved(ct));
    }

    protected SignaturesResolved(ParsedClassType ct) {
        super(ct);
    }

    public Pass createPass(ExtensionInfo extInfo) {
        if (this.job() != null) {
            return new SignaturesResolvedPass(this);
        }
        return new DisambiguateSignaturesPass(extInfo.scheduler(), this);
    }

    public Collection prerequisiteGoals(Scheduler scheduler) {
        ArrayList<Goal> l = new ArrayList<Goal>();
        if (this.ct.job() != null) {
            l.add(scheduler.TypesInitialized(this.ct.job()));
        }
        l.add(scheduler.SupertypesResolved(this.ct));
        l.addAll(super.prerequisiteGoals(scheduler));
        return l;
    }

    protected boolean isGlobal(ParsedClassType ct) {
        return ct.isTopLevel() || ct.isMember() && this.isGlobal((ParsedClassType)ct.container());
    }

    public Collection corequisiteGoals(Scheduler scheduler) {
        ArrayList<Goal> l = new ArrayList<Goal>();
        if (this.ct.job() != null) {
            if (this.isGlobal(this.ct)) {
                l.add(scheduler.SignaturesDisambiguated(this.ct.job()));
            } else {
                l.add(scheduler.Disambiguated(this.ct.job()));
            }
        }
        l.addAll(super.corequisiteGoals(scheduler));
        return l;
    }

    public boolean equals(Object o) {
        return o instanceof SignaturesResolved && super.equals(o);
    }

    protected static class SignaturesResolvedPass
    extends AbstractPass {
        SignaturesResolvedPass(Goal goal) {
            super(goal);
        }

        public boolean run() {
            SignaturesResolved goal = (SignaturesResolved)this.goal;
            if (!goal.type().signaturesResolved()) {
                throw new SchedulerException();
            }
            return true;
        }
    }
}

