/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend.goals;

import java.util.ArrayList;
import java.util.Collection;
import polyglot.frontend.AbstractPass;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Pass;
import polyglot.frontend.Scheduler;
import polyglot.frontend.SchedulerException;
import polyglot.frontend.goals.ClassTypeGoal;
import polyglot.frontend.goals.Goal;
import polyglot.frontend.passes.ResolveSuperTypesPass;
import polyglot.types.ParsedClassType;

public class SupertypesResolved
extends ClassTypeGoal {
    public static Goal create(Scheduler scheduler, ParsedClassType ct) {
        return scheduler.internGoal(new SupertypesResolved(ct));
    }

    protected SupertypesResolved(ParsedClassType ct) {
        super(ct);
    }

    public Pass createPass(ExtensionInfo extInfo) {
        if (this.job() != null) {
            return new SupertypesResolvedPass(this);
        }
        return new ResolveSuperTypesPass(extInfo.scheduler(), this);
    }

    public Collection prerequisiteGoals(Scheduler scheduler) {
        ArrayList<Goal> l = new ArrayList<Goal>();
        l.add(scheduler.MembersAdded(this.ct));
        if (this.ct.job() != null) {
            l.add(scheduler.TypesInitialized(this.ct.job()));
        }
        l.addAll(super.prerequisiteGoals(scheduler));
        return l;
    }

    protected boolean isGlobal(ParsedClassType ct) {
        return ct.isTopLevel() || ct.isMember() && this.isGlobal((ParsedClassType)ct.container());
    }

    public Collection corequisiteGoals(Scheduler scheduler) {
        ArrayList<Goal> l = new ArrayList<Goal>();
        if (this.ct.job() != null) {
            if (this.isGlobal(this.ct)) {
                l.add(scheduler.SupertypesDisambiguated(this.ct.job()));
            } else {
                l.add(scheduler.Disambiguated(this.ct.job()));
            }
        }
        l.addAll(super.corequisiteGoals(scheduler));
        return l;
    }

    public boolean equals(Object o) {
        return o instanceof SupertypesResolved && super.equals(o);
    }

    protected static class SupertypesResolvedPass
    extends AbstractPass {
        SupertypesResolvedPass(Goal goal) {
            super(goal);
        }

        public boolean run() {
            SupertypesResolved goal = (SupertypesResolved)this.goal;
            if (!goal.type().supertypesResolved()) {
                throw new SchedulerException();
            }
            return true;
        }
    }
}

