/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import polyglot.main.Report;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.Package;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.StringUtil;

public class ImportTable
implements Resolver {
    protected TypeSystem ts;
    protected List packageImports;
    protected Map map;
    protected List lazyImports;
    protected List lazyImportPositions;
    protected List classImports;
    protected String sourceName;
    protected Position sourcePos;
    protected Package pkg;
    private static final Object NOT_FOUND = "NOT FOUND";
    private static final Collection TOPICS = CollectionUtil.list("types", "resolver", "imports");

    public ImportTable(TypeSystem ts, Package pkg) {
        this(ts, pkg, null);
    }

    public ImportTable(TypeSystem ts, Package pkg, String src) {
        this.ts = ts;
        this.sourceName = src;
        this.sourcePos = src != null ? new Position(null, src) : null;
        this.pkg = pkg;
        this.map = new HashMap();
        this.packageImports = new ArrayList();
        this.lazyImports = new ArrayList();
        this.lazyImportPositions = new ArrayList();
        this.classImports = new ArrayList();
    }

    public Package package_() {
        return this.pkg;
    }

    public void addClassImport(String className) {
        this.addClassImport(className, null);
    }

    public void addClassImport(String className, Position pos) {
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, this + ": lazy import " + className);
        }
        this.lazyImports.add(className);
        this.lazyImportPositions.add(pos);
        this.classImports.add(className);
    }

    public void addPackageImport(String pkgName, Position pos) {
        this.addPackageImport(pkgName);
    }

    public void addPackageImport(String pkgName) {
        if (this.pkg != null && this.pkg.fullName().equals(pkgName) || this.ts.defaultPackageImports().contains(pkgName) || this.packageImports.contains(pkgName)) {
            return;
        }
        this.packageImports.add(pkgName);
    }

    public List packageImports() {
        return this.packageImports;
    }

    public List classImports() {
        return this.classImports;
    }

    public String sourceName() {
        return this.sourceName;
    }

    protected Named cachedFind(String name) throws SemanticException {
        Object res = this.map.get(name);
        if (res != null) {
            return (Named)res;
        }
        Named t = this.ts.systemResolver().find(name);
        this.map.put(name, t);
        return t;
    }

    public Named find(String name) throws SemanticException {
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, this + ".find(" + name + ")");
        }
        this.lazyImport();
        if (!StringUtil.isNameShort(name)) {
            return this.ts.systemResolver().find(name);
        }
        Object res = this.map.get(name);
        if (res != null) {
            if (res == NOT_FOUND) {
                throw new NoClassException(name, this.sourcePos);
            }
            return (Named)res;
        }
        try {
            Named n;
            if (this.pkg != null && (n = this.findInPkg(name, this.pkg.fullName())) != null) {
                if (Report.should_report(TOPICS, 3)) {
                    Report.report(3, this + ".find(" + name + "): found in current package");
                }
                this.map.put(name, n);
                return n;
            }
            ArrayList imports = new ArrayList(this.packageImports.size() + 5);
            imports.addAll(this.ts.defaultPackageImports());
            imports.addAll(this.packageImports);
            Named resolved = null;
            Iterator iter = imports.iterator();
            while (iter.hasNext()) {
                String pkgName = (String)iter.next();
                Named n2 = this.findInPkg(name, pkgName);
                if (n2 == null) continue;
                if (resolved == null) {
                    resolved = n2;
                    continue;
                }
                throw new SemanticException("Reference to \"" + name + "\" is ambiguous; both " + resolved.fullName() + " and " + n2.fullName() + " match.");
            }
            if (resolved == null && !this.isVisibleFrom(resolved = this.ts.systemResolver().find(name), "")) {
                throw new NoClassException(name, this.sourcePos);
            }
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, this + ".find(" + name + "): found as " + resolved.fullName());
            }
            this.map.put(name, resolved);
            return resolved;
        }
        catch (NoClassException e) {
            if (Report.should_report(TOPICS, 3)) {
                Report.report(3, this + ".find(" + name + "): didn't find it");
            }
            this.map.put(name, NOT_FOUND);
            throw e;
        }
    }

    protected Named findInPkg(String name, String pkgName) throws SemanticException {
        String fullName = pkgName + "." + name;
        try {
            Named n = this.ts.systemResolver().find(fullName);
            if (this.isVisibleFrom(n, pkgName)) {
                return n;
            }
        }
        catch (NoClassException ex) {
            // empty catch block
        }
        return null;
    }

    protected boolean isVisibleFrom(Named n, String pkgName) {
        Type t;
        boolean inSamePackage;
        boolean isVisible = false;
        boolean bl = inSamePackage = this.pkg != null && this.pkg.fullName().equals(pkgName) || this.pkg == null && pkgName.equals("");
        isVisible = n instanceof Type ? !(t = (Type)((Object)n)).isClass() || t.toClass().flags().isPublic() || inSamePackage : true;
        return isVisible;
    }

    protected void lazyImport() throws SemanticException {
        if (this.lazyImports.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.lazyImports.size(); ++i) {
            String longName = (String)this.lazyImports.get(i);
            if (Report.should_report(TOPICS, 2)) {
                Report.report(2, this + ": import " + longName);
            }
            try {
                Named t = this.ts.systemResolver().find(longName);
                String shortName = StringUtil.getShortNameComponent(longName);
                this.map.put(shortName, t);
                continue;
            }
            catch (SemanticException e) {
                if (e.position == null) {
                    e.position = (Position)this.lazyImportPositions.get(i);
                }
                if (e.position == null) {
                    e.position = this.sourcePos;
                }
                throw e;
            }
        }
        this.lazyImports = new ArrayList();
        this.lazyImportPositions = new ArrayList();
    }

    public String toString() {
        if (this.sourceName != null) {
            return "(import " + this.sourceName + ")";
        }
        return "(import)";
    }
}

