/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.frontend.Job;
import polyglot.frontend.Scheduler;
import polyglot.frontend.Source;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.ClassType_c;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LazyClassInitializer;
import polyglot.types.LazyInitializer;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Package;
import polyglot.types.ParsedClassType;
import polyglot.types.PlaceHolder;
import polyglot.types.ReferenceType;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypeInputStream;
import polyglot.util.TypedList;

public class ParsedClassType_c
extends ClassType_c
implements ParsedClassType {
    protected transient LazyClassInitializer init;
    protected transient Source fromSource;
    protected transient Job job;
    protected Type superType;
    protected List interfaces;
    protected List methods;
    protected List fields;
    protected List constructors;
    protected Package package_;
    protected Flags flags;
    protected ClassType.Kind kind;
    protected String name;
    protected ClassType outer;
    protected transient List memberClasses;
    protected boolean inStaticContext = false;
    protected boolean needSerialization = true;
    protected boolean membersAdded;
    protected boolean supertypesResolved;
    protected boolean signaturesResolved;

    public LazyClassInitializer init() {
        return this.init;
    }

    public void setInit(LazyClassInitializer init) {
        this.init = init;
    }

    protected ParsedClassType_c() {
    }

    public ParsedClassType_c(TypeSystem ts, LazyClassInitializer init, Source fromSource) {
        super(ts);
        this.fromSource = fromSource;
        this.setInitializer(init);
        this.interfaces = new TypedList(new LinkedList(), Type.class, false);
        this.methods = new TypedList(new LinkedList(), MethodInstance.class, false);
        this.fields = new TypedList(new LinkedList(), FieldInstance.class, false);
        this.constructors = new TypedList(new LinkedList(), ConstructorInstance.class, false);
        this.memberClasses = new TypedList(new LinkedList(), Type.class, false);
    }

    public LazyInitializer initializer() {
        return this.init;
    }

    public void setInitializer(LazyInitializer init) {
        this.init = (LazyClassInitializer)init;
        ((LazyClassInitializer)init).setClass(this);
    }

    public Source fromSource() {
        return this.fromSource;
    }

    public Job job() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public ClassType.Kind kind() {
        return this.kind;
    }

    public void inStaticContext(boolean inStaticContext) {
        this.inStaticContext = inStaticContext;
    }

    public boolean inStaticContext() {
        return this.inStaticContext;
    }

    public ClassType outer() {
        if (this.isTopLevel()) {
            return null;
        }
        if (this.outer == null) {
            throw new InternalCompilerError("Nested classes must have outer classes.");
        }
        return this.outer;
    }

    public String name() {
        return this.name;
    }

    public Type superType() {
        this.init.initSuperclass();
        return this.superType;
    }

    public Package package_() {
        return this.package_;
    }

    public Flags flags() {
        if (this.isAnonymous()) {
            return Flags.NONE;
        }
        return this.flags;
    }

    public void setFlags(Flags flags) {
        this.flags = flags;
    }

    public void flags(Flags flags) {
        this.flags = flags;
    }

    public void kind(ClassType.Kind kind) {
        this.kind = kind;
    }

    public void outer(ClassType outer) {
        if (this.isTopLevel()) {
            throw new InternalCompilerError("Top-level classes cannot have outer classes.");
        }
        this.outer = outer;
    }

    public void setContainer(ReferenceType container) {
        if (!(container instanceof ClassType) || !this.isMember()) {
            throw new InternalCompilerError("Only member classes can have containers.");
        }
        this.outer((ClassType)container);
    }

    public void name(String name) {
        if (this.isAnonymous()) {
            throw new InternalCompilerError("Anonymous classes cannot have names.");
        }
        this.name = name;
    }

    public void position(Position pos) {
        this.position = pos;
    }

    public void package_(Package p) {
        this.package_ = p;
    }

    public void superType(Type t) {
        this.superType = t;
    }

    public void addInterface(Type t) {
        this.interfaces.add(t);
    }

    public void addMethod(MethodInstance mi) {
        this.methods.add(mi);
    }

    public void addConstructor(ConstructorInstance ci) {
        this.constructors.add(ci);
    }

    public void addField(FieldInstance fi) {
        this.fields.add(fi);
    }

    public void addMemberClass(ClassType t) {
        this.memberClasses.add(t);
    }

    public void setInterfaces(List l) {
        this.interfaces = new ArrayList(l);
    }

    public void setMethods(List l) {
        this.methods = new ArrayList(l);
    }

    public void setFields(List l) {
        this.fields = new ArrayList(l);
    }

    public void setConstructors(List l) {
        this.constructors = new ArrayList(l);
    }

    public void setMemberClasses(List l) {
        this.memberClasses = new ArrayList(l);
    }

    public boolean defaultConstructorNeeded() {
        this.init.initConstructors();
        if (this.flags().isInterface()) {
            return false;
        }
        return this.constructors.isEmpty();
    }

    public List constructors() {
        this.init.initConstructors();
        this.init.canonicalConstructors();
        return Collections.unmodifiableList(this.constructors);
    }

    public List memberClasses() {
        this.init.initMemberClasses();
        return Collections.unmodifiableList(this.memberClasses);
    }

    public List methods() {
        this.init.initMethods();
        this.init.canonicalMethods();
        return Collections.unmodifiableList(this.methods);
    }

    public List methodsNamed(String name) {
        this.init.initMethods();
        LinkedList<MethodInstance> l = new LinkedList<MethodInstance>();
        Iterator i = this.methods.iterator();
        while (i.hasNext()) {
            MethodInstance mi = (MethodInstance)i.next();
            if (!mi.name().equals(name)) continue;
            if (!mi.isCanonical()) {
                this.init.canonicalMethods();
            }
            l.add(mi);
        }
        return l;
    }

    public List fields() {
        this.init.initFields();
        this.init.canonicalFields();
        return Collections.unmodifiableList(this.fields);
    }

    public FieldInstance fieldNamed(String name) {
        this.init.initFields();
        Iterator i = this.fields.iterator();
        while (i.hasNext()) {
            FieldInstance fi = (FieldInstance)i.next();
            if (!fi.name().equals(name)) continue;
            if (!fi.isCanonical()) {
                this.init.canonicalFields();
            }
            return fi;
        }
        return null;
    }

    public List interfaces() {
        this.init.initInterfaces();
        return Collections.unmodifiableList(this.interfaces);
    }

    public boolean membersAdded() {
        return this.membersAdded;
    }

    public void setMembersAdded(boolean membersAdded) {
        this.membersAdded = membersAdded;
    }

    public void setSignaturesResolved(boolean signaturesDisambiguated) {
        this.signaturesResolved = signaturesDisambiguated;
    }

    public boolean supertypesResolved() {
        return this.supertypesResolved;
    }

    public void setSupertypesResolved(boolean supertypesResolved) {
        this.supertypesResolved = supertypesResolved;
    }

    public int numSignaturesUnresolved() {
        Scheduler scheduler = this.typeSystem().extensionInfo().scheduler();
        if (this.signaturesResolved) {
            return 0;
        }
        if (!this.membersAdded()) {
            return Integer.MAX_VALUE;
        }
        ArrayList l = new ArrayList();
        l.addAll(this.methods);
        l.addAll(this.fields);
        l.addAll(this.constructors);
        l.addAll(this.memberClasses);
        int count = 0;
        Iterator i = l.iterator();
        while (i.hasNext()) {
            MemberInstance mi = (MemberInstance)i.next();
            if (mi.isCanonical()) continue;
            ++count;
        }
        if (count == 0) {
            this.signaturesResolved = true;
        }
        return count;
    }

    public boolean signaturesResolved() {
        if (!this.signaturesResolved) {
            if (!this.membersAdded()) {
                return false;
            }
            Scheduler scheduler = this.typeSystem().extensionInfo().scheduler();
            ArrayList l = new ArrayList();
            l.addAll(this.methods);
            l.addAll(this.fields);
            l.addAll(this.constructors);
            l.addAll(this.memberClasses);
            int count = 0;
            Iterator i = l.iterator();
            while (i.hasNext()) {
                MemberInstance mi = (MemberInstance)i.next();
                if (mi.isCanonical()) continue;
                if (Report.should_report("ambcheck", 2)) {
                    Report.report(2, mi + " is ambiguous");
                }
                ++count;
            }
            if (count == 0) {
                this.signaturesResolved = true;
            }
        }
        return this.signaturesResolved;
    }

    public String toString() {
        if (this.kind() == null) {
            return "<unknown class " + this.name + ">";
        }
        if (this.isAnonymous()) {
            if (this.interfaces != null && !this.interfaces.isEmpty()) {
                return "<anonymous subtype of " + this.interfaces.get(0) + ">";
            }
            if (this.superType != null) {
                return "<anonymous subclass of " + this.superType + ">";
            }
        }
        return super.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Object o = this.ts.placeHolder(this);
        if (o instanceof PlaceHolder && o != this) {
            out.writeBoolean(true);
            out.writeObject(o);
        } else {
            out.writeBoolean(false);
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (in instanceof TypeInputStream) {
            TypeInputStream tin = (TypeInputStream)in;
            boolean b = tin.readBoolean();
            if (b) {
                tin.enableReplace(false);
                PlaceHolder p = (PlaceHolder)tin.readObject();
                tin.installInPlaceHolderCache(p, this);
                tin.enableReplace(true);
            }
            this.fromSource = null;
            this.job = null;
            this.init = tin.getTypeSystem().deserializedClassInitializer();
            this.init.setClass(this);
            this.membersAdded = true;
            this.supertypesResolved = true;
            this.signaturesResolved = true;
            this.memberClasses = new ArrayList();
        }
        in.defaultReadObject();
    }

    public void needSerialization(boolean b) {
        this.needSerialization = b;
    }

    public boolean needSerialization() {
        return this.needSerialization;
    }
}

