/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.types.Declaration;
import polyglot.types.Flags;
import polyglot.types.MemberInstance;
import polyglot.types.ProcedureInstance;
import polyglot.types.ReferenceType;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeObject_c;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.util.SubtypeSet;
import polyglot.util.TypedList;

public abstract class ProcedureInstance_c
extends TypeObject_c
implements ProcedureInstance {
    protected ReferenceType container;
    protected Flags flags;
    protected List formalTypes;
    protected List throwTypes;

    protected ProcedureInstance_c() {
    }

    public ProcedureInstance_c(TypeSystem ts, Position pos, ReferenceType container, Flags flags, List formalTypes, List excTypes) {
        super(ts, pos);
        this.container = container;
        this.flags = flags;
        this.formalTypes = TypedList.copyAndCheck(formalTypes, Type.class, true);
        this.throwTypes = TypedList.copyAndCheck(excTypes, Type.class, true);
    }

    public ReferenceType container() {
        return this.container;
    }

    public Flags flags() {
        return this.flags;
    }

    public List formalTypes() {
        return Collections.unmodifiableList(this.formalTypes);
    }

    public List throwTypes() {
        return Collections.unmodifiableList(this.throwTypes);
    }

    public void setContainer(ReferenceType container) {
        this.container = container;
    }

    public void setFlags(Flags flags) {
        this.flags = flags;
    }

    public void setFormalTypes(List formalTypes) {
        this.formalTypes = TypedList.copyAndCheck(formalTypes, Type.class, true);
    }

    public void setThrowTypes(List throwTypes) {
        this.throwTypes = TypedList.copyAndCheck(throwTypes, Type.class, true);
    }

    public int hashCode() {
        return this.container.hashCode() + this.flags.hashCode();
    }

    public boolean equalsImpl(TypeObject o) {
        if (o instanceof ProcedureInstance) {
            ProcedureInstance i = (ProcedureInstance)o;
            return this.flags.equals(i.flags()) && this.ts.hasFormals(this, i.formalTypes());
        }
        return false;
    }

    protected boolean listIsCanonical(List l) {
        Iterator i = l.iterator();
        while (i.hasNext()) {
            TypeObject o = (TypeObject)i.next();
            if (o.isCanonical()) continue;
            return false;
        }
        return true;
    }

    public final boolean moreSpecific(ProcedureInstance p) {
        return this.ts.moreSpecific(this, p);
    }

    public boolean moreSpecificImpl(ProcedureInstance p) {
        ProcedureInstance_c p1 = this;
        ProcedureInstance p2 = p;
        ReferenceType t1 = null;
        ReferenceType t2 = null;
        if (p1 instanceof MemberInstance) {
            t1 = p1 instanceof Declaration ? ((MemberInstance)((Object)((Declaration)((Object)p1)).declaration())).container() : ((MemberInstance)((Object)p1)).container();
        }
        if (p2 instanceof MemberInstance) {
            t2 = p2 instanceof Declaration ? ((MemberInstance)((Object)((Declaration)((Object)p2)).declaration())).container() : ((MemberInstance)((Object)p2)).container();
        }
        if (t1 != null && t2 != null && (t1.isClass() && t2.isClass() ? !t1.isSubtype(t2) && !t1.toClass().isEnclosed(t2.toClass()) : !t1.isSubtype(t2))) {
            return false;
        }
        return p2.callValid(p1.formalTypes());
    }

    public final boolean hasFormals(List formalTypes) {
        return this.ts.hasFormals(this, formalTypes);
    }

    public boolean hasFormalsImpl(List formalTypes) {
        List l1 = this.formalTypes();
        List l2 = formalTypes;
        Iterator i1 = l1.iterator();
        Iterator i2 = l2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Type t2;
            Type t1 = (Type)i1.next();
            if (this.ts.equals(t1, t2 = (Type)i2.next())) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public final boolean throwsSubset(ProcedureInstance p) {
        return this.ts.throwsSubset(this, p);
    }

    public boolean throwsSubsetImpl(ProcedureInstance p) {
        SubtypeSet s1 = new SubtypeSet(this.ts.Throwable());
        SubtypeSet s2 = new SubtypeSet(this.ts.Throwable());
        s1.addAll((Collection)this.throwTypes());
        s2.addAll((Collection)p.throwTypes());
        Iterator i = s1.iterator();
        while (i.hasNext()) {
            Type t = (Type)i.next();
            if (this.ts.isUncheckedException(t) || s2.contains(t)) continue;
            return false;
        }
        return true;
    }

    public final boolean callValid(List argTypes) {
        return this.ts.callValid(this, argTypes);
    }

    public boolean callValidImpl(List argTypes) {
        List l1 = this.formalTypes();
        List l2 = argTypes;
        Iterator i1 = l1.iterator();
        Iterator i2 = l2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Type t1 = (Type)i1.next();
            Type t2 = (Type)i2.next();
            if (this.ts.isImplicitCastValid(t2, t1)) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }
}

