/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import polyglot.frontend.ExtensionInfo;
import polyglot.main.Report;
import polyglot.types.CachingResolver;
import polyglot.types.ClassType;
import polyglot.types.Importable;
import polyglot.types.Named;
import polyglot.types.Package;
import polyglot.types.ParsedTypeObject;
import polyglot.types.SemanticException;
import polyglot.types.TopLevelResolver;
import polyglot.types.Type;
import polyglot.util.CollectionUtil;
import polyglot.util.StringUtil;
import polyglot.util.Transformation;
import polyglot.util.TransformingList;

public class SystemResolver
extends CachingResolver
implements TopLevelResolver {
    protected Map packageCache;
    protected ExtensionInfo extInfo;
    protected SystemResolver previous;
    protected Collection justAdded;
    private static final Collection TOPICS = CollectionUtil.list("types", "resolver", "sysresolver");

    public SystemResolver(TopLevelResolver inner, ExtensionInfo extInfo) {
        super(inner);
        this.extInfo = extInfo;
        this.packageCache = new HashMap();
        this.previous = null;
        this.justAdded = new LinkedList();
    }

    public SystemResolver previous() {
        return this.previous;
    }

    public Object copy() {
        SystemResolver r = (SystemResolver)super.copy();
        r.packageCache = new HashMap(this.packageCache);
        r.previous = this;
        r.justAdded = new LinkedList();
        return r;
    }

    public void installInAll(String name, Named n) {
        this.install(name, n);
        if (this.previous != null) {
            this.previous.installInAll(name, n);
        }
    }

    public boolean installedInAll(String name, Named q) {
        if (this.check(name) != q) {
            return false;
        }
        if (this.previous != null) {
            return this.previous.installedInAll(name, q);
        }
        return true;
    }

    protected boolean packageExistsInCache(String name) {
        Iterator i = this.cachedObjects().iterator();
        while (i.hasNext()) {
            Importable im;
            Object o = i.next();
            if (!(o instanceof Importable) || (im = (Importable)o).package_() == null || im.package_().fullName() == null || !im.package_().fullName().equals(name) && !im.package_().fullName().startsWith(name + ".")) continue;
            return true;
        }
        return false;
    }

    public boolean packageExists(String name) {
        Boolean b = (Boolean)this.packageCache.get(name);
        if (b != null) {
            return b;
        }
        String prefix = StringUtil.getPackageComponent(name);
        if (this.packageCache.get(prefix) == Boolean.FALSE) {
            this.packageCache.put(name, Boolean.FALSE);
            return false;
        }
        boolean exists = this.packageExistsInCache(name);
        if (!exists) {
            exists = ((TopLevelResolver)this.inner).packageExists(name);
        }
        if (exists) {
            this.packageCache.put(name, Boolean.TRUE);
            do {
                this.packageCache.put(prefix, Boolean.TRUE);
            } while (!(prefix = StringUtil.getPackageComponent(prefix)).equals(""));
        } else {
            this.packageCache.put(name, Boolean.FALSE);
        }
        return exists;
    }

    protected void cachePackage(Package p) {
        if (p != null) {
            this.packageCache.put(p.fullName(), Boolean.TRUE);
            this.cachePackage(p.prefix());
        }
    }

    public Type checkType(String name) {
        return (Type)((Object)this.check(name));
    }

    public Collection justAdded() {
        return new TransformingList(this.justAdded, new Transformation(){

            public Object transform(Object o) {
                Object[] p = (Object[])o;
                return p[1];
            }
        });
    }

    public void clearAdded() {
        this.justAdded = new LinkedList();
    }

    public void putAll(SystemResolver r) throws SemanticException {
        Iterator i = r.justAdded.iterator();
        while (i.hasNext()) {
            Object[] e = (Object[])i.next();
            String name = (String)e[0];
            Named n = (Named)e[1];
            this.install(name, n);
            if (!(n instanceof Package)) continue;
            Package p = (Package)n;
            this.cachePackage(p);
        }
    }

    public Named find(String name) throws SemanticException {
        if (this.previous == null) {
            this.clearAdded();
        }
        Named n = super.find(name);
        if (this.previous == null) {
            if (Report.should_report(TOPICS, 2)) {
                Report.report(2, "Returning from root-level SR.find(" + name + "); added = " + this.justAdded);
            }
            this.clearAdded();
        } else if (Report.should_report(TOPICS, 2)) {
            Report.report(2, "Returning from non-root-level SR.find(" + name + "); added = " + this.justAdded);
        }
        return n;
    }

    public void install(String name, Named q) {
        if (Report.should_report(TOPICS, 2) && this.check(name) == null) {
            Report.report(2, (this.previous == null ? "root" : "non-root") + " SR installing " + name + "->" + q);
        }
        super.install(name, q);
        if (this.previous == null) {
            if (q instanceof ParsedTypeObject && !((ParsedTypeObject)q).initializer().isTypeObjectInitialized()) {
                if (Report.should_report(TOPICS, 2)) {
                    Report.report(2, "SR initializing " + q);
                }
                ((ParsedTypeObject)q).initializer().initTypeObject();
            }
        } else {
            this.justAdded.add(new Object[]{name, q});
        }
    }

    public void addNamed(String name, Named q) throws SemanticException {
        super.addNamed(name, q);
        if (q instanceof ClassType) {
            ClassType ct = (ClassType)q;
            String containerName = StringUtil.getPackageComponent(name);
            if (ct.isTopLevel()) {
                Package p = ((ClassType)q).package_();
                this.cachePackage(p);
                if (p != null && containerName.equals(p.fullName())) {
                    this.addNamed(containerName, p);
                }
            } else if (ct.isMember() && name.equals(ct.fullName())) {
                this.addNamed(containerName, ct.outer());
            }
        } else if (q instanceof Package) {
            Package p = (Package)q;
            this.cachePackage(p);
            String containerName = StringUtil.getPackageComponent(name);
            if (p.prefix() != null && containerName.equals(p.prefix().fullName())) {
                this.addNamed(containerName, p.prefix());
            }
        }
        if (q instanceof Type && this.packageExists(name)) {
            throw new SemanticException("Type \"" + name + "\" clashes with package of the same name.", q.position());
        }
    }
}

