/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.types.Declaration;
import polyglot.types.Flags;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeObject_c;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public abstract class VarInstance_c
extends TypeObject_c
implements VarInstance {
    protected Flags flags;
    protected Type type;
    protected String name;
    protected Object constantValue;
    protected boolean isConstant;
    protected boolean constantValueSet;
    protected VarInstance decl;

    protected VarInstance_c() {
    }

    public VarInstance_c(TypeSystem ts, Position pos, Flags flags, Type type, String name) {
        super(ts, pos);
        this.flags = flags;
        this.type = type;
        this.name = name;
        this.decl = this;
    }

    public Declaration declaration() {
        return this.decl;
    }

    public void setDeclaration(Declaration decl) {
        this.decl = (VarInstance)decl;
    }

    public boolean constantValueSet() {
        if (this != this.declaration()) {
            return ((VarInstance)this.declaration()).constantValueSet();
        }
        return this.constantValueSet;
    }

    public boolean isConstant() {
        if (this != this.declaration()) {
            return ((VarInstance)this.declaration()).isConstant();
        }
        if (!this.constantValueSet && !this.flags.isFinal()) {
            this.setNotConstant();
            return this.isConstant;
        }
        return this.isConstant;
    }

    public Object constantValue() {
        if (this != this.declaration()) {
            return ((VarInstance)this.declaration()).constantValue();
        }
        if (this.isConstant()) {
            return this.constantValue;
        }
        return null;
    }

    public Flags flags() {
        return this.flags;
    }

    public Type type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public int hashCode() {
        return this.flags.hashCode() + this.name.hashCode();
    }

    public boolean equalsImpl(TypeObject o) {
        if (o instanceof VarInstance) {
            VarInstance i = (VarInstance)o;
            return this.flags.equals(i.flags()) && this.ts.equals(this.type, i.type()) && this.name.equals(i.name());
        }
        return false;
    }

    public boolean isCanonical() {
        return true;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setFlags(Flags flags) {
        this.flags = flags;
    }

    public void setConstantValue(Object constantValue) {
        if (!(constantValue == null || constantValue instanceof Boolean || constantValue instanceof Number || constantValue instanceof Character || constantValue instanceof String)) {
            throw new InternalCompilerError("Can only set constant value to a primitive or String.");
        }
        this.constantValue = constantValue;
        this.isConstant = true;
        this.constantValueSet = true;
    }

    public void setNotConstant() {
        this.constantValue = null;
        this.isConstant = false;
        this.constantValueSet = true;
    }

    public void setName(String name) {
        this.name = name;
    }
}

