/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types.reflect;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import polyglot.frontend.ExtensionInfo;
import polyglot.types.SemanticException;
import polyglot.types.reflect.Attribute;
import polyglot.types.reflect.ClassFileLoader;
import polyglot.types.reflect.Constant;
import polyglot.types.reflect.Field;
import polyglot.types.reflect.InnerClasses;
import polyglot.types.reflect.JLCInfo;
import polyglot.types.reflect.Method;
import polyglot.util.InternalCompilerError;

public class ClassFile {
    protected Constant[] constants;
    protected int modifiers;
    protected int thisClass;
    protected int superClass;
    protected int[] interfaces;
    protected Field[] fields;
    protected Method[] methods;
    protected Attribute[] attrs;
    protected InnerClasses innerClasses;
    protected File classFileSource;
    protected ExtensionInfo extensionInfo;
    protected Map jlcInfoCache = new HashMap();
    protected static Collection verbose = ClassFileLoader.verbose;

    public ClassFile(File classFileSource, byte[] code, ExtensionInfo ext) {
        this.classFileSource = classFileSource;
        this.extensionInfo = ext;
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(code);
            DataInputStream in = new DataInputStream(bin);
            this.read(in);
            in.close();
            bin.close();
        }
        catch (IOException e) {
            throw new InternalCompilerError("I/O exception on ByteArrayInputStream");
        }
    }

    public String getClassFileLocation() {
        return this.classFileSource.toString();
    }

    JLCInfo getJLCInfo(String typeSystemKey) {
        JLCInfo jlc = (JLCInfo)this.jlcInfoCache.get(typeSystemKey);
        if (jlc != null) {
            return jlc;
        }
        jlc = new JLCInfo();
        this.jlcInfoCache.put(typeSystemKey, jlc);
        try {
            int mask = 0;
            for (int i = 0; i < this.fields.length; ++i) {
                boolean found;
                if (this.fields[i].name().equals("jlc$SourceLastModified$" + typeSystemKey)) {
                    jlc.sourceLastModified = this.fields[i].getLong();
                    mask |= 1;
                    continue;
                }
                if (this.fields[i].name().equals("jlc$CompilerVersion$" + typeSystemKey)) {
                    jlc.compilerVersion = this.fields[i].getString();
                    mask |= 2;
                    continue;
                }
                if (!this.fields[i].name().equals("jlc$ClassType$" + typeSystemKey)) continue;
                StringBuffer encodedClassTypeInfo = new StringBuffer(this.fields[i].getString());
                int seeking = 1;
                block3: do {
                    found = false;
                    String suffix = "$" + seeking;
                    String seekingFieldName = "jlc$ClassType$" + typeSystemKey + suffix;
                    for (int j = 0; j < this.fields.length; ++j) {
                        if (!this.fields[j].name().equals(seekingFieldName)) continue;
                        encodedClassTypeInfo.append(this.fields[j].getString());
                        found = true;
                        ++seeking;
                        continue block3;
                    }
                } while (found);
                jlc.encodedClassType = encodedClassTypeInfo.toString();
                mask |= 4;
            }
            if (mask != 7) {
                jlc.sourceLastModified = 0L;
                jlc.compilerVersion = null;
                jlc.encodedClassType = null;
            }
        }
        catch (SemanticException e) {
            jlc.sourceLastModified = 0L;
            jlc.compilerVersion = null;
            jlc.encodedClassType = null;
        }
        return jlc;
    }

    public long sourceLastModified(String ts) {
        JLCInfo jlc = this.getJLCInfo(ts);
        return jlc.sourceLastModified;
    }

    public String compilerVersion(String ts) {
        JLCInfo jlc = this.getJLCInfo(ts);
        return jlc.compilerVersion;
    }

    public String encodedClassType(String typeSystemKey) {
        JLCInfo jlc = this.getJLCInfo(typeSystemKey);
        return jlc.encodedClassType;
    }

    void read(DataInputStream in) throws IOException {
        this.readHeader(in);
        this.readConstantPool(in);
        this.readAccessFlags(in);
        this.readClassInfo(in);
        this.readFields(in);
        this.readMethods(in);
        this.readAttributes(in);
    }

    public String classNameCP(int index) {
        Integer nameIndex;
        Constant c = this.constants[index];
        if (c != null && c.tag() == 7 && (nameIndex = (Integer)c.value()) != null && (c = this.constants[nameIndex]).tag() == 1) {
            String s = (String)c.value();
            return s.replace('/', '.');
        }
        return null;
    }

    public String name() {
        Integer nameIndex;
        Constant c = this.constants[this.thisClass];
        if (c.tag() == 7 && (nameIndex = (Integer)c.value()) != null && (c = this.constants[nameIndex]).tag() == 1) {
            return (String)c.value();
        }
        throw new ClassFormatError("Couldn't find class name in file");
    }

    Constant readConstant(DataInputStream in) throws IOException {
        Object value;
        int tag = in.readUnsignedByte();
        switch (tag) {
            case 7: 
            case 8: {
                value = new Integer(in.readUnsignedShort());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                value = new int[]{in.readUnsignedShort(), in.readUnsignedShort()};
                break;
            }
            case 3: {
                value = new Integer(in.readInt());
                break;
            }
            case 4: {
                value = new Float(in.readFloat());
                break;
            }
            case 5: {
                value = new Long(in.readLong());
                break;
            }
            case 6: {
                value = new Double(in.readDouble());
                break;
            }
            case 1: {
                value = in.readUTF();
                break;
            }
            default: {
                throw new ClassFormatError("Invalid constant tag: " + tag);
            }
        }
        return new Constant(tag, value);
    }

    void readHeader(DataInputStream in) throws IOException {
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new ClassFormatError("Bad magic number.");
        }
        int major = in.readUnsignedShort();
        int minor = in.readUnsignedShort();
    }

    void readConstantPool(DataInputStream in) throws IOException {
        int count = in.readUnsignedShort();
        this.constants = new Constant[count];
        this.constants[0] = null;
        for (int i = 1; i < count; ++i) {
            this.constants[i] = this.readConstant(in);
            switch (this.constants[i].tag()) {
                case 5: 
                case 6: {
                    this.constants[++i] = null;
                }
            }
        }
    }

    void readAccessFlags(DataInputStream in) throws IOException {
        this.modifiers = in.readUnsignedShort();
    }

    void readClassInfo(DataInputStream in) throws IOException {
        this.thisClass = in.readUnsignedShort();
        this.superClass = in.readUnsignedShort();
        int numInterfaces = in.readUnsignedShort();
        this.interfaces = new int[numInterfaces];
        for (int i = 0; i < numInterfaces; ++i) {
            this.interfaces[i] = in.readUnsignedShort();
        }
    }

    void readFields(DataInputStream in) throws IOException {
        int numFields = in.readUnsignedShort();
        this.fields = new Field[numFields];
        for (int i = 0; i < numFields; ++i) {
            this.fields[i] = this.createField(in);
        }
    }

    void readMethods(DataInputStream in) throws IOException {
        int numMethods = in.readUnsignedShort();
        this.methods = new Method[numMethods];
        for (int i = 0; i < numMethods; ++i) {
            this.methods[i] = this.createMethod(in);
        }
    }

    public void readAttributes(DataInputStream in) throws IOException {
        int numAttributes = in.readUnsignedShort();
        this.attrs = new Attribute[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            int nameIndex = in.readUnsignedShort();
            int length = in.readInt();
            String name = (String)this.constants[nameIndex].value();
            Attribute a = this.createAttribute(in, name, nameIndex, length);
            if (a != null) {
                this.attrs[i] = a;
                continue;
            }
            long n = in.skip(length);
            if (n == (long)length) continue;
            throw new EOFException();
        }
    }

    public Method createMethod(DataInputStream in) throws IOException {
        Method m = new Method(in, this);
        m.initialize();
        return m;
    }

    public Field createField(DataInputStream in) throws IOException {
        Field f = new Field(in, this);
        f.initialize();
        return f;
    }

    public Attribute createAttribute(DataInputStream in, String name, int nameIndex, int length) throws IOException {
        if (name.equals("InnerClasses")) {
            this.innerClasses = new InnerClasses(in, nameIndex, length);
            return this.innerClasses;
        }
        return null;
    }

    public Attribute[] getAttrs() {
        return this.attrs;
    }

    public Constant[] getConstants() {
        return this.constants;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public InnerClasses getInnerClasses() {
        return this.innerClasses;
    }

    public int[] getInterfaces() {
        return this.interfaces;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getSuperClass() {
        return this.superClass;
    }

    public int getThisClass() {
        return this.thisClass;
    }

    public String toString() {
        return this.name();
    }
}

