/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types.reflect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.LazyClassInitializer;
import polyglot.types.MethodInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLoader;
import polyglot.types.reflect.Constant;
import polyglot.types.reflect.Exceptions;
import polyglot.types.reflect.Field;
import polyglot.types.reflect.InnerClasses;
import polyglot.types.reflect.Method;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.StringUtil;

public class ClassFileLazyClassInitializer
implements LazyClassInitializer {
    protected ClassFile clazz;
    protected TypeSystem ts;
    protected ParsedClassType ct;
    protected boolean init;
    protected boolean constructorsInitialized;
    protected boolean fieldsInitialized;
    protected boolean interfacesInitialized;
    protected boolean memberClassesInitialized;
    protected boolean methodsInitialized;
    protected boolean superclassInitialized;
    protected static Collection verbose = ClassFileLoader.verbose;

    public ClassFileLazyClassInitializer(ClassFile file, TypeSystem ts) {
        this.clazz = file;
        this.ts = ts;
    }

    public void setClass(ParsedClassType ct) {
        this.ct = ct;
    }

    public boolean fromClassFile() {
        return true;
    }

    public Position position() {
        return new Position(null, this.clazz.name() + ".class");
    }

    protected ParsedClassType createType() throws SemanticException {
        String name = this.clazz.classNameCP(this.clazz.getThisClass());
        if (Report.should_report(verbose, 2)) {
            Report.report(2, "creating ClassType for " + name);
        }
        ParsedClassType ct = this.ts.createClassType(this);
        ct.flags(this.ts.flagsForBits(this.clazz.getModifiers()));
        ct.position(this.position());
        String packageName = StringUtil.getPackageComponent(name);
        if (!packageName.equals("")) {
            ct.package_(this.ts.packageForName(packageName));
        }
        String className = StringUtil.getShortNameComponent(name);
        String outerName = name;
        String innerName = null;
        while (true) {
            int dollar;
            if ((dollar = outerName.lastIndexOf(36)) < 0) {
                outerName = name;
                innerName = null;
                break;
            }
            outerName = name.substring(0, dollar);
            innerName = name.substring(dollar + 1);
            try {
                if (Report.should_report(verbose, 2)) {
                    Report.report(2, "resolving " + outerName + " for " + name);
                }
                ct.outer(this.typeForName(outerName));
            }
            catch (SemanticException e) {
                if (!Report.should_report(verbose, 3)) continue;
                Report.report(2, "error resolving " + outerName);
                continue;
            }
            break;
        }
        ClassType.Kind kind = ClassType.TOP_LEVEL;
        if (innerName != null) {
            StringTokenizer st = new StringTokenizer(className, "$");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (Character.isDigit(s.charAt(0))) {
                    kind = ClassType.ANONYMOUS;
                    continue;
                }
                if (kind == ClassType.ANONYMOUS) {
                    kind = ClassType.LOCAL;
                    continue;
                }
                kind = ClassType.MEMBER;
            }
        }
        if (Report.should_report(verbose, 3)) {
            Report.report(3, name + " is " + kind);
        }
        ct.kind(kind);
        if (ct.isTopLevel()) {
            ct.name(className);
        } else if (ct.isMember() || ct.isLocal()) {
            ct.name(innerName);
        }
        this.ts.systemResolver().addNamed(name, ct);
        this.ts.systemResolver().addNamed(ct.fullName(), ct);
        return ct;
    }

    public ParsedClassType type() throws SemanticException {
        ParsedClassType ct = this.createType();
        return ct;
    }

    protected Type arrayOf(Type t, int dims) {
        if (dims == 0) {
            return t;
        }
        return this.ts.arrayOf(t, dims);
    }

    protected List typeListForString(String str) {
        ArrayList<Type> types = new ArrayList<Type>();
        block12: for (int i = 0; i < str.length(); ++i) {
            int dims = 0;
            while (str.charAt(i) == '[') {
                ++dims;
                ++i;
            }
            switch (str.charAt(i)) {
                case 'Z': {
                    types.add(this.arrayOf(this.ts.Boolean(), dims));
                    continue block12;
                }
                case 'B': {
                    types.add(this.arrayOf(this.ts.Byte(), dims));
                    continue block12;
                }
                case 'S': {
                    types.add(this.arrayOf(this.ts.Short(), dims));
                    continue block12;
                }
                case 'C': {
                    types.add(this.arrayOf(this.ts.Char(), dims));
                    continue block12;
                }
                case 'I': {
                    types.add(this.arrayOf(this.ts.Int(), dims));
                    continue block12;
                }
                case 'J': {
                    types.add(this.arrayOf(this.ts.Long(), dims));
                    continue block12;
                }
                case 'F': {
                    types.add(this.arrayOf(this.ts.Float(), dims));
                    continue block12;
                }
                case 'D': {
                    types.add(this.arrayOf(this.ts.Double(), dims));
                    continue block12;
                }
                case 'V': {
                    types.add(this.arrayOf(this.ts.Void(), dims));
                    continue block12;
                }
                case 'L': {
                    int start = ++i;
                    while (i < str.length()) {
                        if (str.charAt(i) == ';') {
                            String s = str.substring(start, i);
                            s = s.replace('/', '.');
                            types.add(this.arrayOf(this.quietTypeForName(s), dims));
                            continue block12;
                        }
                        ++i;
                    }
                    continue block12;
                }
            }
        }
        if (Report.should_report(verbose, 4)) {
            Report.report(4, "parsed \"" + str + "\" -> " + types);
        }
        return types;
    }

    protected Type typeForString(String str) {
        List l = this.typeListForString(str);
        if (l.size() == 1) {
            return (Type)l.get(0);
        }
        throw new InternalCompilerError("Bad type string: \"" + str + "\"");
    }

    protected ClassType quietTypeForName(String name) {
        if (Report.should_report(verbose, 2)) {
            Report.report(2, "resolving " + name);
        }
        try {
            return (ClassType)this.ts.systemResolver().find(name);
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("could not load " + name, e);
        }
    }

    protected ClassType typeForName(String name) throws SemanticException {
        if (Report.should_report(verbose, 2)) {
            Report.report(2, "resolving " + name);
        }
        return (ClassType)this.ts.systemResolver().find(name);
    }

    public void initTypeObject() {
        this.init = true;
    }

    public boolean isTypeObjectInitialized() {
        return this.init;
    }

    public void initSuperclass() {
        if (this.superclassInitialized) {
            return;
        }
        if (this.ts.equals(this.ct, this.ts.Object())) {
            this.ct.superType(null);
        } else {
            String superName = this.clazz.classNameCP(this.clazz.getSuperClass());
            if (superName != null) {
                this.ct.superType(this.quietTypeForName(superName));
            } else {
                this.ct.superType(this.ts.Object());
            }
        }
        this.superclassInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    public void initInterfaces() {
        if (this.interfacesInitialized) {
            return;
        }
        int[] interfaces = this.clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            String name = this.clazz.classNameCP(interfaces[i]);
            this.ct.addInterface(this.quietTypeForName(name));
        }
        this.interfacesInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    public void initMemberClasses() {
        if (this.memberClassesInitialized) {
            return;
        }
        InnerClasses innerClasses = this.clazz.getInnerClasses();
        if (innerClasses != null) {
            for (int i = 0; i < innerClasses.getClasses().length; ++i) {
                String name;
                int index;
                InnerClasses.Info c = innerClasses.getClasses()[i];
                if (c.outerClassIndex != this.clazz.getThisClass() || c.classIndex == 0 || (index = (name = this.clazz.classNameCP(c.classIndex)).lastIndexOf(36)) >= 0 && Character.isDigit(name.charAt(index + 1))) continue;
                ClassType t = this.quietTypeForName(name);
                if (t.isMember()) {
                    if (Report.should_report(verbose, 3)) {
                        Report.report(3, "adding member " + t + " to " + this.ct);
                    }
                    this.ct.addMemberClass(t);
                    if (!(t instanceof ParsedClassType)) continue;
                    ParsedClassType pt = (ParsedClassType)t;
                    pt.flags(this.ts.flagsForBits(c.modifiers));
                    continue;
                }
                throw new InternalCompilerError(name + " should be a member class.");
            }
        }
        this.memberClassesInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    public void canonicalFields() {
        this.initFields();
    }

    public void canonicalMethods() {
        this.initMethods();
    }

    public void canonicalConstructors() {
        this.initConstructors();
    }

    public void initFields() {
        if (this.fieldsInitialized) {
            return;
        }
        Field[] fields = this.clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].name().startsWith("jlc$") || fields[i].isSynthetic()) continue;
            FieldInstance fi = this.fieldInstance(fields[i], this.ct);
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "adding " + fi + " to " + this.ct);
            }
            this.ct.addField(fi);
        }
        this.fieldsInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    public void initMethods() {
        if (this.methodsInitialized) {
            return;
        }
        Method[] methods = this.clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].name().equals("<init>") || methods[i].name().equals("<clinit>") || methods[i].isSynthetic()) continue;
            MethodInstance mi = this.methodInstance(methods[i], this.ct);
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "adding " + mi + " to " + this.ct);
            }
            this.ct.addMethod(mi);
        }
        this.methodsInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    public void initConstructors() {
        if (this.constructorsInitialized) {
            return;
        }
        Method[] methods = this.clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].name().equals("<init>") || methods[i].isSynthetic()) continue;
            ConstructorInstance ci = this.constructorInstance(methods[i], this.ct, this.clazz.getFields());
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "adding " + ci + " to " + this.ct);
            }
            this.ct.addConstructor(ci);
        }
        this.constructorsInitialized = true;
        if (this.initialized()) {
            this.clazz = null;
        }
    }

    protected boolean initialized() {
        return this.superclassInitialized && this.interfacesInitialized && this.memberClassesInitialized && this.methodsInitialized && this.fieldsInitialized && this.constructorsInitialized;
    }

    protected MethodInstance methodInstance(Method method, ClassType ct) {
        Constant[] constants = this.clazz.getConstants();
        String name = (String)constants[method.getName()].value();
        String type = (String)constants[method.getType()].value();
        if (type.charAt(0) != '(') {
            throw new ClassFormatError("Bad method type descriptor.");
        }
        int index = type.indexOf(41, 1);
        List argTypes = this.typeListForString(type.substring(1, index));
        Type returnType = this.typeForString(type.substring(index + 1));
        ArrayList<ClassType> excTypes = new ArrayList<ClassType>();
        Exceptions exceptions = method.getExceptions();
        if (exceptions != null) {
            int[] throwTypes = exceptions.getThrowTypes();
            for (int i = 0; i < throwTypes.length; ++i) {
                String s = this.clazz.classNameCP(throwTypes[i]);
                excTypes.add(this.quietTypeForName(s));
            }
        }
        return this.ts.methodInstance(ct.position(), ct, this.ts.flagsForBits(method.getModifiers()), returnType, name, argTypes, excTypes);
    }

    protected ConstructorInstance constructorInstance(Method method, ClassType ct, Field[] fields) {
        MethodInstance mi = this.methodInstance(method, ct);
        List formals = mi.formalTypes();
        if (ct.isInnerClass()) {
            int numSynthetic = 0;
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].isSynthetic()) continue;
                ++numSynthetic;
            }
            if (numSynthetic <= formals.size()) {
                formals = formals.subList(numSynthetic, formals.size());
            }
        }
        return this.ts.constructorInstance(mi.position(), ct, mi.flags(), formals, mi.throwTypes());
    }

    protected FieldInstance fieldInstance(Field field, ClassType ct) {
        Constant[] constants = this.clazz.getConstants();
        String name = (String)constants[field.getName()].value();
        String type = (String)constants[field.getType()].value();
        FieldInstance fi = this.ts.fieldInstance(ct.position(), ct, this.ts.flagsForBits(field.getModifiers()), this.typeForString(type), name);
        if (field.isConstant()) {
            Constant c = field.constantValue();
            Object o = null;
            try {
                switch (c.tag()) {
                    case 8: {
                        o = field.getString();
                        break;
                    }
                    case 3: {
                        o = new Integer(field.getInt());
                        break;
                    }
                    case 5: {
                        o = new Long(field.getLong());
                        break;
                    }
                    case 4: {
                        o = new Float(field.getFloat());
                        break;
                    }
                    case 6: {
                        o = new Double(field.getDouble());
                    }
                }
            }
            catch (SemanticException e) {
                throw new ClassFormatError("Unexpected constant pool entry.");
            }
            fi.setConstantValue(o);
            return fi;
        }
        fi.setNotConstant();
        return fi;
    }
}

