/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class QuotedStringTokenizer
extends StringTokenizer {
    protected final String str;
    protected String delim;
    protected final String quotes;
    protected final char escape;
    protected final boolean returnDelims;
    protected int pos = 0;
    protected final int len;
    private StringBuffer token;

    public QuotedStringTokenizer(String str) {
        this(str, " \t\n\r\f", "\"'", '\\', false);
    }

    public QuotedStringTokenizer(String str, String delim) {
        this(str, delim, "\"'", '\\', false);
    }

    public QuotedStringTokenizer(String str, String delim, String quotes, char escape, boolean returnDelims) {
        super(str, delim, returnDelims);
        this.str = str;
        this.len = str.length();
        this.delim = delim;
        this.quotes = quotes;
        for (int i = 0; i < quotes.length(); ++i) {
            if (delim.indexOf(quotes.charAt(i)) < 0) continue;
            throw new IllegalArgumentException("Invalid quote character '" + quotes.charAt(i) + "'");
        }
        this.escape = escape;
        if (delim.indexOf(escape) >= 0) {
            throw new IllegalArgumentException("Invalid escape character '" + escape + "'");
        }
        if (quotes.indexOf(escape) >= 0) {
            throw new IllegalArgumentException("Invalid escape character '" + escape + "'");
        }
        this.returnDelims = returnDelims;
    }

    private int skipDelim(int pos) {
        while (pos < this.len && this.delim.indexOf(this.str.charAt(pos)) >= 0) {
            ++pos;
        }
        return pos;
    }

    private int skipToken(int pos, boolean collect) {
        if (collect) {
            this.token = new StringBuffer();
        }
        boolean quoted = false;
        char quote = '\u0000';
        boolean escaped = false;
        while (pos < this.len) {
            char curr = this.str.charAt(pos);
            if (escaped) {
                escaped = false;
                if (collect) {
                    this.token.append(curr);
                }
            } else if (curr == this.escape) {
                escaped = true;
            } else if (quoted) {
                if (curr == quote) {
                    quoted = false;
                    quote = '\u0000';
                } else if (collect) {
                    this.token.append(curr);
                }
            } else if (this.quotes.indexOf(curr) >= 0) {
                quoted = true;
                quote = curr;
            } else {
                if (this.delim.indexOf(this.str.charAt(pos)) >= 0) break;
                if (collect) {
                    this.token.append(curr);
                }
            }
            ++pos;
        }
        if (escaped || quoted) {
            throw new IllegalArgumentException("Unterminated quoted string");
        }
        return pos;
    }

    public boolean hasMoreTokens() {
        if (!this.returnDelims) {
            this.pos = this.skipDelim(this.pos);
        }
        return this.pos < this.len;
    }

    public String nextToken() {
        if (!this.returnDelims) {
            this.pos = this.skipDelim(this.pos);
        }
        if (this.pos >= this.len) {
            throw new NoSuchElementException();
        }
        if (this.returnDelims && this.delim.indexOf(this.str.charAt(this.pos)) >= 0) {
            return this.str.substring(this.pos, ++this.pos);
        }
        this.pos = this.skipToken(this.pos, true);
        return this.token.toString();
    }

    public String nextToken(String delim) {
        this.delim = delim;
        return this.nextToken();
    }

    public int countTokens() {
        int count = 0;
        int dcount = 0;
        int curr = this.pos;
        while (curr < this.len) {
            if (this.delim.indexOf(this.str.charAt(curr)) >= 0) {
                ++curr;
                ++dcount;
                continue;
            }
            curr = this.skipToken(curr, false);
            ++count;
        }
        if (this.returnDelims) {
            return count + dcount;
        }
        return count;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }
}

