/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import polyglot.frontend.SchedulerException;
import polyglot.main.Report;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.Base64;
import polyglot.util.InternalCompilerError;
import polyglot.util.TypeInputStream;
import polyglot.util.TypeOutputStream;

public class TypeEncoder {
    protected TypeSystem ts;
    protected final boolean zip = true;
    protected final boolean base64 = true;
    protected final boolean test = false;
    protected Map placeHolderCache;
    protected Map dependencies;
    protected int depth;

    public TypeEncoder(TypeSystem ts) {
        this.ts = ts;
        this.placeHolderCache = null;
    }

    public String encode(TypeObject t) throws IOException {
        if (Report.should_report("serialize", 1)) {
            Report.report(1, "Encoding type " + t);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TypeOutputStream oos = new TypeOutputStream(new GZIPOutputStream(baos), this.ts, t);
        oos.writeObject(t);
        oos.flush();
        oos.close();
        byte[] b = baos.toByteArray();
        if (Report.should_report("serialize", 2)) {
            Report.report(2, "Size of serialization (with zipping) is " + b.length + " bytes");
        }
        String s = new String(Base64.encode(b));
        if (Report.should_report("serialize", 2)) {
            Report.report(2, "Size of serialization after conversion to string is " + s.length() + " characters");
        }
        return s;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TypeObject decode(String s, String name) throws InvalidClassException {
        TypeObject typeObject;
        Map oldDeps;
        byte[] b = Base64.decode(s.toCharArray());
        Map oldCache = this.placeHolderCache;
        this.placeHolderCache = new HashMap();
        if (oldCache != null) {
            this.placeHolderCache.putAll(oldCache);
        }
        if ((oldDeps = this.dependencies) == null) {
            this.dependencies = new HashMap();
        }
        if (Report.should_report("serialize", 1)) {
            Report.report(1, "TypeEncoder depth " + this.depth + " at " + name);
        }
        ++this.depth;
        try {
            try {
                TypeInputStream ois = new TypeInputStream(new ByteArrayInputStream(b), this.ts, this.placeHolderCache);
                TypeObject o = (TypeObject)ois.readObject();
                if (ois.deserializationFailed()) {
                    TypeObject typeObject2 = null;
                    Object var10_14 = null;
                    this.placeHolderCache = oldCache;
                    this.dependencies = oldDeps;
                    --this.depth;
                    return typeObject2;
                }
                typeObject = o;
            }
            catch (InvalidClassException e) {
                throw e;
            }
            catch (IOException e) {
                throw new InternalCompilerError("IOException thrown while decoding serialized type info: " + e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                throw new InternalCompilerError("Unable to find one of the classes for the serialized type info: " + e.getMessage(), e);
            }
            catch (SchedulerException e) {
                throw new InternalCompilerError("SchedulerException thrown while decoding serialized type info: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            this.placeHolderCache = oldCache;
            this.dependencies = oldDeps;
            --this.depth;
            throw throwable;
        }
        Object var10_15 = null;
        this.placeHolderCache = oldCache;
        this.dependencies = oldDeps;
        --this.depth;
        return typeObject;
    }
}

