/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Branch;
import polyglot.ast.Catch;
import polyglot.ast.CodeNode;
import polyglot.ast.CompoundStmt;
import polyglot.ast.Labeled;
import polyglot.ast.Loop;
import polyglot.ast.Return;
import polyglot.ast.Stmt;
import polyglot.ast.Switch;
import polyglot.ast.Term;
import polyglot.ast.Try;
import polyglot.main.Report;
import polyglot.types.MemberInstance;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.util.StringUtil;
import polyglot.visit.CFGBuildError;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;

public class CFGBuilder
implements Copy {
    protected FlowGraph graph;
    protected TypeSystem ts;
    protected CFGBuilder outer;
    protected Stmt innermostTarget;
    protected List path_to_finally;
    protected DataFlow df;
    protected boolean skipInnermostCatches;
    protected boolean errorEdgesToExitNode;
    protected static int counter = 0;

    public CFGBuilder(TypeSystem ts, FlowGraph graph, DataFlow df) {
        this.ts = ts;
        this.graph = graph;
        this.df = df;
        this.path_to_finally = Collections.EMPTY_LIST;
        this.outer = null;
        this.innermostTarget = null;
        this.skipInnermostCatches = false;
        this.errorEdgesToExitNode = false;
    }

    public FlowGraph graph() {
        return this.graph;
    }

    public DataFlow dataflow() {
        return this.df;
    }

    public CFGBuilder outer() {
        return this.outer;
    }

    public TypeSystem typeSystem() {
        return this.ts;
    }

    public Object copy() {
        try {
            return (CFGBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("Java clone() weirdness.");
        }
    }

    public CFGBuilder push(Stmt n) {
        return this.push(n, false);
    }

    public CFGBuilder push(Stmt n, boolean skipInnermostCatches) {
        CFGBuilder v = (CFGBuilder)this.copy();
        v.outer = this;
        v.innermostTarget = n;
        v.skipInnermostCatches = skipInnermostCatches;
        return v;
    }

    public void visitBranchTarget(Branch b) {
        Stmt last = b;
        CFGBuilder last_visitor = this;
        CFGBuilder v = this;
        while (v != null) {
            CompoundStmt l;
            Try tr;
            Stmt c = v.innermostTarget;
            if (c instanceof Try && (tr = (Try)c).finallyBlock() != null) {
                last_visitor = CFGBuilder.tryFinally(v, last, last_visitor, tr.finallyBlock());
                last = tr.finallyBlock();
            }
            if (b.label() != null) {
                if (c instanceof Labeled && (l = (Labeled)c).label().equals(b.label())) {
                    if (b.kind() == Branch.BREAK) {
                        this.edge(last_visitor, last, l, 0, FlowGraph.EDGE_KEY_OTHER);
                    } else {
                        Stmt s = l.statement();
                        if (s instanceof Loop) {
                            Loop loop = (Loop)s;
                            this.edge(last_visitor, last, loop.continueTarget(), 1, FlowGraph.EDGE_KEY_OTHER);
                        } else {
                            throw new CFGBuildError("Target of continue statement must be a loop.", l.position());
                        }
                    }
                    return;
                }
            } else {
                if (c instanceof Loop) {
                    l = (Loop)c;
                    if (b.kind() == Branch.CONTINUE) {
                        this.edge(last_visitor, last, l.continueTarget(), 1, FlowGraph.EDGE_KEY_OTHER);
                    } else {
                        this.edge(last_visitor, last, l, 0, FlowGraph.EDGE_KEY_OTHER);
                    }
                    return;
                }
                if (c instanceof Switch && b.kind() == Branch.BREAK) {
                    this.edge(last_visitor, last, c, 0, FlowGraph.EDGE_KEY_OTHER);
                    return;
                }
            }
            v = v.outer;
        }
        throw new CFGBuildError("Target of branch statement not found.", b.position());
    }

    public void visitReturn(Return r) {
        Stmt last = r;
        CFGBuilder last_visitor = this;
        CFGBuilder v = this;
        while (v != null) {
            Try tr;
            Stmt c = v.innermostTarget;
            if (c instanceof Try && (tr = (Try)c).finallyBlock() != null) {
                last_visitor = CFGBuilder.tryFinally(v, last, last_visitor, tr.finallyBlock());
                last = tr.finallyBlock();
            }
            v = v.outer;
        }
        this.edge(last_visitor, last, this.graph.root(), 0, FlowGraph.EDGE_KEY_OTHER);
    }

    public void visitGraph() {
        String name = StringUtil.getShortNameComponent(this.df.getClass().getName());
        name = name + counter++;
        if (Report.should_report("cfg", 2)) {
            String rootName = "";
            if (this.graph.root() instanceof CodeNode) {
                CodeNode cd = (CodeNode)this.graph.root();
                rootName = cd.codeInstance().toString();
                if (cd.codeInstance() instanceof MemberInstance) {
                    rootName = rootName + " in " + ((MemberInstance)((Object)cd.codeInstance())).container().toString();
                }
            }
            Report.report(2, "digraph CFGBuild" + name + " {");
            Report.report(2, "  label=\"CFGBuilder: " + name + "\\n" + rootName + "\"; fontsize=20; center=true; ratio=auto; size = \"8.5,11\";");
        }
        this.graph.peer(this.graph.root(), Collections.EMPTY_LIST, 1);
        this.graph.peer(this.graph.root(), Collections.EMPTY_LIST, 0);
        this.visitCFG(this.graph.root(), Collections.EMPTY_LIST);
        if (Report.should_report("cfg", 2)) {
            Report.report(2, "}");
        }
    }

    public void visitCFGList(List elements, Term after, int entry) {
        Term prev = null;
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            Term c = (Term)i.next();
            if (prev != null) {
                this.visitCFG(prev, c, 1);
            }
            prev = c;
        }
        if (prev != null) {
            this.visitCFG(prev, after, entry);
        }
    }

    public void visitCFG(Term a, Term succ, int entry) {
        this.visitCFG(a, FlowGraph.EDGE_KEY_OTHER, succ, entry);
    }

    public void visitCFG(Term a, FlowGraph.EdgeKey edgeKey, Term succ, int entry) {
        this.visitCFG(a, CollectionUtil.list(new EdgeKeyTermPair(edgeKey, succ, entry)));
    }

    public void visitCFG(Term a, FlowGraph.EdgeKey edgeKey1, Term succ1, int entry1, FlowGraph.EdgeKey edgeKey2, Term succ2, int entry2) {
        this.visitCFG(a, CollectionUtil.list(new EdgeKeyTermPair(edgeKey1, succ1, entry1), new EdgeKeyTermPair(edgeKey2, succ2, entry2)));
    }

    public void visitCFG(Term a, FlowGraph.EdgeKey edgeKey, List succ, int entry) {
        ArrayList<EdgeKeyTermPair> l = new ArrayList<EdgeKeyTermPair>(succ.size());
        Iterator i = succ.iterator();
        while (i.hasNext()) {
            Term t = (Term)i.next();
            l.add(new EdgeKeyTermPair(edgeKey, t, entry));
        }
        this.visitCFG(a, l);
    }

    public void visitCFG(Term a, FlowGraph.EdgeKey edgeKey, List succ, List entry) {
        if (succ.size() != entry.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<EdgeKeyTermPair> l = new ArrayList<EdgeKeyTermPair>(succ.size());
        for (int i = 0; i < succ.size(); ++i) {
            Term t = (Term)succ.get(i);
            l.add(new EdgeKeyTermPair(edgeKey, t, (Integer)entry.get(i)));
        }
        this.visitCFG(a, l);
    }

    protected void visitCFG(Term a, List succs) {
        Term child = a.firstChild();
        if (child == null) {
            this.edge(this, a, 1, a, 0, FlowGraph.EDGE_KEY_OTHER);
        } else {
            this.edge(this, a, 1, child, 1, FlowGraph.EDGE_KEY_OTHER);
        }
        if (Report.should_report("cfg", 2)) {
            Report.report(2, "// node " + a + " -> " + succs);
        }
        succs = a.acceptCFG(this, succs);
        Iterator i = succs.iterator();
        while (i.hasNext()) {
            EdgeKeyTermPair s = (EdgeKeyTermPair)i.next();
            this.edge(a, s.term, s.entry, s.edgeKey);
        }
        this.visitThrow(a);
    }

    public void visitThrow(Term a) {
        Iterator i = a.del().throwTypes(this.ts).iterator();
        while (i.hasNext()) {
            Type type = (Type)i.next();
            this.visitThrow(a, 0, type);
        }
        if (a instanceof Stmt && !(a instanceof CompoundStmt) || a instanceof Block && ((Block)a).statements().isEmpty()) {
            this.visitThrow(a, 0, this.ts.Error());
        }
    }

    public void visitThrow(Term t, int entry, Type type) {
        int e;
        Term last = t;
        CFGBuilder last_visitor = this;
        CFGBuilder v = this;
        while (v != null) {
            Stmt c = v.innermostTarget;
            if (c instanceof Try) {
                Try tr = (Try)c;
                if (!v.skipInnermostCatches) {
                    boolean definiteCatch = false;
                    Iterator i = tr.catchBlocks().iterator();
                    while (i.hasNext()) {
                        int e2;
                        Catch cb = (Catch)i.next();
                        int n = e2 = last == t && entry == 1 ? 1 : 0;
                        if (type.isImplicitCastValid(cb.catchType())) {
                            this.edge(last_visitor, last, e2, cb, 1, new FlowGraph.ExceptionEdgeKey(type));
                            definiteCatch = true;
                            continue;
                        }
                        if (!cb.catchType().isImplicitCastValid(type)) continue;
                        this.edge(last_visitor, last, e2, cb, 1, new FlowGraph.ExceptionEdgeKey(cb.catchType()));
                    }
                    if (definiteCatch) {
                        return;
                    }
                }
                if (tr.finallyBlock() != null) {
                    last_visitor = CFGBuilder.tryFinally(v, last, last_visitor, tr.finallyBlock());
                    last = tr.finallyBlock();
                }
            }
            v = v.outer;
        }
        int n = e = last == t && entry == 1 ? 1 : 0;
        if (this.errorEdgesToExitNode || !type.isSubtype(this.ts.Error())) {
            this.edge(last_visitor, last, e, this.graph.root(), 0, new FlowGraph.ExceptionEdgeKey(type));
        }
    }

    protected static CFGBuilder tryFinally(CFGBuilder v, Term last, CFGBuilder last_visitor, Block finallyBlock) {
        CFGBuilder v_ = v.outer.enterFinally(last);
        v_.edge(last_visitor, last, finallyBlock, 1, FlowGraph.EDGE_KEY_OTHER);
        v_.visitCFG(finallyBlock, Collections.EMPTY_LIST);
        return v_;
    }

    protected CFGBuilder enterFinally(Term from) {
        CFGBuilder v = (CFGBuilder)this.copy();
        v.path_to_finally = new ArrayList(this.path_to_finally.size() + 1);
        v.path_to_finally.addAll(this.path_to_finally);
        v.path_to_finally.add(from);
        return v;
    }

    public void edge(Term p, Term q, int qEntry) {
        this.edge(this, p, q, qEntry, FlowGraph.EDGE_KEY_OTHER);
    }

    public void edge(Term p, Term q, int qEntry, FlowGraph.EdgeKey edgeKey) {
        this.edge(this, p, q, qEntry, edgeKey);
    }

    public void edge(CFGBuilder p_visitor, Term p, Term q, int qEntry, FlowGraph.EdgeKey edgeKey) {
        this.edge(p_visitor, p, 0, q, qEntry, edgeKey);
    }

    public void edge(CFGBuilder p_visitor, Term p, int pEntry, Term q, int qEntry, FlowGraph.EdgeKey edgeKey) {
        if (Report.should_report("cfg", 2)) {
            Report.report(2, "//     edge " + p + " -> " + q);
        }
        FlowGraph.Peer pp = this.graph.peer(p, p_visitor.path_to_finally, pEntry);
        FlowGraph.Peer pq = this.graph.peer(q, this.path_to_finally, qEntry);
        if (Report.should_report("cfg", 3)) {
            Report.report(2, pp.hashCode() + " [ label = \"" + StringUtil.escape(pp.toString()) + "\" ];");
            Report.report(2, pq.hashCode() + " [ label = \"" + StringUtil.escape(pq.toString()) + "\" ];");
        } else if (Report.should_report("cfg", 2)) {
            Report.report(2, pp.hashCode() + " [ label = \"" + StringUtil.escape(pp.node.toString()) + "\" ];");
            Report.report(2, pq.hashCode() + " [ label = \"" + StringUtil.escape(pq.node.toString()) + "\" ];");
        }
        if (this.graph.forward()) {
            if (Report.should_report("cfg", 2)) {
                Report.report(2, pp.hashCode() + " -> " + pq.hashCode() + " [label=\"" + edgeKey + "\"];");
            }
            pp.succs.add(new FlowGraph.Edge(edgeKey, pq));
            pq.preds.add(new FlowGraph.Edge(edgeKey, pp));
        } else {
            if (Report.should_report("cfg", 2)) {
                Report.report(2, pq.hashCode() + " -> " + pp.hashCode() + " [label=\"" + edgeKey + "\"];");
            }
            pq.succs.add(new FlowGraph.Edge(edgeKey, pp));
            pp.preds.add(new FlowGraph.Edge(edgeKey, pq));
        }
    }

    protected static class EdgeKeyTermPair {
        public final FlowGraph.EdgeKey edgeKey;
        public final Term term;
        public final int entry;

        public EdgeKeyTermPair(FlowGraph.EdgeKey edgeKey, Term term, int entry) {
            this.edgeKey = edgeKey;
            this.term = term;
            this.entry = entry;
        }

        public String toString() {
            return "{edgeKey=" + this.edgeKey + ",term=" + this.term + "," + (this.entry == 1 ? "entry" : "exit") + "}";
        }
    }
}

