/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.Job;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SubtypeSet;
import polyglot.visit.ErrorHandlingVisitor;
import polyglot.visit.NodeVisitor;

public class ExceptionChecker
extends ErrorHandlingVisitor {
    protected ExceptionChecker outer = null;
    protected Set catchable;
    protected SubtypeSet throwsSet;
    protected UncaughtReporter reporter;
    protected boolean catchAllThrowable = false;

    public ExceptionChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    public ExceptionChecker push(UncaughtReporter reporter) {
        ExceptionChecker ec = this.push();
        ec.reporter = reporter;
        ec.throwsSet = new SubtypeSet(this.ts.Throwable());
        return ec;
    }

    public ExceptionChecker push(Type catchableType) {
        ExceptionChecker ec = this.push();
        ec.catchable = Collections.singleton(catchableType);
        ec.throwsSet = new SubtypeSet(this.ts.Throwable());
        return ec;
    }

    public ExceptionChecker push(Collection catchableTypes) {
        ExceptionChecker ec = this.push();
        ec.catchable = new HashSet(catchableTypes);
        ec.throwsSet = new SubtypeSet(this.ts.Throwable());
        return ec;
    }

    public ExceptionChecker pushCatchAllThrowable() {
        ExceptionChecker ec = this.push();
        ec.throwsSet = new SubtypeSet(this.ts.Throwable());
        ec.catchAllThrowable = true;
        return ec;
    }

    public ExceptionChecker push() {
        this.throwsSet();
        ExceptionChecker ec = (ExceptionChecker)this.visitChildren();
        ec.outer = this;
        ec.catchable = null;
        ec.catchAllThrowable = false;
        return ec;
    }

    public ExceptionChecker pop() {
        return this.outer;
    }

    protected NodeVisitor enterCall(Node n) throws SemanticException {
        return n.del().exceptionCheckEnter(this);
    }

    protected NodeVisitor enterError(Node n) {
        return this.push();
    }

    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        ExceptionChecker inner = (ExceptionChecker)v;
        boolean isAncestor = false;
        ExceptionChecker ec = inner;
        while (!isAncestor && ec != null) {
            isAncestor = isAncestor || ec == this;
            ec = ec.outer;
        }
        if (!isAncestor) {
            throw new InternalCompilerError("oops!");
        }
        return n.del().exceptionCheck(inner);
    }

    public void throwsException(Type t, Position pos) throws SemanticException {
        if (!t.isUncheckedException()) {
            boolean exceptionCaught = false;
            for (ExceptionChecker ec = this; !exceptionCaught && ec != null; ec = ec.pop()) {
                if (ec.catchable != null) {
                    Iterator iter = ec.catchable.iterator();
                    while (iter.hasNext()) {
                        Type catchType = (Type)iter.next();
                        if (!this.ts.isSubtype(t, catchType)) continue;
                        exceptionCaught = true;
                        break;
                    }
                }
                if (!exceptionCaught && ec.throwsSet != null) {
                    ec.throwsSet.add(t);
                }
                if (!ec.catchAllThrowable) continue;
                exceptionCaught = true;
            }
            if (!exceptionCaught) {
                this.reportUncaughtException(t, pos);
            }
        }
    }

    public SubtypeSet throwsSet() {
        if (this.throwsSet == null) {
            this.throwsSet = new SubtypeSet(this.ts.Throwable());
        }
        return this.throwsSet;
    }

    protected void reportUncaughtException(Type t, Position pos) throws SemanticException {
        ExceptionChecker ec = this;
        UncaughtReporter ur = null;
        while (ec != null && ur == null) {
            ur = ec.reporter;
            ec = ec.outer;
        }
        if (ur == null) {
            ur = new UncaughtReporter();
        }
        ur.uncaughtType(t, pos);
    }

    public static class CodeTypeReporter
    extends UncaughtReporter {
        public final String codeType;

        public CodeTypeReporter(String codeType) {
            this.codeType = codeType;
        }

        void uncaughtType(Type t, Position pos) throws SemanticException {
            throw new SemanticException("A " + this.codeType + " can not " + "throw a \"" + t + "\".", pos);
        }
    }

    public static class UncaughtReporter {
        void uncaughtType(Type t, Position pos) throws SemanticException {
            throw new SemanticException("The exception \"" + t + "\" must either be caught or declared to be thrown.", pos);
        }
    }
}

