/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import polyglot.ast.ArrayInit;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Block;
import polyglot.ast.BooleanLit;
import polyglot.ast.Conditional;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Do;
import polyglot.ast.Empty;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.FieldDecl;
import polyglot.ast.For;
import polyglot.ast.ForInit;
import polyglot.ast.Id;
import polyglot.ast.If;
import polyglot.ast.IntLit;
import polyglot.ast.Lit;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.ast.Unary;
import polyglot.ast.While;
import polyglot.frontend.Job;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.util.UniqueID;
import polyglot.visit.NodeVisitor;

public class ExpressionFlattener
extends NodeVisitor {
    protected final Job job;
    protected final TypeSystem ts;
    protected final NodeFactory nf;
    protected final Stack blockStack = new Stack();
    protected final Set dontFlatten = new HashSet();
    protected final DeepCopier deepCopier = new DeepCopier();
    protected final Local dummyLocal;

    public ExpressionFlattener(Job job, TypeSystem ts, NodeFactory nf) {
        this.job = job;
        this.ts = ts;
        this.nf = nf;
        this.dummyLocal = nf.Local(Position.compilerGenerated(), nf.Id(Position.compilerGenerated(), "dummy"));
    }

    public Node override(Node parent, Node n) {
        if (n instanceof If) {
            If s = (If)n;
            Stmt s1 = s.consequent();
            Stmt s2 = s.alternative();
            if (!(s1 instanceof Block)) {
                s = s.consequent(this.createBlock(s1));
            }
            if (s2 != null && !(s2 instanceof Block)) {
                s = s.alternative(this.createBlock(s2));
            }
            return this.visitEdgeNoOverride(parent, s);
        }
        if (n instanceof While) {
            While s = (While)n;
            Stmt b = (Stmt)this.visitEdge(s, this.createBlock(s.body()));
            s = s.body(b);
            this.addStmt(s);
            return s;
        }
        if (n instanceof Do) {
            Do s = (Do)n;
            Stmt b = (Stmt)this.visitEdge(s, this.createBlock(s.body()));
            s = s.body(b);
            this.addStmt(s);
            return s;
        }
        if (n instanceof For) {
            For s = (For)n;
            Stmt b = (Stmt)this.visitEdge(s, this.createBlock(s.body()));
            s = s.body(b);
            this.addStmt(s);
            return s;
        }
        if (n instanceof Binary) {
            Binary b = (Binary)n;
            return this.translateBinary(b);
        }
        if (n instanceof Conditional) {
            Conditional c = (Conditional)n;
            Expr cond = (Expr)this.visitEdge(c, c.cond());
            LocalDecl d = this.createDecl(c, null);
            this.addStmt(d);
            Local l = this.createLocal(d);
            If s = this.createCondIf(cond, l, c.consequent(), c.alternative(), c);
            s = (If)this.visitEdge(c, s);
            this.addStmt(s);
            return l;
        }
        if (n instanceof ConstructorCall) {
            this.addStmt((Stmt)n);
            return n;
        }
        if (n instanceof FieldDecl) {
            return n;
        }
        return null;
    }

    public NodeVisitor enter(Node n) {
        Unary u;
        LocalDecl d;
        Expr e;
        if (n instanceof Block) {
            this.pushBlock();
        }
        if (n instanceof Eval) {
            Eval s = (Eval)n;
            this.addDontFlatten(s.expr());
        }
        if (n instanceof Assign) {
            Assign a = (Assign)n;
            this.addDontFlatten(a.left());
            if (a.left() instanceof Local && !this.isAssign(a.right())) {
                this.addDontFlatten(a.right());
            }
        }
        if (n instanceof LocalDecl && (e = (d = (LocalDecl)n).init()) != null && !this.isAssign(e)) {
            this.addDontFlatten(e);
        }
        if (n instanceof ArrayInit) {
            this.addDontFlatten((ArrayInit)n);
        }
        if (n instanceof Unary && this.isAssign(u = (Unary)n)) {
            this.addDontFlatten(u.expr());
        }
        return this;
    }

    public Node leave(Node parent, Node old, Node n, NodeVisitor v) {
        Eval ev;
        if (n instanceof Block) {
            Block b = (Block)n;
            n = b.statements(this.popBlock());
        }
        if (n instanceof Eval && (ev = (Eval)n).expr() instanceof Local) {
            n = this.createEmpty();
        }
        if (n instanceof LocalDecl) {
            n = this.translateLocalDecl((LocalDecl)n);
        }
        if (n instanceof Stmt && parent instanceof Block) {
            this.addStmt((Stmt)n);
            return n;
        }
        if (!this.inBlock()) {
            return n;
        }
        if (n instanceof Expr) {
            boolean flatten;
            boolean bl = flatten = !this.dontFlatten((Expr)old);
            if (n instanceof Unary && this.isAssign((Unary)n)) {
                Unary u = (Unary)n;
                Block inc = this.createBlock(this.createIncDec(u));
                Local l = null;
                Eval a = null;
                if (flatten) {
                    Expr e = u.expr();
                    LocalDecl d = this.createDecl(e, null);
                    this.addStmt(d);
                    l = this.createLocal(d);
                    a = this.createAssign(l, e);
                }
                if (u.operator().isPrefix()) {
                    inc = (Block)this.visitEdge(n, inc);
                    this.addStmt(inc);
                    if (flatten) {
                        this.addStmt(a);
                    }
                } else {
                    if (flatten) {
                        this.addStmt(a);
                    }
                    inc = (Block)this.visitEdge(n, inc);
                    this.addStmt(inc);
                }
                if (flatten) {
                    return l;
                }
                return this.dummyLocal;
            }
            if (n instanceof Assign && !this.isSimpleAssign((Assign)n)) {
                Assign a = (Assign)n;
                a = this.createSimpleAssign(a);
                if (!flatten) {
                    this.addDontFlatten(a);
                }
                return this.visitEdge(n, a);
            }
            if (flatten) {
                Expr e;
                Expr val = e = (Expr)n;
                if (e instanceof Assign) {
                    Assign a = (Assign)e;
                    val = (Expr)this.deepCopy(a.left());
                    Eval s = this.createEval(a);
                    this.addStmt(s);
                }
                return this.createDeclWithInit(e, val);
            }
        }
        return n;
    }

    protected Node translateBinary(Binary b) {
        if (this.neverFlatten(b)) {
            return b;
        }
        return this.translateShortCircuitBinary(b);
    }

    protected Node translateShortCircuitBinary(Binary b) {
        if (b.operator() == Binary.COND_AND) {
            Expr left = (Expr)this.visitEdge(b, b.left());
            if (left instanceof BooleanLit) {
                BooleanLit lit = (BooleanLit)left;
                if (!lit.value()) {
                    return lit;
                }
                return this.visitEdge(b, b.right());
            }
            LocalDecl d = this.createDecl(b, null);
            this.addStmt(d);
            Local r = this.createLocal(d);
            If s = this.createAndIf(left, r, b.right(), b);
            s = (If)this.visitEdge(b, s);
            this.addStmt(s);
            return r;
        }
        if (b.operator() == Binary.COND_OR) {
            Expr left = (Expr)this.visitEdge(b, b.left());
            if (left instanceof BooleanLit) {
                BooleanLit lit = (BooleanLit)left;
                if (lit.value()) {
                    return lit;
                }
                return this.visitEdge(b, b.right());
            }
            LocalDecl d = this.createDecl(b, null);
            this.addStmt(d);
            Local r = this.createLocal(d);
            If s = this.createOrIf(left, r, b.right(), b);
            s = (If)this.visitEdge(b, s);
            this.addStmt(s);
            return r;
        }
        return null;
    }

    protected Node translateLocalDecl(LocalDecl d) {
        ForInit n = d;
        Expr e = d.init();
        if (e != null) {
            d = d.init(null);
            this.addStmt(d);
            Local l = this.createLocal(d);
            n = this.createAssign(l, e);
        }
        return n;
    }

    protected Local createDeclWithInit(Expr e, Expr val) {
        LocalDecl d = this.createDecl(e, val);
        this.addStmt(d);
        Local l = this.createLocal(d);
        return l;
    }

    protected boolean dontFlatten(Expr e) {
        boolean ret = this.dontFlatten.contains(e);
        this.dontFlatten.remove(e);
        return ret || this.neverFlatten(e);
    }

    protected void addDontFlatten(Expr e) {
        this.dontFlatten.add(e);
    }

    protected boolean neverFlatten(Expr e) {
        return e instanceof Lit || e instanceof Special || e instanceof Local;
    }

    protected void pushBlock() {
        this.blockStack.push(new ArrayList());
    }

    protected List popBlock() {
        return (List)this.blockStack.pop();
    }

    protected boolean inBlock() {
        return !this.blockStack.empty();
    }

    protected void addStmt(Stmt s) {
        ((List)this.blockStack.peek()).add(s);
    }

    protected Node postCreate(Node n) {
        return n;
    }

    protected String newId() {
        return UniqueID.newID("flat");
    }

    protected boolean isAssign(Expr e) {
        if (e instanceof Unary) {
            Unary u = (Unary)e;
            return u.operator() == Unary.POST_INC || u.operator() == Unary.POST_DEC || u.operator() == Unary.PRE_INC || u.operator() == Unary.PRE_DEC;
        }
        return e instanceof Assign;
    }

    protected boolean isSimpleAssign(Expr e) {
        if (e instanceof Assign) {
            Assign a = (Assign)e;
            return a.operator() == Assign.ASSIGN;
        }
        return false;
    }

    protected Node deepCopy(Node n) {
        return n.visit(this.deepCopier);
    }

    protected Block createBlock(Stmt s) {
        if (s instanceof Block) {
            return (Block)s;
        }
        Block b = this.nf.Block(s.position(), s);
        b = (Block)this.postCreate(b);
        return b;
    }

    protected Empty createEmpty() {
        Empty s = this.nf.Empty(Position.compilerGenerated());
        s = (Empty)this.postCreate(s);
        return s;
    }

    protected Eval createEval(Expr e) {
        Eval s = this.nf.Eval(e.position(), e);
        s = (Eval)this.postCreate(s);
        return s;
    }

    protected LocalDecl createDecl(Expr e, Expr init) {
        String name = this.newId();
        Position pos = e.position();
        LocalInstance li = this.ts.localInstance(pos, Flags.NONE, this.typeOf(e), name);
        LocalDecl d = this.nf.LocalDecl(pos, Flags.NONE, (TypeNode)this.postCreate(this.nf.CanonicalTypeNode(pos, this.typeOf(e))), (Id)this.postCreate(this.nf.Id(pos, name)), init);
        d = d.localInstance(li);
        d = (LocalDecl)this.postCreate(d);
        return d;
    }

    protected Local createLocal(LocalDecl d) {
        Position pos = d.position();
        LocalInstance li = d.localInstance();
        Local l = (Local)this.nf.Local(pos, (Id)this.postCreate(this.nf.Id(pos, d.name()))).type(this.typeOf(li));
        l = l.localInstance(li);
        l = (Local)this.postCreate(l);
        return l;
    }

    protected Eval createAssign(Expr l, Expr r) {
        Position pos = l.position();
        l = (Expr)this.deepCopy(l);
        Eval a = this.nf.Eval(pos, ((Assign)this.postCreate(this.nf.Assign(pos, l, Assign.ASSIGN, r))).type(this.typeOf(l)));
        a = (Eval)this.postCreate(a);
        return a;
    }

    protected Assign createSimpleAssign(Assign a) {
        Position pos = a.position();
        Binary.Operator op = a.operator().binaryOperator();
        a = (Assign)this.nf.Assign(pos, a.left(), Assign.ASSIGN, ((Binary)this.postCreate(this.nf.Binary(pos, (Expr)this.deepCopy(a.left()), op, a.right()))).type(this.typeOf(a))).type(this.typeOf(a));
        a = (Assign)this.postCreate(a);
        return a;
    }

    protected Eval createIncDec(Unary u) {
        Position pos = u.position();
        Binary.Operator op = u.operator() == Unary.PRE_INC || u.operator() == Unary.POST_INC ? Binary.ADD : Binary.SUB;
        Expr e = u.expr();
        Eval a = this.createAssign(e, ((Binary)this.postCreate(this.nf.Binary(pos, (Expr)this.deepCopy(e), op, this.createInt(1)))).type(this.typeOf(e)));
        return a;
    }

    protected If createAndIf(Expr cond, Local l, Expr e, Binary original) {
        Position pos = l.position();
        cond = (Expr)this.deepCopy(cond);
        If s = this.nf.If(pos, cond, this.createAssign(l, e), this.createAssign(l, this.createBool(false)));
        s = (If)this.postCreate(s);
        return s;
    }

    protected If createOrIf(Expr cond, Local l, Expr e, Binary original) {
        Position pos = l.position();
        cond = (Expr)this.deepCopy(cond);
        If s = this.nf.If(pos, cond, this.createAssign(l, this.createBool(true)), this.createAssign(l, e));
        s = (If)this.postCreate(s);
        return s;
    }

    protected If createCondIf(Expr cond, Local l, Expr e1, Expr e2, Conditional original) {
        Position pos = l.position();
        If s = this.nf.If(pos, cond, this.createAssign(l, e1), this.createAssign(l, e2));
        s = (If)this.postCreate(s);
        return s;
    }

    protected BooleanLit createBool(boolean val) {
        return (BooleanLit)((BooleanLit)this.postCreate(this.nf.BooleanLit(Position.compilerGenerated(), val))).type(this.ts.Boolean());
    }

    protected IntLit createInt(int val) {
        return (IntLit)((IntLit)this.postCreate(this.nf.IntLit(Position.compilerGenerated(), IntLit.INT, val))).type(this.ts.Int());
    }

    protected Type typeOf(Expr e) {
        return e.type();
    }

    protected Type typeOf(LocalInstance li) {
        return li.type();
    }

    protected class DeepCopier
    extends NodeVisitor {
        protected DeepCopier() {
        }

        public Node leave(Node old, Node n, NodeVisitor v) {
            return (Node)n.copy();
        }
    }
}

