/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Local;
import polyglot.ast.LocalClassDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.IdentityKey;
import polyglot.util.Position;
import polyglot.util.Transformation;
import polyglot.util.TransformingList;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class LocalClassRemoverOld
extends ContextVisitor {
    List unclaimedDecls;
    Map envMap = new HashMap();
    int[] count;

    public LocalClassRemoverOld(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
        this.unclaimedDecls = new ArrayList();
        this.count = new int[1];
    }

    protected String newFieldName(String name) {
        return this.namePrefix() + name;
    }

    protected String namePrefix() {
        return "jl$";
    }

    List computeClosure(ClassBody body, Context context, Context innerContext) {
        EnvCollector v = new EnvCollector(this.job, this.ts, this.nf, context, innerContext);
        v = (EnvCollector)v.begin();
        body.visit(v);
        v.finish();
        return v.env();
    }

    String generateName() {
        return this.generateName("Anon");
    }

    String generateName(String base) {
        int n = this.count[0];
        this.count[0] = n + 1;
        return base + "$jl" + n;
    }

    FieldInstance localToField(ParsedClassType ct, LocalInstance li) {
        FieldInstance fi = this.ts.fieldInstance(li.position(), ct, li.flags().Protected(), li.type(), this.namePrefix() + li.name());
        return fi;
    }

    FieldDecl createFieldDecl(FieldInstance fi) {
        FieldDecl fd = this.nf.FieldDecl(fi.position(), fi.flags(), (TypeNode)this.nf.CanonicalTypeNode(fi.position(), fi.type()), fi.name());
        fd = fd.fieldInstance(fi);
        return fd;
    }

    ConstructorInstance createEmptyCI(ParsedClassType ct) {
        ConstructorInstance ci = this.ts.constructorInstance(ct.position(), ct, Flags.PRIVATE, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        ct.addConstructor(ci);
        return ci;
    }

    ConstructorDecl createEmptyConstructorDecl(ParsedClassType ct, ConstructorInstance ci) {
        ArrayList<ConstructorCall> stmts = new ArrayList<ConstructorCall>();
        try {
            ConstructorCall superCall;
            ConstructorInstance superCI = ct.typeSystem().findConstructor((ClassType)ct.superType(), Collections.EMPTY_LIST, ct);
            if (!ct.flags().isStatic()) {
                Special this_ = this.nf.Special(ci.position(), Special.THIS, this.nf.CanonicalTypeNode(ci.position(), ct.container()));
                this_ = (Special)this_.type(ct.container());
                superCall = this.nf.SuperCall(ci.position(), this_, Collections.EMPTY_LIST);
            } else {
                superCall = this.nf.SuperCall(ci.position(), Collections.EMPTY_LIST);
            }
            superCall = superCall.constructorInstance(superCI);
            stmts.add(superCall);
        }
        catch (SemanticException e) {
            // empty catch block
        }
        Block b = this.nf.Block(ci.position(), stmts);
        ConstructorDecl cd = this.nf.ConstructorDecl(ci.position(), ci.flags(), ct.name(), Collections.EMPTY_LIST, Collections.EMPTY_LIST, b);
        cd = cd.constructorInstance(ci);
        return cd;
    }

    void addEnvToCI(ConstructorInstance ci, List env) {
        ArrayList formals = new ArrayList(ci.formalTypes());
        formals.addAll(this.envAsFormalTypes(env));
        ci.setFormalTypes(formals);
    }

    ConstructorDecl translateConstructorDecl(ParsedClassType ct, ConstructorDecl cd, Map m) {
        ArrayList newArgs;
        Stmt s;
        List env = this.env(ct);
        this.addEnvToCI(cd.constructorInstance(), env);
        cd = cd.name(ct.name());
        List envAsFormals = this.envAsFormals(env);
        ArrayList newFormals = new ArrayList();
        newFormals.addAll(cd.formals());
        newFormals.addAll(envAsFormals);
        cd = cd.formals(newFormals);
        if (cd.body() == null) {
            return cd;
        }
        List oldStmts = cd.body().statements();
        ArrayList<Stmt> newStmts = new ArrayList<Stmt>();
        ConstructorCall cc = null;
        if (oldStmts.size() >= 1 && (s = (Stmt)oldStmts.get(0)) instanceof ConstructorCall) {
            cc = (ConstructorCall)s;
        }
        if (cc != null && cc.kind() == ConstructorCall.THIS) {
            newArgs = new ArrayList();
            newArgs.addAll(cc.arguments());
            newArgs.addAll(this.envAsLocalActuals(envAsFormals));
            ConstructorCall newCC = (ConstructorCall)cc.arguments(newArgs);
            newStmts.add(newCC);
        } else if (cc != null) {
            newArgs = new ArrayList();
            newArgs.addAll(cc.arguments());
            ArrayList<Formal> superEnvAsFormals = new ArrayList<Formal>();
            List superEnv = this.env((ClassType)ct.superType());
            Iterator i = superEnv.iterator();
            while (i.hasNext()) {
                LocalInstance li = (LocalInstance)i.next();
                Iterator j = envAsFormals.iterator();
                Iterator k = env.iterator();
                while (j.hasNext()) {
                    Formal f = (Formal)j.next();
                    LocalInstance li2 = (LocalInstance)k.next();
                    if (!li.equals(li2)) continue;
                    superEnvAsFormals.add(f);
                }
            }
            newArgs.addAll(this.envAsLocalActuals(superEnvAsFormals));
            ConstructorCall newCC = (ConstructorCall)cc.arguments(newArgs);
            newStmts.add(newCC);
        }
        if (cc == null || cc.kind() == ConstructorCall.SUPER) {
            Iterator i = env.iterator();
            while (i.hasNext()) {
                LocalInstance li = (LocalInstance)i.next();
                FieldInstance fi = (FieldInstance)m.get(new IdentityKey(li));
                if (fi == null || !fi.container().equals(ct)) continue;
                Special this_ = this.nf.Special(cd.position(), Special.THIS);
                this_ = (Special)this_.type(ct);
                Field target = this.nf.Field(cd.position(), (Receiver)this_, fi.name());
                target = target.fieldInstance(fi);
                target = (Field)target.type(fi.type());
                Local source = this.nf.Local(cd.position(), li.name());
                source = source.localInstance(li);
                source = (Local)source.type(li.type());
                FieldAssign assign = this.nf.FieldAssign(cd.position(), target, Assign.ASSIGN, source);
                assign = (FieldAssign)assign.type(target.type());
                newStmts.add(this.nf.Eval(cd.position(), assign));
            }
        }
        if (cc != null) {
            for (int i = 1; i < oldStmts.size(); ++i) {
                newStmts.add((Stmt)oldStmts.get(i));
            }
        } else {
            newStmts.addAll(oldStmts);
        }
        Block b = cd.body().statements(newStmts);
        cd = (ConstructorDecl)cd.body(b);
        return cd;
    }

    ClassDecl createMemberClass(ParsedClassType ct, ClassBody body) {
        CanonicalTypeNode superClass = this.nf.CanonicalTypeNode(ct.position(), ct.superType());
        TransformingList interfaces = new TransformingList(ct.interfaces(), new Transformation(){

            public Object transform(Object o) {
                Type t = (Type)o;
                return LocalClassRemoverOld.this.nf.CanonicalTypeNode(t.position(), t);
            }
        });
        ClassDecl cd = this.nf.ClassDecl(ct.position(), ct.flags(), ct.name(), (TypeNode)superClass, (List)interfaces, body);
        cd.type(ct);
        return cd;
    }

    List env(ClassType ct) {
        if (ct != null) {
            List superEnv = this.env((ClassType)ct.superType());
            List env = (List)this.envMap.get(ct);
            if (env == null || env.isEmpty()) {
                return superEnv;
            }
            if (superEnv.isEmpty()) {
                return env;
            }
            ArrayList l = new ArrayList();
            l.addAll(superEnv);
            l.removeAll(env);
            l.addAll(env);
            return l;
        }
        return Collections.EMPTY_LIST;
    }

    List envAsFormalTypes(List env) {
        ArrayList<Type> formals = new ArrayList<Type>();
        Iterator i = env.iterator();
        while (i.hasNext()) {
            LocalInstance li = (LocalInstance)i.next();
            formals.add(li.type());
        }
        return formals;
    }

    List envAsFormals(List env) {
        ArrayList<Formal> formals = new ArrayList<Formal>();
        Iterator i = env.iterator();
        while (i.hasNext()) {
            LocalInstance li = (LocalInstance)i.next();
            Formal f = this.nf.Formal(Position.compilerGenerated(), li.flags(), (TypeNode)this.nf.CanonicalTypeNode(li.position(), li.type()), li.name());
            f = f.localInstance((LocalInstance)li.copy());
            formals.add(f);
        }
        return formals;
    }

    List envAsLocalActuals(List envAsFormals) {
        ArrayList<Local> actuals = new ArrayList<Local>();
        Iterator i = envAsFormals.iterator();
        while (i.hasNext()) {
            Formal f = (Formal)i.next();
            LocalInstance li = f.localInstance();
            Local local = this.nf.Local(li.position(), li.name());
            local = local.localInstance(li);
            local = (Local)local.type(li.type());
            actuals.add(local);
        }
        return actuals;
    }

    List envAsActuals(List env) {
        ArrayList<Local> actuals = new ArrayList<Local>();
        Iterator i = env.iterator();
        while (i.hasNext()) {
            LocalInstance li = (LocalInstance)i.next();
            Local local = this.nf.Local(li.position(), li.name());
            local = local.localInstance(li);
            local = (Local)local.type(li.type());
            actuals.add(local);
        }
        return actuals;
    }

    protected boolean isLocal(ClassType ct) {
        for (ClassType sup = ct; sup != null; sup = (ClassType)sup.superType()) {
            if (!sup.isLocal()) continue;
            return true;
        }
        return false;
    }

    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        ParsedClassType container;
        ParsedClassType pct;
        ParsedClassType ct;
        Context innerContext = ((LocalClassRemoverOld)v).context();
        if (n instanceof ConstructorDecl && this.isLocal(ct = this.context.currentClassScope()) && !ct.isLocal()) {
            n = this.translateConstructorDecl(ct, (ConstructorDecl)n, Collections.EMPTY_MAP);
        }
        if (n instanceof New) {
            New newExp = (New)n;
            ClassType ct2 = (ClassType)newExp.objectType().type();
            if (newExp.body() != null) {
                pct = newExp.anonType();
                pct.kind(ClassType.MEMBER);
                pct.name(this.generateName());
                container = this.context.currentClassScope();
                container.addMemberClass(pct);
                pct.setContainer(container);
                pct.outer(container);
                if (pct.inStaticContext()) {
                    pct.setFlags(Flags.PRIVATE.Static());
                } else {
                    pct.setFlags(Flags.PRIVATE);
                }
                if (this.context.inStaticContext()) {
                    pct.setFlags(pct.flags().Static());
                }
                Context c = newExp.del().enterChildScope(newExp.body(), this.context);
                ClassBody body = newExp.body();
                this.translateAnonClassBody(pct, newExp.arguments(), body, c);
                newExp = newExp.body(null);
                newExp = newExp.anonType(null);
                newExp = newExp.objectType(this.nf.CanonicalTypeNode(newExp.position(), pct));
                ct2 = pct;
            }
            ArrayList newArgs = new ArrayList(newExp.arguments());
            newArgs.addAll(this.envAsActuals(this.env(ct2)));
            newExp = (New)newExp.arguments(newArgs);
            n = newExp;
        }
        if (n instanceof LocalClassDecl) {
            LocalClassDecl lcd = (LocalClassDecl)n;
            ClassDecl cd = lcd.decl();
            pct = cd.type();
            if (pct.isLocal()) {
                pct.kind(ClassType.MEMBER);
                pct.name(this.generateName(pct.name()));
                container = this.context.currentClassScope();
                container.addMemberClass(pct);
                pct.setContainer(container);
                pct.outer(container);
                if (pct.inStaticContext()) {
                    pct.setFlags(pct.flags().Private().Static());
                } else {
                    pct.setFlags(pct.flags().Private());
                }
                if (this.context.inStaticContext()) {
                    pct.setFlags(pct.flags().Static());
                }
                ClassBody body = cd.body();
                Context c = cd.del().enterChildScope(body, this.context);
                this.translateLocalClassBody(pct, body, c);
            }
            return this.nf.Empty(lcd.position());
        }
        if (n instanceof ClassBody) {
            ClassBody cb = (ClassBody)n;
            ArrayList<ClassDecl> members = new ArrayList<ClassDecl>(cb.members());
            Iterator i = this.unclaimedDecls.iterator();
            while (i.hasNext()) {
                ClassDecl cd = (ClassDecl)i.next();
                ClassType container2 = cd.type().outer();
                if (!container2.equals(innerContext.currentClass())) continue;
                members.add(cd);
                i.remove();
            }
            cb = cb.members(members);
            n = cb;
        }
        n = super.leaveCall(old, n, v);
        return n;
    }

    protected NodeVisitor enterCall(Node n) throws SemanticException {
        if (n instanceof LocalClassDecl) {
            LocalClassDecl lcd = (LocalClassDecl)n;
            ClassDecl cd = lcd.decl();
            ParsedClassType pct = cd.type();
            ClassBody body = cd.body();
            Context c = cd.del().enterChildScope(body, this.context);
            List env = this.computeClosure(body, this.context, c);
            this.envMap.put(pct, env);
        }
        return super.enterCall(n);
    }

    protected void translateAnonClassBody(ParsedClassType ct, List arguments, ClassBody body, Context context) {
        ArrayList<ConstructorCall> stmts = new ArrayList<ConstructorCall>(1);
        ClassType superCT = (ClassType)ct.superType();
        ArrayList<Type> argTypes = new ArrayList<Type>(arguments.size());
        Iterator it = arguments.iterator();
        while (it.hasNext()) {
            argTypes.add(((Expr)it.next()).type());
        }
        ConstructorInstance superCI = null;
        try {
            superCI = this.ts.findConstructor(superCT, argTypes, ct);
        }
        catch (SemanticException e) {
            // empty catch block
        }
        ArrayList<Formal> formals = new ArrayList<Formal>(argTypes.size());
        ArrayList<Local> actuals = new ArrayList<Local>(argTypes.size());
        Iterator it2 = superCI.formalTypes().iterator();
        while (it2.hasNext()) {
            Type type = (Type)it2.next();
            String name = "jl$arg" + formals.size();
            Id id = this.nf.Id(Position.compilerGenerated(), name);
            CanonicalTypeNode tn = this.nf.CanonicalTypeNode(Position.compilerGenerated(), type);
            Formal formal = this.nf.Formal(Position.compilerGenerated(), Flags.NONE, (TypeNode)tn, id);
            LocalInstance li = this.ts.localInstance(Position.compilerGenerated(), formal.flags(), type, name);
            formal = formal.localInstance(li);
            formals.add(formal);
            Local actual = this.nf.Local(Position.compilerGenerated(), id);
            actual = (Local)actual.type(type);
            actual = actual.localInstance(li);
            actuals.add(actual);
        }
        Special this_ = this.nf.Special(Position.compilerGenerated(), Special.THIS, this.nf.CanonicalTypeNode(Position.compilerGenerated(), ct.container()));
        this_ = (Special)this_.type(ct.container());
        ConstructorCall superCall = this.nf.SuperCall(Position.compilerGenerated(), this_, actuals);
        superCall = superCall.constructorInstance(superCI);
        stmts.add(superCall);
        ConstructorInstance ci = this.ts.constructorInstance(ct.position(), ct, Flags.PRIVATE, superCI.formalTypes(), superCI.throwTypes());
        ConstructorDecl decl = this.nf.ConstructorDecl(Position.compilerGenerated(), ci.flags(), this.nf.Id(Position.compilerGenerated(), ct.name()), formals, ci.throwTypes(), this.nf.Block(Position.compilerGenerated(), stmts));
        decl = decl.constructorInstance(ci);
        ArrayList<ConstructorDecl> members = new ArrayList<ConstructorDecl>(body.members());
        members.add(decl);
        body = body.members(members);
        this.translateLocalClassBody(ct, body, context);
    }

    protected void translateLocalClassBody(ParsedClassType ct, ClassBody body, Context context) {
        ArrayList<FieldDecl> members = new ArrayList<FieldDecl>();
        List env = this.env(ct);
        HashMap<IdentityKey, FieldInstance> fieldMap = new HashMap<IdentityKey, FieldInstance>();
        Iterator i = env.iterator();
        while (i.hasNext()) {
            LocalInstance li = (LocalInstance)i.next();
            FieldInstance fi = this.localToField(ct, li);
            fieldMap.put(new IdentityKey(li), fi);
            ct.addField(fi);
            members.add(this.createFieldDecl(fi));
        }
        ArrayList<ClassMember> ctors = new ArrayList<ClassMember>();
        ArrayList<ClassMember> others = new ArrayList<ClassMember>();
        Iterator i2 = body.members().iterator();
        while (i2.hasNext()) {
            ClassMember cm = (ClassMember)i2.next();
            if (cm instanceof ConstructorDecl) {
                ctors.add(cm);
                continue;
            }
            others.add(cm);
        }
        members.addAll(ctors);
        members.addAll(others);
        body = body.members(members);
        ClassBodyTranslator v = new ClassBodyTranslator(this.job, this.ts, this.nf, context, ct, fieldMap);
        v = (ClassBodyTranslator)v.begin();
        body = (ClassBody)body.visit(v);
        v.finish();
        ClassDecl cd = this.createMemberClass(ct, body);
        cd = cd.type(ct);
        this.unclaimedDecls.add(cd);
    }

    class ClassBodyTranslator
    extends ContextVisitor {
        ParsedClassType ct;
        Map fieldMap;
        Context outerContext;

        ClassBodyTranslator(Job job, TypeSystem ts, NodeFactory nf, Context context, ParsedClassType ct, Map fieldMap) {
            super(job, ts, nf);
            this.ct = ct;
            this.fieldMap = fieldMap;
            this.outerContext = context;
        }

        public NodeVisitor begin() {
            ContextVisitor v = (ContextVisitor)super.begin();
            v.context = this.outerContext;
            return v;
        }

        public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
            Local l;
            FieldInstance fi;
            if (n instanceof Local && (fi = (FieldInstance)this.fieldMap.get(new IdentityKey((l = (Local)n).localInstance().orig()))) != null) {
                Special this_ = this.ct.equals(this.context.currentClass()) ? this.nf.Special(l.position(), Special.THIS) : this.nf.Special(l.position(), Special.THIS, this.nf.CanonicalTypeNode(l.position(), this.ct));
                this_ = (Special)this_.type(this.ct);
                Field f = this.nf.Field(l.position(), (Receiver)this_, fi.name());
                f = f.fieldInstance(fi);
                f = (Field)f.type(fi.type());
                n = f;
            }
            if (n instanceof ConstructorDecl) {
                ConstructorDecl ctd = (ConstructorDecl)n;
                ClassType ct2 = (ClassType)ctd.constructorInstance().container();
                if (ct2.equals(this.ct)) {
                    ctd = LocalClassRemoverOld.this.translateConstructorDecl(this.ct, ctd, this.fieldMap);
                }
                n = ctd;
            }
            return super.leaveCall(old, n, v);
        }
    }

    static class EnvCollector
    extends ContextVisitor {
        List env = new ArrayList();
        Context outerContext;
        Context innerContext;

        EnvCollector(Job job, TypeSystem ts, NodeFactory nf, Context context, Context innerContext) {
            super(job, ts, nf);
            this.outerContext = context;
            this.innerContext = innerContext;
        }

        List env() {
            return this.env;
        }

        public NodeVisitor begin() {
            ContextVisitor v = (ContextVisitor)super.begin();
            v.context = this.innerContext;
            return v;
        }

        public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
            Local local;
            if (n instanceof Local && !this.context.isLocal((local = (Local)n).name())) {
                try {
                    LocalInstance li = this.outerContext.findLocal(local.name());
                    if (this.outerContext.isLocal(local.name())) {
                        this.env.add(local.localInstance().orig());
                    }
                }
                catch (SemanticException e) {
                    // empty catch block
                }
            }
            return super.leaveCall(old, n, v);
        }
    }
}

