/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import polyglot.ast.Node;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.util.StringUtil;

public abstract class NodeVisitor
implements Copy {
    public Node override(Node parent, Node n) {
        return this.override(n);
    }

    public Node override(Node n) {
        return null;
    }

    public NodeVisitor enter(Node parent, Node n) {
        return this.enter(n);
    }

    public NodeVisitor enter(Node n) {
        return this;
    }

    public Node leave(Node parent, Node old, Node n, NodeVisitor v) {
        return this.leave(old, n, v);
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        return n;
    }

    public NodeVisitor begin() {
        return this;
    }

    public void finish() {
    }

    public void finish(Node ast) {
        this.finish();
    }

    public String toString() {
        return StringUtil.getShortNameComponent(this.getClass().getName());
    }

    public Node visitEdge(Node parent, Node child) {
        try {
            Node n = this.override(parent, child);
            if (n == null) {
                return this.visitEdgeNoOverride(parent, child);
            }
            return n;
        }
        catch (InternalCompilerError e) {
            if (e.position() == null && child != null) {
                e.setPosition(child.position());
            }
            throw e;
        }
    }

    public Node visitEdgeNoOverride(Node parent, Node child) {
        if (child == null) {
            return null;
        }
        NodeVisitor v_ = this.enter(parent, child);
        if (v_ == null) {
            throw new InternalCompilerError("NodeVisitor.enter() returned null.");
        }
        Node n = child.del().visitChildren(v_);
        if (n == null) {
            throw new InternalCompilerError("Node.visitChildren() returned null.");
        }
        try {
            n = this.leave(parent, child, n, v_);
        }
        catch (InternalCompilerError e) {
            if (e.position() == null && n != null) {
                e.setPosition(n.position());
            }
            throw e;
        }
        return n;
    }

    public Object copy() {
        try {
            return (NodeVisitor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("Java clone() weirdness.");
        }
    }
}

