/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Iterator;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.frontend.Job;
import polyglot.types.Context;
import polyglot.types.TypeSystem;
import polyglot.visit.DisambiguationDriver;
import polyglot.visit.Disambiguator;

public class SupertypeDisambiguator
extends Disambiguator {
    public SupertypeDisambiguator(DisambiguationDriver dd) {
        super(dd);
    }

    public SupertypeDisambiguator(Job job, TypeSystem ts, NodeFactory nf, Context c) {
        super(job, ts, nf, c);
    }

    public Node override(Node parent, Node n) {
        if (n instanceof ClassDecl) {
            ClassDecl cd;
            ClassDecl old = cd = (ClassDecl)n;
            SupertypeDisambiguator v = (SupertypeDisambiguator)this.enter(parent, cd);
            cd = cd.superClass((TypeNode)cd.visitChild(cd.superClass(), v));
            if (v.hasErrors()) {
                return cd;
            }
            ArrayList<TypeNode> newInterfaces = new ArrayList<TypeNode>();
            Iterator i = cd.interfaces().iterator();
            while (i.hasNext()) {
                TypeNode tn = (TypeNode)i.next();
                newInterfaces.add((TypeNode)cd.visitChild(tn, v));
                if (!v.hasErrors()) continue;
                return cd;
            }
            cd = cd.interfaces(newInterfaces);
            cd = (ClassDecl)this.leave(parent, old, cd, v);
            if (this.hasErrors()) {
                return cd;
            }
            cd = cd.body((ClassBody)cd.visitChild(cd.body(), v));
            if (v.hasErrors()) {
                return cd;
            }
            return this.leave(parent, old, cd, v);
        }
        if (n instanceof ClassMember) {
            return n;
        }
        if (n instanceof Stmt || n instanceof Expr) {
            return n;
        }
        return super.override(parent, n);
    }
}

