/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.Iterator;
import java.util.LinkedList;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.ImportTable;
import polyglot.types.Named;
import polyglot.types.Package;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;

public class TypeBuilder
extends NodeVisitor {
    protected ImportTable importTable;
    protected Job job;
    protected TypeSystem ts;
    protected NodeFactory nf;
    protected TypeBuilder outer;
    protected boolean inCode;
    protected boolean global;
    protected Package package_;
    protected ParsedClassType type;

    public TypeBuilder(Job job, TypeSystem ts, NodeFactory nf) {
        this.job = job;
        this.ts = ts;
        this.nf = nf;
        this.outer = null;
    }

    public TypeBuilder push() {
        TypeBuilder tb = (TypeBuilder)this.copy();
        tb.outer = this;
        return tb;
    }

    public TypeBuilder pop() {
        return this.outer;
    }

    public Job job() {
        return this.job;
    }

    public ErrorQueue errorQueue() {
        return this.job().compiler().errorQueue();
    }

    public NodeFactory nodeFactory() {
        return this.nf;
    }

    public TypeSystem typeSystem() {
        return this.ts;
    }

    public NodeVisitor begin() {
        return this;
    }

    public NodeVisitor enter(Node n) {
        try {
            return n.del().buildTypesEnter(this);
        }
        catch (SemanticException e) {
            Position position = e.position();
            if (position == null) {
                position = n.position();
            }
            if (e.getMessage() != null) {
                this.errorQueue().enqueue(5, e.getMessage(), position);
            }
            return this;
        }
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        try {
            return n.del().buildTypes((TypeBuilder)v);
        }
        catch (SemanticException e) {
            Position position = e.position();
            if (position == null) {
                position = n.position();
            }
            if (e.getMessage() != null) {
                this.errorQueue().enqueue(5, e.getMessage(), position);
            }
            return n;
        }
    }

    public TypeBuilder pushContext(Context c) throws SemanticException {
        LinkedList<Context> stack = new LinkedList<Context>();
        while (c != null) {
            stack.addFirst(c);
            c = c.pop();
        }
        TypeBuilder tb = this;
        boolean inCode = false;
        Iterator i = stack.iterator();
        while (i.hasNext()) {
            c = (Context)i.next();
            if (c.inCode()) {
                if (inCode) continue;
                inCode = true;
                tb = tb.pushCode();
                continue;
            }
            if (c.importTable() != null && tb.importTable() == null) {
                tb.setImportTable(c.importTable());
            }
            if (c.importTable() != null && c.package_() != null && tb.currentPackage() == null) {
                tb = tb.pushPackage(c.package_());
            }
            if (c.currentClassScope() == tb.currentClass()) continue;
            tb = tb.pushClass(c.currentClassScope());
        }
        return tb;
    }

    public TypeBuilder pushPackage(Package p) {
        if (Report.should_report("visit", 4)) {
            Report.report(4, "TB pushing package " + p + ": " + this.context());
        }
        TypeBuilder tb = this.push();
        tb.inCode = false;
        tb.package_ = p;
        return tb;
    }

    public TypeBuilder pushCode() {
        if (Report.should_report("visit", 4)) {
            Report.report(4, "TB pushing code: " + this.context());
        }
        TypeBuilder tb = this.push();
        tb.inCode = true;
        tb.global = false;
        return tb;
    }

    protected TypeBuilder pushClass(ParsedClassType type) throws SemanticException {
        if (Report.should_report("visit", 4)) {
            Report.report(4, "TB pushing class " + type + ": " + this.context());
        }
        TypeBuilder tb = this.push();
        tb.type = type;
        tb.inCode = false;
        if (this.importTable() != null && type.isTopLevel()) {
            tb.importTable().addClassImport(type.fullName());
        }
        return tb;
    }

    protected ParsedClassType newClass(Position pos, Flags flags, String name) throws SemanticException {
        Named dup;
        TypeSystem ts = this.typeSystem();
        ParsedClassType ct = ts.createClassType(this.job().source());
        ct.position(pos);
        ct.flags(flags);
        ct.name(name);
        if (this.inCode) {
            ct.kind(ClassType.LOCAL);
            ct.outer(this.currentClass());
            ct.setJob(this.job());
            if (this.currentPackage() != null) {
                ct.package_(this.currentPackage());
            }
            return ct;
        }
        if (this.currentClass() != null) {
            ClassType container;
            boolean allMembers;
            ct.kind(ClassType.MEMBER);
            ct.outer(this.currentClass());
            ct.setJob(this.job());
            this.currentClass().addMemberClass(ct);
            if (this.currentPackage() != null) {
                ct.package_(this.currentPackage());
            }
            boolean bl = allMembers = (container = ct.outer()).isMember() || container.isTopLevel();
            while (container.isMember()) {
                container = container.outer();
                allMembers = allMembers && (container.isMember() || container.isTopLevel());
            }
            if (allMembers) {
                this.typeSystem().systemResolver().addNamed(ct.fullName(), ct);
                String classFileName = this.typeSystem().getTransformedClassName(ct);
                this.typeSystem().systemResolver().install(classFileName, ct);
            }
            return ct;
        }
        ct.kind(ClassType.TOP_LEVEL);
        ct.setJob(this.job());
        if (this.currentPackage() != null) {
            ct.package_(this.currentPackage());
        }
        if ((dup = this.typeSystem().systemResolver().check(ct.fullName())) != null && dup.fullName().equals(ct.fullName())) {
            throw new SemanticException("Duplicate class \"" + ct.fullName() + "\".", pos);
        }
        this.typeSystem().systemResolver().addNamed(ct.fullName(), ct);
        return ct;
    }

    public TypeBuilder pushAnonClass(Position pos) throws SemanticException {
        if (Report.should_report("visit", 4)) {
            Report.report(4, "TB pushing anon class: " + this);
        }
        if (!this.inCode) {
            throw new InternalCompilerError("Can only push an anonymous class within code.");
        }
        TypeSystem ts = this.typeSystem();
        ParsedClassType ct = ts.createClassType(this.job().source());
        ct.kind(ClassType.ANONYMOUS);
        ct.outer(this.currentClass());
        ct.position(pos);
        ct.setJob(this.job());
        if (this.currentPackage() != null) {
            ct.package_(this.currentPackage());
        }
        return this.pushClass(ct);
    }

    public TypeBuilder pushClass(Position pos, Flags flags, String name) throws SemanticException {
        ParsedClassType t = this.newClass(pos, flags, name);
        return this.pushClass(t);
    }

    public ParsedClassType currentClass() {
        return this.type;
    }

    public Package currentPackage() {
        return this.package_;
    }

    public ImportTable importTable() {
        return this.importTable;
    }

    public void setImportTable(ImportTable it) {
        this.importTable = it;
    }

    public String context() {
        return "(TB " + this.type + (this.inCode ? " inCode" : "") + (this.global ? " global" : "") + (this.outer == null ? ")" : " " + this.outer.context() + ")");
    }
}

