/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.Scene;
import soot.SootClass;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;

public class AbstractTrap
implements Trap,
Serializable {
    protected transient SootClass exception;
    protected UnitBox beginUnitBox;
    protected UnitBox endUnitBox;
    protected UnitBox handlerUnitBox;
    protected List unitBoxes;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.exception = Scene.v().getSootClass((String)in.readObject());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.exception.getName());
    }

    protected AbstractTrap(SootClass exception, UnitBox beginUnitBox, UnitBox endUnitBox, UnitBox handlerUnitBox) {
        this.exception = exception;
        this.beginUnitBox = beginUnitBox;
        this.endUnitBox = endUnitBox;
        this.handlerUnitBox = handlerUnitBox;
        this.unitBoxes = new ArrayList();
        this.unitBoxes.add(beginUnitBox);
        this.unitBoxes.add(endUnitBox);
        this.unitBoxes.add(handlerUnitBox);
        this.unitBoxes = Collections.unmodifiableList(this.unitBoxes);
    }

    public Unit getBeginUnit() {
        return this.beginUnitBox.getUnit();
    }

    public Unit getEndUnit() {
        return this.endUnitBox.getUnit();
    }

    public Unit getHandlerUnit() {
        return this.handlerUnitBox.getUnit();
    }

    public UnitBox getHandlerUnitBox() {
        return this.handlerUnitBox;
    }

    public UnitBox getBeginUnitBox() {
        return this.beginUnitBox;
    }

    public UnitBox getEndUnitBox() {
        return this.endUnitBox;
    }

    public List getUnitBoxes() {
        return this.unitBoxes;
    }

    public void clearUnitBoxes() {
        for (UnitBox box : this.getUnitBoxes()) {
            box.setUnit(null);
        }
    }

    public SootClass getException() {
        return this.exception;
    }

    public void setBeginUnit(Unit beginUnit) {
        this.beginUnitBox.setUnit(beginUnit);
    }

    public void setEndUnit(Unit endUnit) {
        this.endUnitBox.setUnit(endUnit);
    }

    public void setHandlerUnit(Unit handlerUnit) {
        this.handlerUnitBox.setUnit(handlerUnit);
    }

    public void setException(SootClass exception) {
        this.exception = exception;
    }

    public Object clone() {
        throw new RuntimeException();
    }
}

