/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.LinkedList;
import soot.AnySubType;
import soot.G;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootResolver;
import soot.Type;
import soot.TypeSwitch;
import soot.UnknownType;
import soot.util.Switch;

public class FutureType
extends RefType {
    private Type paramType;
    protected Type primType;

    public FutureType(Singletons.Global g) {
        this.className = "";
    }

    public static FutureType v() {
        return G.v().soot_FutureType();
    }

    private FutureType(String className, Type type) {
        if (className.startsWith("[")) {
            throw new RuntimeException("Attempt to create RefType whose name starts with [ --> " + className);
        }
        if (className.indexOf("/") >= 0) {
            throw new RuntimeException("Attempt to create RefType containing a / --> " + className);
        }
        if (className.indexOf(";") >= 0) {
            throw new RuntimeException("Attempt to create RefType containing a ; --> " + className);
        }
        this.className = className;
        this.primType = type;
        this.sootClass = Scene.v().getSootClass(className);
    }

    public static FutureType v(String className, Type type) {
        FutureType ret = new FutureType(className, type);
        Scene.v().addRefType(ret);
        return ret;
    }

    public int compareTo(Object o) throws ClassCastException {
        FutureType t = (FutureType)o;
        return this.toString().compareTo(t.toString());
    }

    public static FutureType v(SootClass c, Type type) {
        return FutureType.v(c.getName(), type);
    }

    public Type getFutureBaseType() {
        return this.primType;
    }

    public SootClass getSootClass() {
        if (this.sootClass == null) {
            this.sootClass = SootResolver.v().makeClassRef(this.className);
        }
        return this.sootClass;
    }

    public boolean hasSootClass() {
        return this.sootClass != null;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setSootClass(SootClass sootClass) {
        if (!sootClass.getName().equals("hj.lang.Future")) {
            throw new RuntimeException("The Future type's soot clase is hj.runtime.wsh.Activity " + sootClass);
        }
        this.sootClass = sootClass;
    }

    public boolean equals(Object t) {
        return t instanceof FutureType && this.className.equals(((FutureType)t).className);
    }

    public String toString() {
        return this.className;
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public void apply(Switch sw) {
        ((TypeSwitch)sw).caseRefType(this);
    }

    public Type merge(Type other, Scene cm) {
        if (other.equals(UnknownType.v()) || this.equals(other)) {
            return this;
        }
        if (!(other instanceof RefType)) {
            throw new RuntimeException("illegal type merge: " + this + " and " + other);
        }
        SootClass thisClass = cm.getSootClass(this.className);
        SootClass otherClass = cm.getSootClass(((RefType)other).className);
        SootClass javalangObject = cm.getSootClass("java.lang.Object");
        LinkedList<SootClass> thisHierarchy = new LinkedList<SootClass>();
        LinkedList<SootClass> otherHierarchy = new LinkedList<SootClass>();
        SootClass SootClass2 = thisClass;
        while (true) {
            thisHierarchy.addFirst(SootClass2);
            if (SootClass2 == javalangObject) break;
            SootClass2 = SootClass2.getSuperclass();
        }
        SootClass2 = otherClass;
        while (true) {
            otherHierarchy.addFirst(SootClass2);
            if (SootClass2 == javalangObject) break;
            SootClass2 = SootClass2.getSuperclass();
        }
        SootClass commonClass = null;
        while (!otherHierarchy.isEmpty() && !thisHierarchy.isEmpty() && otherHierarchy.getFirst() == thisHierarchy.getFirst()) {
            commonClass = (SootClass)otherHierarchy.removeFirst();
            thisHierarchy.removeFirst();
        }
        return RefType.v(commonClass.getName());
    }

    public Type getArrayElementType() {
        if (this.className.equals("java.lang.Object") || this.className.equals("java.io.Serializable") || this.className.equals("java.lang.Cloneable")) {
            return RefType.v("java.lang.Object");
        }
        throw new RuntimeException("Attempt to get array base type of a non-array");
    }

    public AnySubType getAnySubType() {
        return this.anySubType;
    }

    public void setAnySubType(AnySubType anySubType) {
        this.anySubType = anySubType;
    }
}

