/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import polyglot.ast.Block;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassLit;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Initializer;
import polyglot.ast.LocalClassDecl;
import polyglot.ast.MethodDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.ProcedureDecl;
import polyglot.ast.SourceFile;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.types.NullableType;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.ParsedClassType;
import polyglot.util.IdentityKey;
import polyglot.visit.NodeVisitor;
import soot.BooleanType;
import soot.G;
import soot.HjToJimple.AnonClassInitMethodSource;
import soot.HjToJimple.InitialResolver;
import soot.HjToJimple.Util;
import soot.Modifier;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.VoidType;
import soot.javaToJimple.AnonLocalClassInfo;
import soot.javaToJimple.AssertClassMethodSource;
import soot.javaToJimple.AssertStmtChecker;
import soot.javaToJimple.ClassLiteralChecker;
import soot.javaToJimple.ClassLiteralMethodSource;
import soot.javaToJimple.InnerClassInfo;
import soot.javaToJimple.LocalUsesChecker;
import soot.javaToJimple.NestedClassListBuilder;
import soot.javaToJimple.PolyglotMethodSource;
import soot.javaToJimple.TypeListBuilder;
import soot.options.Options;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.EnclosingTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.QualifyingTag;
import soot.tagkit.SourceFileTag;
import soot.tagkit.StringConstantValueTag;
import soot.tagkit.SyntheticTag;
import soot.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassResolver {
    private ArrayList<FieldDecl> staticFieldInits;
    private ArrayList<FieldDecl> fieldInits;
    private ArrayList<Block> initializerBlocks;
    private ArrayList<Block> staticInitializerBlocks;
    private final SootClass sootClass;
    private final Collection references;

    protected void addSourceFileTag(SootClass sc) {
        int slashIndex;
        SourceFileTag tag = null;
        if (sc.hasTag("SourceFileTag")) {
            tag = (SourceFileTag)sc.getTag("SourceFileTag");
        } else {
            tag = new SourceFileTag();
            sc.addTag(tag);
        }
        String name = Util.getSourceFileOfClass(sc);
        if (InitialResolver.v().classToSourceMap() != null && InitialResolver.v().classToSourceMap().containsKey(name)) {
            name = InitialResolver.v().classToSourceMap().get(name);
        }
        if ((slashIndex = name.lastIndexOf("/")) != -1) {
            name = name.substring(slashIndex + 1);
        }
        tag.setSourceFile(name);
    }

    private void createClassDecl(ClassDecl cDecl) {
        if (!cDecl.type().isTopLevel()) {
            SootClass outerClass = ((RefType)Util.getSootType((polyglot.types.Type)cDecl.type().outer())).getSootClass();
            if (InitialResolver.v().getInnerClassInfoMap() == null) {
                InitialResolver.v().setInnerClassInfoMap(new HashMap<SootClass, InnerClassInfo>());
            }
            InitialResolver.v().getInnerClassInfoMap().put(this.sootClass, new InnerClassInfo(outerClass, cDecl.name(), 0));
            this.sootClass.setOuterClass(outerClass);
        }
        Flags flags = cDecl.flags();
        this.addModifiers(flags, cDecl);
        if (cDecl.superClass() == null) {
            SootClass superClass = Scene.v().getSootClass("java.lang.Object");
            this.sootClass.setSuperclass(superClass);
        } else {
            this.sootClass.setSuperclass(((RefType)Util.getSootType(cDecl.superClass().type())).getSootClass());
            ClassType superClassType = null;
            superClassType = cDecl.superClass().type() instanceof NullableType ? (ClassType)((NullableType)cDecl.superClass().type()).base() : (ClassType)cDecl.superClass().type();
            if (superClassType.isNested()) {
                ClassType superType = (ClassType)cDecl.superClass().type();
                Util.addInnerClassTag(this.sootClass, this.sootClass.getName(), ((RefType)Util.getSootType((polyglot.types.Type)superType.outer())).toString(), superType.name(), Util.getModifier(superType.flags()));
            }
        }
        for (TypeNode next : cDecl.interfaces()) {
            this.sootClass.addInterface(((RefType)Util.getSootType(next.type())).getSootClass());
        }
        this.findReferences((Node)cDecl);
        this.createClassBody(cDecl.body());
        this.handleFieldInits();
        if (this.staticFieldInits != null || this.staticInitializerBlocks != null) {
            SootMethod clinitMethod;
            if (!this.sootClass.declaresMethod("<clinit>", Collections.EMPTY_LIST, VoidType.v())) {
                clinitMethod = new SootMethod("<clinit>", Collections.EMPTY_LIST, VoidType.v(), 8, new ArrayList<SootClass>());
                this.sootClass.addMethod(clinitMethod);
                PolyglotMethodSource mSource = new PolyglotMethodSource();
                mSource.setJBB(InitialResolver.v().getJBBFactory().createJimpleBodyBuilder());
                clinitMethod.setSource(mSource);
            } else {
                clinitMethod = this.sootClass.getMethod("<clinit>", Collections.EMPTY_LIST, VoidType.v());
            }
            ((PolyglotMethodSource)clinitMethod.getSource()).setStaticFieldInits(this.staticFieldInits);
            ((PolyglotMethodSource)clinitMethod.getSource()).setStaticInitializerBlocks(this.staticInitializerBlocks);
        }
        if (cDecl.type().isLocal()) {
            AnonLocalClassInfo info = InitialResolver.v().finalLocalInfo().get(new IdentityKey((Object)cDecl.type()));
            ArrayList<SootField> finalsList = this.addFinalLocals(cDecl.body(), info.finalLocalsAvail(), (ClassType)cDecl.type(), info);
            for (SootMethod meth : this.sootClass.getMethods()) {
                if (!meth.getName().equals("<init>")) continue;
                ((PolyglotMethodSource)meth.getSource()).setFinalsList(finalsList);
            }
            if (!info.inStaticMethod()) {
                ClassType outerType = cDecl.type().outer();
                this.addOuterClassThisRefToInit((polyglot.types.Type)outerType);
                this.addOuterClassThisRefField((polyglot.types.Type)outerType);
            }
        } else if (cDecl.type().isNested() && !cDecl.flags().isStatic()) {
            ClassType outerType = cDecl.type().outer();
            this.addOuterClassThisRefToInit((polyglot.types.Type)outerType);
            this.addOuterClassThisRefField((polyglot.types.Type)outerType);
        }
        Util.addLnPosTags(this.sootClass, cDecl.position());
    }

    private void findReferences(Node node) {
        TypeListBuilder typeListBuilder = new TypeListBuilder();
        node.visit((NodeVisitor)typeListBuilder);
        for (polyglot.types.Type type : typeListBuilder.getList()) {
            ClassType classType;
            Type sootClassType;
            String icName;
            if (type.isPrimitive() || !type.isClass() || (icName = (sootClassType = Util.getSootType((polyglot.types.Type)(classType = (ClassType)type))).toString()).substring(icName.indexOf("$") + 1, icName.length()).startsWith("null")) continue;
            this.references.add(sootClassType);
        }
    }

    private void createClassBody(ClassBody classBody) {
        this.staticFieldInits = null;
        this.fieldInits = null;
        this.initializerBlocks = null;
        this.staticInitializerBlocks = null;
        for (Object next : classBody.members()) {
            if (next instanceof MethodDecl) {
                this.createMethodDecl((MethodDecl)next);
                continue;
            }
            if (next instanceof FieldDecl) {
                this.createFieldDecl((FieldDecl)next);
                continue;
            }
            if (next instanceof ConstructorDecl) {
                this.createConstructorDecl((ConstructorDecl)next);
                continue;
            }
            if (next instanceof ClassDecl) {
                Util.addInnerClassTag(this.sootClass, Util.getSootType((polyglot.types.Type)((ClassDecl)next).type()).toString(), this.sootClass.getName(), ((ClassDecl)next).name().toString(), Util.getModifier(((ClassDecl)next).flags()));
                continue;
            }
            if (next instanceof Initializer) {
                this.createInitializer((Initializer)next);
                continue;
            }
            if (!Options.v().verbose()) continue;
            G.v().out.println("Class Body Member not implemented for type " + next.getClass().getName());
        }
        this.handleInnerClassTags(classBody);
        this.handleClassLiteral(classBody);
        this.handleAssert(classBody);
    }

    private void addOuterClassThisRefField(polyglot.types.Type outerType) {
        Type outerSootType = Util.getSootType(outerType);
        SootField field = new SootField("this$0", outerSootType, 18);
        this.sootClass.addField(field);
        field.addTag(new SyntheticTag());
    }

    private void addOuterClassThisRefToInit(polyglot.types.Type outerType) {
        Type outerSootType = Util.getSootType(outerType);
        for (SootMethod meth : this.sootClass.getMethods()) {
            if (!meth.getName().equals("<init>")) continue;
            ArrayList<Type> newParams = new ArrayList<Type>();
            newParams.add(outerSootType);
            newParams.addAll(meth.getParameterTypes());
            meth.setParameterTypes(newParams);
            meth.addTag(new EnclosingTag());
            if (InitialResolver.v().getHasOuterRefInInit() == null) {
                InitialResolver.v().setHasOuterRefInInit(new ArrayList());
            }
            InitialResolver.v().getHasOuterRefInInit().add(meth.getDeclaringClass().getType());
        }
    }

    private void addFinals(LocalInstance li, ArrayList<SootField> finalFields) {
        for (SootMethod meth : this.sootClass.getMethods()) {
            if (!meth.getName().equals("<init>")) continue;
            ArrayList<Type> newParams = new ArrayList<Type>();
            newParams.addAll(meth.getParameterTypes());
            newParams.add(Util.getSootType(li.type()));
            meth.setParameterTypes(newParams);
        }
        SootField sf = new SootField("val$" + li.name(), Util.getSootType(li.type()), 18);
        this.sootClass.addField(sf);
        finalFields.add(sf);
        sf.addTag(new SyntheticTag());
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<SootField> addFinalLocals(ClassBody cBody, ArrayList<IdentityKey> finalLocalsAvail, ClassType nodeKeyType, AnonLocalClassInfo info) {
        void var10_12;
        ArrayList<SootField> finalFields = new ArrayList<SootField>();
        LocalUsesChecker luc = new LocalUsesChecker();
        cBody.visit((NodeVisitor)luc);
        ArrayList<IdentityKey> localsUsed = new ArrayList<IdentityKey>();
        Iterator<IdentityKey> fieldsNeededIt = finalLocalsAvail.iterator();
        while (fieldsNeededIt.hasNext()) {
            LocalInstance li = (LocalInstance)fieldsNeededIt.next().object();
            if (luc.getLocalDecls().contains(new IdentityKey((Object)li))) continue;
            localsUsed.add(new IdentityKey((Object)li));
            this.addFinals(li, finalFields);
        }
        for (New new_ : luc.getNews()) {
            ClassType tempNewType = (ClassType)new_.objectType().type();
            if (!InitialResolver.v().finalLocalInfo().containsKey(new IdentityKey((Object)tempNewType))) continue;
            AnonLocalClassInfo lInfo = InitialResolver.v().finalLocalInfo().get(new IdentityKey((Object)tempNewType));
            Iterator<IdentityKey> it = lInfo.finalLocalsAvail().iterator();
            while (it.hasNext()) {
                LocalInstance li2 = (LocalInstance)it.next().object();
                if (this.sootClass.declaresField("val$" + li2.name(), Util.getSootType(li2.type())) || luc.getLocalDecls().contains(new IdentityKey((Object)li2))) continue;
                this.addFinals(li2, finalFields);
                localsUsed.add(new IdentityKey((Object)li2));
            }
        }
        ClassType classType = (ClassType)nodeKeyType.superType();
        while (!Util.getSootType((polyglot.types.Type)var10_12).equals(Scene.v().getSootClass("java.lang.Object").getType())) {
            if (InitialResolver.v().finalLocalInfo().containsKey(new IdentityKey((Object)var10_12))) {
                AnonLocalClassInfo lInfo = InitialResolver.v().finalLocalInfo().get(new IdentityKey((Object)var10_12));
                Iterator<IdentityKey> it = lInfo.finalLocalsAvail().iterator();
                while (it.hasNext()) {
                    LocalInstance li2 = (LocalInstance)it.next().object();
                    if (this.sootClass.declaresField("val$" + li2.name(), Util.getSootType(li2.type())) || luc.getLocalDecls().contains(new IdentityKey((Object)li2))) continue;
                    this.addFinals(li2, finalFields);
                    localsUsed.add(new IdentityKey((Object)li2));
                }
            }
            ClassType classType2 = (ClassType)var10_12.superType();
        }
        info.finalLocalsUsed(localsUsed);
        InitialResolver.v().finalLocalInfo().put(new IdentityKey((Object)nodeKeyType), info);
        return finalFields;
    }

    private void createAnonClassDecl(New aNew) {
        SootMethod method;
        SootClass outerClass = ((RefType)Util.getSootType((polyglot.types.Type)aNew.anonType().outer())).getSootClass();
        if (InitialResolver.v().getInnerClassInfoMap() == null) {
            InitialResolver.v().setInnerClassInfoMap(new HashMap<SootClass, InnerClassInfo>());
        }
        InitialResolver.v().getInnerClassInfoMap().put(this.sootClass, new InnerClassInfo(outerClass, "0", 3));
        this.sootClass.setOuterClass(outerClass);
        SootClass typeClass = ((RefType)Util.getSootType(aNew.objectType().type())).getSootClass();
        if (((ClassType)aNew.objectType().type()).flags().isInterface()) {
            this.sootClass.addInterface(typeClass);
            this.sootClass.setSuperclass(Scene.v().getSootClass("java.lang.Object"));
        } else {
            this.sootClass.setSuperclass(typeClass);
            if (((ClassType)aNew.objectType().type()).isNested()) {
                ClassType superType = (ClassType)aNew.objectType().type();
                Util.addInnerClassTag(this.sootClass, typeClass.getName(), ((RefType)Util.getSootType((polyglot.types.Type)superType.outer())).toString(), superType.name(), Util.getModifier(superType.flags()));
            }
        }
        ArrayList<Type> params = new ArrayList<Type>();
        if (((ClassType)aNew.objectType().type()).flags().isInterface()) {
            method = new SootMethod("<init>", params, VoidType.v());
        } else {
            if (!aNew.arguments().isEmpty()) {
                ConstructorInstance ci = InitialResolver.v().getConstructorForAnon(aNew);
                for (polyglot.types.Type pType : ci.formalTypes()) {
                    params.add(Util.getSootType(pType));
                }
            }
            method = new SootMethod("<init>", params, VoidType.v());
        }
        AnonClassInitMethodSource src = new AnonClassInitMethodSource();
        method.setSource(src);
        this.sootClass.addMethod(method);
        AnonLocalClassInfo info = InitialResolver.v().finalLocalInfo().get(new IdentityKey((Object)aNew.anonType()));
        if (aNew.qualifier() != null) {
            this.addQualifierRefToInit(aNew.qualifier().type());
            src.hasQualifier(true);
        }
        if (info != null && !info.inStaticMethod() && !InitialResolver.v().isAnonInCCall((ClassType)aNew.anonType())) {
            this.addOuterClassThisRefToInit((polyglot.types.Type)aNew.anonType().outer());
            this.addOuterClassThisRefField((polyglot.types.Type)aNew.anonType().outer());
            src.thisOuterType(Util.getSootType((polyglot.types.Type)aNew.anonType().outer()));
            src.hasOuterRef(true);
        }
        src.polyglotType((ClassType)aNew.anonType().superType());
        src.anonType((ClassType)aNew.anonType());
        src.inStaticMethod(info.inStaticMethod());
        if (info != null) {
            src.setFinalsList(this.addFinalLocals(aNew.body(), info.finalLocalsAvail(), (ClassType)aNew.anonType(), info));
        }
        src.outerClassType(Util.getSootType((polyglot.types.Type)aNew.anonType().outer()));
        if (((ClassType)aNew.objectType().type()).isNested()) {
            src.superOuterType(Util.getSootType((polyglot.types.Type)((ClassType)aNew.objectType().type()).outer()));
            src.isSubType(Util.isSubType(aNew.anonType().outer(), ((ClassType)aNew.objectType().type()).outer()));
        }
        Util.addLnPosTags(this.sootClass, aNew.position().line(), aNew.body().position().endLine(), aNew.position().column(), aNew.body().position().endColumn());
    }

    public int getModifiers(Flags flags) {
        return Util.getModifier(flags);
    }

    private void addModifiers(Flags flags, ClassDecl cDecl) {
        int modifiers = 0;
        if (cDecl.type().isNested()) {
            if (flags.isPublic() || flags.isProtected() || flags.isPrivate()) {
                modifiers = 1;
            }
            if (flags.isInterface()) {
                modifiers |= 0x200;
            }
            if (flags.isAbstract()) {
                modifiers |= 0x400;
            }
            if (cDecl.type().outer().flags().isInterface()) {
                modifiers |= 1;
            }
        } else {
            modifiers = this.getModifiers(flags);
        }
        this.sootClass.setModifiers(modifiers);
    }

    private SootClass getSpecialInterfaceAnonClass(SootClass addToClass) {
        if (InitialResolver.v().specialAnonMap() != null && InitialResolver.v().specialAnonMap().containsKey(addToClass)) {
            return InitialResolver.v().specialAnonMap().get(addToClass);
        }
        String specialClassName = addToClass.getName() + "$" + InitialResolver.v().getNextAnonNum();
        SootClass specialClass = new SootClass(specialClassName);
        Scene.v().addClass(specialClass);
        specialClass.setApplicationClass();
        specialClass.addTag(new SyntheticTag());
        specialClass.setSuperclass(Scene.v().getSootClass("java.lang.Object"));
        Util.addInnerClassTag(addToClass, specialClass.getName(), addToClass.getName(), null, 8);
        Util.addInnerClassTag(specialClass, specialClass.getName(), addToClass.getName(), null, 8);
        InitialResolver.v().addNameToAST(specialClassName);
        this.references.add(specialClassName);
        if (Options.v().hjVerbose()) {
            G.v().out.println("CLASS RESOLVER ADD 1: " + specialClassName);
        }
        if (InitialResolver.v().specialAnonMap() == null) {
            InitialResolver.v().setSpecialAnonMap(new HashMap<SootClass, SootClass>());
        }
        InitialResolver.v().specialAnonMap().put(addToClass, specialClass);
        return specialClass;
    }

    private void handleAssert(ClassBody cBody) {
        AssertStmtChecker asc = new AssertStmtChecker();
        cBody.visit((NodeVisitor)asc);
        if (!asc.isHasAssert()) {
            return;
        }
        String fieldName = "$assertionsDisabled";
        Type fieldType = BooleanType.v();
        if (!this.sootClass.declaresField(fieldName, fieldType)) {
            SootField assertionsDisabledField = new SootField(fieldName, fieldType, 24);
            this.sootClass.addField(assertionsDisabledField);
            assertionsDisabledField.addTag(new SyntheticTag());
        }
        SootClass addToClass = this.sootClass;
        while (InitialResolver.v().getInnerClassInfoMap() != null && InitialResolver.v().getInnerClassInfoMap().containsKey(addToClass)) {
            addToClass = InitialResolver.v().getInnerClassInfoMap().get(addToClass).getOuterClass();
        }
        fieldName = "class$" + StringTools.replaceAll(addToClass.getName(), ".", "$");
        if (InitialResolver.v().getInterfacesList() != null && InitialResolver.v().getInterfacesList().contains(addToClass.getName())) {
            addToClass = this.getSpecialInterfaceAnonClass(addToClass);
        }
        if (!addToClass.declaresField(fieldName, fieldType = RefType.v("java.lang.Class"))) {
            SootField classField = new SootField(fieldName, fieldType, 8);
            addToClass.addField(classField);
            classField.addTag(new SyntheticTag());
        }
        String methodName = "class$";
        Type methodRetType = RefType.v("java.lang.Class");
        ArrayList<RefType> paramTypes = new ArrayList<RefType>();
        paramTypes.add(RefType.v("java.lang.String"));
        SootMethod sootMethod = new SootMethod(methodName, paramTypes, methodRetType, 8);
        AssertClassMethodSource assertMSrc = new AssertClassMethodSource();
        sootMethod.setSource(assertMSrc);
        if (!addToClass.declaresMethod(methodName, paramTypes, methodRetType)) {
            addToClass.addMethod(sootMethod);
            sootMethod.addTag(new SyntheticTag());
        }
        methodName = "<clinit>";
        methodRetType = VoidType.v();
        paramTypes = new ArrayList();
        sootMethod = new SootMethod(methodName, paramTypes, methodRetType, 8);
        PolyglotMethodSource mSrc = new PolyglotMethodSource();
        mSrc.setJBB(InitialResolver.v().getJBBFactory().createJimpleBodyBuilder());
        mSrc.hasAssert(true);
        sootMethod.setSource(mSrc);
        if (!this.sootClass.declaresMethod(methodName, paramTypes, methodRetType)) {
            this.sootClass.addMethod(sootMethod);
        } else {
            ((PolyglotMethodSource)this.sootClass.getMethod(methodName, paramTypes, methodRetType).getSource()).hasAssert(true);
        }
    }

    private void createConstructorDecl(ConstructorDecl constructor) {
        String name = "<init>";
        ArrayList parameters = this.createParameters((ProcedureDecl)constructor);
        ArrayList<SootClass> exceptions = this.createExceptions((ProcedureDecl)constructor);
        SootMethod sootMethod = this.createSootConstructor(name, constructor.flags(), parameters, exceptions);
        this.finishProcedure((ProcedureDecl)constructor, sootMethod);
    }

    private void createMethodDecl(MethodDecl method) {
        String name = this.createName((ProcedureDecl)method);
        ArrayList parameters = this.createParameters((ProcedureDecl)method);
        ArrayList<SootClass> exceptions = this.createExceptions((ProcedureDecl)method);
        SootMethod sootMethod = this.createSootMethod(name, method.flags(), method.returnType().type(), parameters, exceptions);
        this.finishProcedure((ProcedureDecl)method, sootMethod);
    }

    private void finishProcedure(ProcedureDecl procedure, SootMethod sootMethod) {
        this.addProcedureToClass(sootMethod);
        if (procedure.position() != null) {
            Util.addLnPosTags(sootMethod, procedure.position());
        }
        PolyglotMethodSource mSrc = new PolyglotMethodSource(procedure.body(), procedure.formals());
        mSrc.setJBB(InitialResolver.v().getJBBFactory().createJimpleBodyBuilder());
        sootMethod.setSource(mSrc);
    }

    private void handleFieldInits() {
        if (this.fieldInits != null || this.initializerBlocks != null) {
            for (SootMethod next : this.sootClass.getMethods()) {
                if (!next.getName().equals("<init>")) continue;
                PolyglotMethodSource src = (PolyglotMethodSource)next.getSource();
                src.setInitializerBlocks(this.initializerBlocks);
                src.setFieldInits(this.fieldInits);
            }
        }
    }

    private void handleClassLiteral(ClassBody cBody) {
        ClassLiteralChecker classLitChecker = new ClassLiteralChecker();
        cBody.visit((NodeVisitor)classLitChecker);
        ArrayList<Node> classLitList = classLitChecker.getList();
        if (!classLitList.isEmpty()) {
            SootClass addToClass = this.sootClass;
            if (addToClass.isInterface()) {
                addToClass = this.getSpecialInterfaceAnonClass(addToClass);
            }
            String methodName = "class$";
            RefType methodRetType = RefType.v("java.lang.Class");
            ArrayList<RefType> paramTypes = new ArrayList<RefType>();
            paramTypes.add(RefType.v("java.lang.String"));
            SootMethod sootMethod = new SootMethod(methodName, paramTypes, methodRetType, 8);
            ClassLiteralMethodSource mSrc = new ClassLiteralMethodSource();
            sootMethod.setSource(mSrc);
            if (!addToClass.declaresMethod(methodName, paramTypes, methodRetType)) {
                addToClass.addMethod(sootMethod);
                sootMethod.addTag(new SyntheticTag());
            }
            for (ClassLit classLit : classLitList) {
                String fieldName = Util.getFieldNameForClassLit(classLit.typeNode().type());
                RefType fieldType = RefType.v("java.lang.Class");
                SootField sootField = new SootField(fieldName, fieldType, 8);
                if (addToClass.declaresField(fieldName, fieldType)) continue;
                addToClass.addField(sootField);
                sootField.addTag(new SyntheticTag());
            }
        }
    }

    protected void createSource(SourceFile source) {
        SourceFileTag t;
        if (this.sootClass.hasTag("SourceFileTag")) {
            t = (SourceFileTag)this.sootClass.getTag("SourceFileTag");
            t.setAbsolutePath(source.source().path());
        } else {
            t = new SourceFileTag();
            t.setAbsolutePath(source.source().path());
            this.sootClass.addTag(t);
        }
        String simpleName = this.sootClass.getName();
        Iterator declsIt = source.decls().iterator();
        boolean found = false;
        while (declsIt.hasNext()) {
            ParsedClassType nextType;
            Object next = declsIt.next();
            if (!(next instanceof ClassDecl) || !Util.getSootType((polyglot.types.Type)(nextType = ((ClassDecl)next).type())).equals(this.sootClass.getType())) continue;
            this.createClassDecl((ClassDecl)next);
            found = true;
        }
        if (!found) {
            NestedClassListBuilder nestedClassBuilder = new NestedClassListBuilder();
            source.visit((NodeVisitor)nestedClassBuilder);
            Iterator<Node> nestedDeclsIt = nestedClassBuilder.getClassDeclsList().iterator();
            while (nestedDeclsIt.hasNext() && !found) {
                ClassDecl nextDecl = (ClassDecl)nestedDeclsIt.next();
                ParsedClassType type = nextDecl.type();
                if (Options.v().hjVerbose()) {
                    G.v().out.println("CHASING NEST CLASS: " + type);
                }
                if (type.isLocal() && !type.isAnonymous()) {
                    if (!InitialResolver.v().getLocalClassMap().containsVal(simpleName)) continue;
                    this.createClassDecl(((LocalClassDecl)InitialResolver.v().getLocalClassMap().getKey(simpleName)).decl());
                    found = true;
                    continue;
                }
                if (!Util.getSootType((polyglot.types.Type)type).equals(this.sootClass.getType())) continue;
                this.createClassDecl(nextDecl);
                found = true;
            }
            if (!found && InitialResolver.v().getAnonClassMap() != null && InitialResolver.v().getAnonClassMap().containsVal(simpleName)) {
                New aNew = (New)InitialResolver.v().getAnonClassMap().getKey(simpleName);
                this.createAnonClassDecl(aNew);
                this.findReferences((Node)aNew.body());
                this.createClassBody(aNew.body());
                this.handleFieldInits();
            }
        }
    }

    private void handleInnerClassTags(ClassBody classBody) {
        if (InitialResolver.v().getInnerClassInfoMap() != null && InitialResolver.v().getInnerClassInfoMap().containsKey(this.sootClass)) {
            InnerClassInfo tag = InitialResolver.v().getInnerClassInfoMap().get(this.sootClass);
            Util.addInnerClassTag(this.sootClass, this.sootClass.getName(), tag.getInnerType() == 3 ? null : tag.getOuterClass().getName(), tag.getInnerType() == 3 ? null : tag.getSimpleName(), Modifier.isInterface(tag.getOuterClass().getModifiers()) ? 9 : this.sootClass.getModifiers());
            SootClass outerClass = tag.getOuterClass();
            while (InitialResolver.v().getInnerClassInfoMap().containsKey(outerClass)) {
                InnerClassInfo tag2 = InitialResolver.v().getInnerClassInfoMap().get(outerClass);
                Util.addInnerClassTag(this.sootClass, outerClass.getName(), tag2.getInnerType() == 3 ? null : tag2.getOuterClass().getName(), tag2.getInnerType() == 3 ? null : tag2.getSimpleName(), tag2.getInnerType() == 3 && Modifier.isInterface(tag2.getOuterClass().getModifiers()) ? 9 : outerClass.getModifiers());
                outerClass = tag2.getOuterClass();
            }
        }
    }

    private void addQualifierRefToInit(polyglot.types.Type type) {
        Type sootType = Util.getSootType(type);
        for (SootMethod meth : this.sootClass.getMethods()) {
            if (!meth.getName().equals("<init>")) continue;
            ArrayList<Type> newParams = new ArrayList<Type>();
            newParams.add(sootType);
            newParams.addAll(meth.getParameterTypes());
            meth.setParameterTypes(newParams);
            meth.addTag(new QualifyingTag());
        }
    }

    private void addProcedureToClass(SootMethod method) {
        this.sootClass.addMethod(method);
    }

    private void addConstValTag(FieldDecl field, SootField sootField) {
        if (field.fieldInstance().constantValue() instanceof Integer) {
            sootField.addTag(new IntegerConstantValueTag((Integer)field.fieldInstance().constantValue()));
        } else if (field.fieldInstance().constantValue() instanceof Character) {
            sootField.addTag(new IntegerConstantValueTag(((Character)field.fieldInstance().constantValue()).charValue()));
        } else if (field.fieldInstance().constantValue() instanceof Short) {
            sootField.addTag(new IntegerConstantValueTag(((Short)field.fieldInstance().constantValue()).shortValue()));
        } else if (field.fieldInstance().constantValue() instanceof Byte) {
            sootField.addTag(new IntegerConstantValueTag(((Byte)field.fieldInstance().constantValue()).byteValue()));
        } else if (field.fieldInstance().constantValue() instanceof Boolean) {
            boolean b = (Boolean)field.fieldInstance().constantValue();
            sootField.addTag(new IntegerConstantValueTag(b ? 1 : 0));
        } else if (field.fieldInstance().constantValue() instanceof Long) {
            sootField.addTag(new LongConstantValueTag((Long)field.fieldInstance().constantValue()));
        } else if (field.fieldInstance().constantValue() instanceof Double) {
            sootField.addTag(new DoubleConstantValueTag((long)((Double)field.fieldInstance().constantValue()).doubleValue()));
            DoubleConstantValueTag doubleConstantValueTag = (DoubleConstantValueTag)sootField.getTag("DoubleConstantValueTag");
        } else if (field.fieldInstance().constantValue() instanceof Float) {
            sootField.addTag(new FloatConstantValueTag(((Float)field.fieldInstance().constantValue()).floatValue()));
        } else if (field.fieldInstance().constantValue() instanceof String) {
            sootField.addTag(new StringConstantValueTag((String)field.fieldInstance().constantValue()));
        } else {
            throw new RuntimeException("Expecting static final field to have a constant value! For field: " + field + " of type: " + field.fieldInstance().constantValue().getClass());
        }
    }

    private void createFieldDecl(FieldDecl field) {
        int modifiers = Util.getModifier(field.fieldInstance().flags());
        String name = field.fieldInstance().name();
        Type sootType = Util.getSootType(field.fieldInstance().type());
        SootField sootField = new SootField(name, sootType, modifiers);
        this.sootClass.addField(sootField);
        if (field.fieldInstance().flags().isStatic()) {
            if (field.init() != null) {
                if (field.flags().isFinal() && (field.type().type().isPrimitive() || field.type().type().toString().equals("java.lang.String")) && field.fieldInstance().isConstant()) {
                    this.addConstValTag(field, sootField);
                } else {
                    if (this.staticFieldInits == null) {
                        this.staticFieldInits = new ArrayList();
                    }
                    this.staticFieldInits.add(field);
                }
            }
        } else if (field.init() != null) {
            if (this.fieldInits == null) {
                this.fieldInits = new ArrayList();
            }
            this.fieldInits.add(field);
        }
        Util.addLnPosTags(sootField, field.position());
    }

    public ClassResolver(SootClass sootClass, Set<Type> set) {
        this.sootClass = sootClass;
        this.references = set;
    }

    private String createName(ProcedureDecl procedure) {
        return procedure.name();
    }

    private ArrayList createParameters(ProcedureDecl procedure) {
        ArrayList<Type> parameters = new ArrayList<Type>();
        for (Formal next : procedure.formals()) {
            parameters.add(Util.getSootType(next.type().type()));
        }
        return parameters;
    }

    private ArrayList<SootClass> createExceptions(ProcedureDecl procedure) {
        ArrayList<SootClass> exceptions = new ArrayList<SootClass>();
        Iterator throwsIt = procedure.throwTypes().iterator();
        while (throwsIt.hasNext()) {
            polyglot.types.Type throwType = ((TypeNode)throwsIt.next()).type();
            exceptions.add(((RefType)Util.getSootType(throwType)).getSootClass());
        }
        return exceptions;
    }

    private SootMethod createSootMethod(String name, Flags flags, polyglot.types.Type returnType, ArrayList parameters, ArrayList<SootClass> exceptions) {
        int modifier = Util.getModifier(flags);
        Type sootReturnType = Util.getSootType(returnType);
        SootMethod method = new SootMethod(name, parameters, sootReturnType, modifier, exceptions);
        return method;
    }

    private void createInitializer(Initializer initializer) {
        if (initializer.flags().isStatic()) {
            if (this.staticInitializerBlocks == null) {
                this.staticInitializerBlocks = new ArrayList();
            }
            this.staticInitializerBlocks.add(initializer.body());
        } else {
            if (this.initializerBlocks == null) {
                this.initializerBlocks = new ArrayList();
            }
            this.initializerBlocks.add(initializer.body());
        }
    }

    private SootMethod createSootConstructor(String name, Flags flags, ArrayList parameters, ArrayList<SootClass> exceptions) {
        int modifier = Util.getModifier(flags);
        SootMethod method = new SootMethod(name, parameters, VoidType.v(), modifier, exceptions);
        return method;
    }
}

