/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.DoubleType;
import soot.FloatType;
import soot.HjToJimple.LocalGenerator;
import soot.HjToJimple.jimple.ActivityClassBuilder;
import soot.HjToJimple.jimple.AsyncRegionExpr;
import soot.HjToJimple.jimple.HabAttrBox;
import soot.HjToJimple.jimple.HjDistHere;
import soot.HjToJimple.jimple.HjOperator;
import soot.HjToJimple.jimple.HjWSTool;
import soot.HjToJimple.jimple.NopRegionExpr;
import soot.HjToJimple.jimple.Region1TStmt;
import soot.HjToJimple.jimple.RegionStmt;
import soot.HjToJimple.jimple.factory.HjStmtFactory;
import soot.HjToJimple.util.Place;
import soot.HjToJimple.util.RSTNode;
import soot.HjToJimple.util.RSTNode_c;
import soot.IntType;
import soot.IntegerType;
import soot.Local;
import soot.LongType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.ConditionExpr;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NopStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.internal.JimpleLocal;
import soot.util.Chain;
import soot.util.HashChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HabRTClassBuilder
extends ActivityClassBuilder {
    public SootClass javaLangObject = Scene.v().getSootClass("java.lang.Object");
    public SootClass javaLangInteger = Scene.v().getSootClass("java.lang.Integer");
    public SootClass javaLangByte = Scene.v().getSootClass("java.lang.Byte");
    public SootClass javaLangShort = Scene.v().getSootClass("java.lang.Short");
    public SootClass javaLangLong = Scene.v().getSootClass("java.lang.Long");
    public SootClass javaLangFloat = Scene.v().getSootClass("java.lang.Float");
    public SootClass javaLangDouble = Scene.v().getSootClass("java.lang.Double");
    public SootClass javaLangBoolean = Scene.v().getSootClass("java.lang.Boolean");
    public SootMethod integerIntValue = this.javaLangInteger.getMethodByName("intValue");
    public SootMethod integerValueOf = this.javaLangInteger.getMethod("java.lang.Integer valueOf(int)");
    public SootMethod byteValueOf = this.javaLangByte.getMethod("java.lang.Byte valueOf(byte)");
    public SootMethod shortValueOf = this.javaLangShort.getMethod("java.lang.Short valueOf(short)");
    public SootMethod longValueOf = this.javaLangLong.getMethod("java.lang.Long valueOf(long)");
    public SootMethod floatValueOf = this.javaLangFloat.getMethod("java.lang.Float valueOf(float)");
    public SootMethod doubleValueOf = this.javaLangDouble.getMethod("java.lang.Double valueOf(double)");
    public SootMethod booleanValueOf = this.javaLangBoolean.getMethod("java.lang.Boolean valueOf(boolean)");
    public SootClass hjLangRuntime = Scene.v().getSootClass("hj.lang.Runtime");
    public SootMethod hjRuntimeAsPlace;
    public SootMethod hjRuntimeHere;
    public SootClass habHFWorker = Scene.v().getSootClass("hj.runtime.wst.adaptive.Worker");
    public SootClass habHFFrame;
    public SootClass habHFPlace;
    public SootClass habHFClosure = Scene.v().getSootClass("hj.runtime.wst.adaptive.Closure");
    public SootClass habHFFinishTreeNode = Scene.v().getSootClass("hj.runtime.wst.adaptive.FinishTreeNode");
    public SootClass habHFRuntime = Scene.v().getSootClass("hj.runtime.wst.adaptive.Runtime");
    public SootClass habHFBfAsyncFrame;
    public SootClass habHFDelayedAsyncFrame;
    public SootClass habHFSpawnFrameStolenException;
    public SootMethod habHFWorkerStartFinish;
    public SootMethod habHFWorkerStopFinishSlow;
    public SootMethod habHFWorkerStopFinishFast;
    public SootMethod habHFWorkerGetClosure;
    public SootMethod habHFWorkerGetCurrentFinishScope;
    public SootMethod habHFWorkerBeginMethod;
    public SootMethod habHFWorkerEndMethodSlow;
    public SootMethod habHFWorkerEndMethodSlowObject;
    public SootMethod habHFWorkerEndMethodFast;
    public SootMethod habHFWorkerPushBfAsync;
    public SootMethod habHFWorkerPushDelayedAsync;
    public SootMethod habHFRuntimeStartWorkers;
    public SootMethod habHFFrameSetFinishScope;
    public SootMethod habHFClosureGetCurrentFinishScope;
    public SootField habHFFramePC;
    private static HabRTClassBuilder habClassBuilder = null;
    protected static HashMap<String, SootMethod> methodNameMap = new HashMap();
    private static int localClassID = 0;
    protected HjWSTool wsTool;

    public HabRTClassBuilder() {
        this.habHFFrame = Scene.v().getSootClass("hj.runtime.wst.adaptive.ActivationFrame");
        this.habHFBfAsyncFrame = Scene.v().getSootClass("hj.runtime.wst.adaptive.BfAsyncFrame");
        this.habHFDelayedAsyncFrame = Scene.v().getSootClass("hj.runtime.wst.adaptive.DelayedAsync");
        this.habHFSpawnFrameStolenException = Scene.v().getSootClass("hj.runtime.wst.adaptive.WorkerBlockedException");
        this.habHFWorkerStartFinish = this.habHFWorker.getMethodByName("startFinish");
        this.habHFWorkerStopFinishSlow = this.habHFWorker.getMethodByName("stopFinishSlow");
        this.habHFWorkerStopFinishFast = this.habHFWorker.getMethodByName("stopFinishFast");
        this.habHFWorkerGetCurrentFinishScope = this.habHFWorker.getMethodByName("getCurrentFinishScope");
        this.habHFWorkerGetClosure = this.habHFWorker.getMethodByName("getClosure");
        this.habHFRuntimeStartWorkers = this.habHFRuntime.getMethodByName("startWorkers");
        this.habHFClosureGetCurrentFinishScope = this.habHFClosure.getMethodByName("getFinishScope");
        this.habHFWorkerBeginMethod = this.habHFWorker.getMethodByName("beginMethod");
        this.habHFWorkerEndMethodSlow = this.habHFWorker.getMethod("void endMethodSlow()");
        this.habHFWorkerEndMethodSlowObject = this.habHFWorker.getMethod("void endMethodSlow(java.lang.Object)");
        this.habHFWorkerEndMethodFast = this.habHFWorker.getMethodByName("endMethodFast");
        List<RefType> typeList = Collections.singletonList(this.habHFBfAsyncFrame.getType());
        this.habHFWorkerPushBfAsync = this.habHFWorker.getMethod("pushBfAsync", typeList, VoidType.v());
        typeList = Collections.singletonList(this.habHFBfAsyncFrame.getType());
        this.habHFFramePC = this.habHFFrame.getFieldByName("pc");
    }

    public static HabRTClassBuilder v() {
        if (habClassBuilder == null) {
            habClassBuilder = new HabRTClassBuilder();
        }
        return habClassBuilder;
    }

    public void addContMethod(SootMethod method) {
        methodNameMap.put(method.toString(), method);
    }

    public void extractAsync(SootMethod method, SootMethod origMethod, RSTNode rstNode, Map contMethodMap, int classID) {
        Body body;
        methodNameMap.put(origMethod.toString(), origMethod);
        SootClass habFrameClass = null;
        SootMethod execMethod = null;
        if (rstNode.isAsyncNode()) {
            body = method.retrieveActiveBody();
            SootClass declClass = method.getDeclaringClass();
            RegionStmt asyncEntryStmt = rstNode.getRegionStmt();
            habFrameClass = new SootClass(declClass.getName() + "$" + localClassID++);
            habFrameClass.setOuterClass(declClass);
            if (asyncEntryStmt instanceof Region1TStmt) {
                habFrameClass.setSuperclass(this.habHFDelayedAsyncFrame);
            } else {
                habFrameClass.setSuperclass(this.habHFBfAsyncFrame);
            }
            Scene.v().addClass(habFrameClass);
            habFrameClass.setApplicationClass();
            HashMap<Local, SootField> classParams = new HashMap<Local, SootField>();
            if (asyncEntryStmt instanceof Region1TStmt) {
                this.buildIsHjTaskReadyMethod(habFrameClass, body, rstNode.getRegionStmt(), classParams, origMethod);
            } else {
                this.buildIsHjTaskReadyMethod(habFrameClass);
            }
            execMethod = this.buildExecMethod(habFrameClass, method, rstNode.getRegionStmt(), body, classParams, origMethod, contMethodMap);
            RSTNode_c newRSTNode = new RSTNode_c();
            newRSTNode.setNodeValue(execMethod);
            newRSTNode.setSubNodes(rstNode.getSubNodes());
            execMethod.setRSTNode(newRSTNode);
        } else if (!rstNode.isFinishNode() && !rstNode.isMethodNode()) {
            if (rstNode.isForLoopNode()) {
                if (!rstNode.isLabeledForLoopNode()) {
                    throw new RuntimeException("The labeled for loop node should not be here");
                }
                RegionStmt regionEntryStmt = rstNode.getRegionStmt();
                Stmt regionExitStmt = regionEntryStmt.getConnect();
                Body body2 = method.retrieveActiveBody();
                body2.getUnits().remove(regionEntryStmt);
                body2.getUnits().remove(regionExitStmt);
            } else if (rstNode.isAtomicNode()) {
                body = method.retrieveActiveBody();
                this.buildAtomicRegion(body, rstNode);
            } else if (!rstNode.isHjOperator()) {
                throw new RuntimeException("Not support this type of region: " + rstNode);
            }
        }
        if (execMethod == null) {
            execMethod = method;
        }
        Iterator<RSTNode> nodeIter = rstNode.getSubNodes().iterator();
        while (nodeIter.hasNext()) {
            this.extractAsync(execMethod, origMethod, nodeIter.next(), contMethodMap, localClassID++);
        }
    }

    protected void buildIsHjTaskReadyMethod(SootClass activityClass, Body body, RegionStmt asyncRegionStmt, HashMap<Local, SootField> classParams, SootMethod origMethod) {
        ReturnStmt retStmt;
        Body origBody = origMethod.retrieveActiveBody();
        Local origThisLocal = null;
        if (!origMethod.isStatic()) {
            origThisLocal = origBody.getThisLocal();
        }
        JimpleBody methodBody = Jimple.v().newBody();
        SootMethod statusMethod = new SootMethod("isHjTaskReady", new ArrayList(), BooleanType.v(), 1);
        methodBody.setMethod(statusMethod);
        statusMethod.setActiveBody(methodBody);
        statusMethod.setDeclaringClass(activityClass);
        activityClass.addMethod(statusMethod);
        Local thisLocal = Jimple.v().newLocal("tl", activityClass.getType());
        methodBody.getLocals().add(thisLocal);
        Local outerThisLocal = null;
        if (!body.getMethod().isStatic()) {
            outerThisLocal = body.getThisLocal();
        }
        LocalGenerator lg = new LocalGenerator(methodBody);
        RegionStmt labelStmt = ((Region1TStmt)asyncRegionStmt).getLabel();
        Iterator<Unit> unitIter = body.getUnits().iterator(body.getUnits().getSuccOf(asyncRegionStmt), body.getUnits().getPredOf(labelStmt));
        HashChain outerMethodLocals = (HashChain)body.getLocals();
        HashChain methodLocals = (HashChain)methodBody.getLocals();
        RegionStmt predStmt = asyncRegionStmt;
        Stmt succStmt = (Stmt)body.getUnits().getSuccOf(labelStmt);
        ArrayList<Stmt> removeStmts = new ArrayList<Stmt>();
        while (unitIter.hasNext()) {
            Stmt stmt = (Stmt)unitIter.next();
            methodBody.getUnits().add(stmt);
            this.checkUses(stmt, outerMethodLocals, methodLocals, classParams);
            this.checkDefs(stmt, outerMethodLocals, methodLocals, classParams);
            removeStmts.add(stmt);
        }
        this.checkUses(labelStmt, outerMethodLocals, methodLocals, classParams);
        Iterator<SootField> fieldIter = classParams.values().iterator();
        while (fieldIter.hasNext()) {
            activityClass.addField(fieldIter.next());
        }
        for (Local local : classParams.keySet()) {
            SootField field = classParams.get(local);
            InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(thisLocal, field.makeRef());
            AssignStmt assignStmt = Jimple.v().newAssignStmt(local, fieldRef);
            methodBody.getUnits().addFirst(assignStmt);
        }
        methodBody.getUnits().addFirst(Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newThisRef(activityClass.getType())));
        Value statusValue = ((NopRegionExpr)labelStmt.getRegionExpr()).getNopValue();
        if (statusValue instanceof Local) {
            retStmt = Jimple.v().newReturnStmt(statusValue);
            methodBody.getUnits().add(retStmt);
            labelStmt.redirectJumpsToThisTo(retStmt);
        } else if (statusValue instanceof ConditionExpr) {
            ConditionExpr condExpr = (ConditionExpr)statusValue;
            Local retLocal = lg.generateLocal(BooleanType.v());
            AssignStmt assignStmt = Jimple.v().newAssignStmt(retLocal, IntConstant.v(1));
            retStmt = Jimple.v().newReturnStmt(retLocal);
            IfStmt ifStmt = Jimple.v().newIfStmt((Value)condExpr, assignStmt);
            methodBody.getUnits().add(ifStmt);
            methodBody.getUnits().add(Jimple.v().newAssignStmt(retLocal, IntConstant.v(0)));
            methodBody.getUnits().add(Jimple.v().newGotoStmt(retStmt));
            methodBody.getUnits().add(assignStmt);
            methodBody.getUnits().add(retStmt);
            labelStmt.redirectJumpsToThisTo(ifStmt);
        } else {
            throw new RuntimeException("Unsupport status label value: " + statusValue.getClass().getName());
        }
        Iterator removeIter = removeStmts.iterator();
        while (removeIter.hasNext()) {
            body.getUnits().removeLow(removeIter.next());
        }
    }

    protected void buildAtomicRegion(Body body, RSTNode rstNode) {
        this.buildAtomicRegion(body, rstNode, new LocalGenerator(body));
    }

    protected void buildAtomicRegion(Body body, RSTNode rstNode, LocalGenerator lg) {
        RegionStmt atomicEntryStmt = rstNode.getRegionStmt();
        Stmt atomicExitStmt = atomicEntryStmt.getConnect();
        Local placeLocal = lg.generateLocal(this.hjLPlaceClass.getType());
        Stmt assignStmt = HjStmtFactory.here(placeLocal);
        body.getUnits().insertBefore(assignStmt, (Unit)atomicEntryStmt);
        EnterMonitorStmt enterMonStmt = Jimple.v().newEnterMonitorStmt(placeLocal);
        body.getUnits().insertBefore(enterMonStmt, (Unit)atomicEntryStmt);
        Stmt handlerLabel0 = (Stmt)body.getUnits().getSuccOf(atomicEntryStmt);
        assignStmt = HjStmtFactory.here(placeLocal);
        body.getUnits().insertBefore(assignStmt, (Unit)atomicExitStmt);
        Stmt handlerLabel1 = assignStmt;
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(placeLocal, this.notifyAllMethod.makeRef(), Collections.EMPTY_LIST));
        body.getUnits().insertBefore(invokeStmt, (Unit)atomicExitStmt);
        ExitMonitorStmt exitMonStmt = Jimple.v().newExitMonitorStmt(placeLocal);
        body.getUnits().insertBefore(exitMonStmt, (Unit)atomicExitStmt);
        GotoStmt gotoStmt = Jimple.v().newGotoStmt((Stmt)body.getUnits().getSuccOf(atomicExitStmt));
        body.getUnits().insertBefore(gotoStmt, (Unit)atomicExitStmt);
        Local throwLocal = lg.generateLocal(this.hjThrowableClass.getType());
        IdentityStmt caughtStmt = Jimple.v().newIdentityStmt(throwLocal, Jimple.v().newCaughtExceptionRef());
        body.getUnits().insertBefore(caughtStmt, (Unit)atomicExitStmt);
        IdentityStmt handlerStmt0 = caughtStmt;
        ThrowStmt throwStmt = Jimple.v().newThrowStmt(throwLocal);
        body.getUnits().insertBefore(throwStmt, (Unit)atomicExitStmt);
        gotoStmt = Jimple.v().newGotoStmt(handlerLabel1);
        body.getUnits().insertBefore(gotoStmt, (Unit)atomicExitStmt);
        Trap trap = Jimple.v().newTrap(this.hjThrowableClass, handlerLabel0, handlerLabel1, handlerStmt0);
        body.getTraps().add(trap);
        body.getUnits().remove(atomicEntryStmt);
        body.getUnits().remove(atomicExitStmt);
    }

    public void identityLocals(SootMethod method) {
        HashSet<String> localsSet = new HashSet<String>();
        for (Local local : method.getActiveBody().getLocals()) {
            while (localsSet.contains(local.getName())) {
                local.setName(local.getName() + "_");
            }
            localsSet.add(local.getName());
        }
    }

    protected void installExecCon(SootClass activityClass, SootMethod initMethod, Local workerLocal, Local placeLocal, HashMap<Local, SootField> classParams, LocalGenerator lg, ArrayList<Stmt> rtStmtList) {
        Local activityLocal = lg.generateLocal(activityClass.getType());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(activityLocal, Jimple.v().newNewExpr(activityClass.getType()));
        rtStmtList.add(assignStmt);
        ArrayList<Type> activityTypeList = new ArrayList<Type>();
        ArrayList<Local> activityParamList = new ArrayList<Local>();
        activityTypeList.add(workerLocal.getType());
        activityParamList.add(workerLocal);
        for (Local local : classParams.keySet()) {
            activityTypeList.add(local.getType());
            activityParamList.add(local);
        }
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(activityLocal, initMethod.makeRef(), activityParamList));
        rtStmtList.add(invokeStmt);
        rtStmtList.add(Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(workerLocal, this.habHFWorkerPushBfAsync.makeRef(), activityLocal)));
    }

    protected void installDelayExecCon(SootClass activityClass, SootMethod initMethod, Local workerLocal, Local placeLocal, HashMap<Local, SootField> classParams, LocalGenerator lg, ArrayList<Stmt> rtStmtList) {
        Local activityLocal = lg.generateLocal(activityClass.getType());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(activityLocal, Jimple.v().newNewExpr(activityClass.getType()));
        rtStmtList.add(assignStmt);
        ArrayList<Type> activityTypeList = new ArrayList<Type>();
        ArrayList<Local> activityParamList = new ArrayList<Local>();
        activityTypeList.add(workerLocal.getType());
        activityParamList.add(workerLocal);
        for (Local local : classParams.keySet()) {
            activityTypeList.add(local.getType());
            activityParamList.add(local);
        }
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(activityLocal, initMethod.makeRef(), activityParamList));
        rtStmtList.add(invokeStmt);
        rtStmtList.add(Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(workerLocal, this.habHFWorkerPushDelayedAsync.makeRef(), activityLocal)));
    }

    protected SootMethod buildInitMethod(SootClass activityClass, HashMap<Local, SootField> classParams, SootClass linkClass) {
        JimpleBody methodBody = Jimple.v().newBody();
        LocalGenerator lg = new LocalGenerator(methodBody);
        Local thisLocal = lg.generateLocal(activityClass.getType());
        ArrayList<Type> typeList = new ArrayList<Type>();
        int paramCounter = 0;
        Local conWorkerLocal = lg.generateLocal(this.habHFWorker.getType());
        methodBody.getUnits().add(Jimple.v().newIdentityStmt(conWorkerLocal, Jimple.v().newParameterRef(this.habHFWorker.getType(), paramCounter++)));
        typeList.add(conWorkerLocal.getType());
        for (Local local : classParams.keySet()) {
            typeList.add(local.getType());
            this.createFieldInit(activityClass, methodBody, classParams.get(local), lg, thisLocal, paramCounter++);
        }
        Local linkedListLocal = null;
        if (linkClass != null) {
            linkedListLocal = lg.generateLocal(linkClass.getType());
            typeList.add(linkClass.getType());
            SootField field = this.createField(linkedListLocal);
            activityClass.addField(field);
            this.createFieldInit(linkedListLocal, methodBody, field, lg, thisLocal, paramCounter++);
        }
        methodBody.getUnits().addFirst(Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newThisRef(activityClass.getType())));
        SootMethod initMethod = new SootMethod("<init>", typeList, VoidType.v(), 1);
        methodBody.setMethod(initMethod);
        initMethod.setActiveBody(methodBody);
        initMethod.setDeclaringClass(activityClass);
        activityClass.addMethod(initMethod);
        ArrayList<Type> typesList = new ArrayList<Type>();
        ArrayList<Local> paramsList = new ArrayList<Local>();
        if (linkClass != null) {
            typesList.add(this.javaListClass.getType());
            paramsList.add(linkedListLocal);
        }
        Local scopeLocal = lg.generateLocal(this.habHFFinishTreeNode.getType());
        AssignStmt scopeStmt = Jimple.v().newAssignStmt(scopeLocal, Jimple.v().newVirtualInvokeExpr(conWorkerLocal, this.habHFWorkerGetCurrentFinishScope.makeRef()));
        typesList = new ArrayList();
        paramsList = new ArrayList();
        typesList.add(scopeLocal.getType());
        paramsList.add(scopeLocal);
        SootMethod superInitMethod = activityClass.getSuperclass() == this.habHFDelayedAsyncFrame ? this.habHFDelayedAsyncFrame.getMethod("<init>", typesList, VoidType.v()) : this.habHFBfAsyncFrame.getMethod("<init>", typesList, VoidType.v());
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(methodBody.getThisLocal(), superInitMethod.makeRef(), paramsList));
        methodBody.getUnits().add(scopeStmt);
        methodBody.getUnits().add(invokeStmt);
        methodBody.getUnits().add(Jimple.v().newReturnVoidStmt());
        return initMethod;
    }

    protected SootMethod buildExecMethod(SootClass activityClass, SootMethod curMethod, RegionStmt asyncRegionStmt, Body body, HashMap<Local, SootField> classParams, SootMethod origMethod, Map contMethodMap) {
        Iterator<Unit> unitIter;
        HabAttrBox habBox;
        Local workerLocal;
        Body origBody = origMethod.retrieveActiveBody();
        Local origThisLocal = null;
        if (!origMethod.isStatic()) {
            origThisLocal = origBody.getThisLocal();
        }
        if ((workerLocal = (habBox = (HabAttrBox)contMethodMap.get(curMethod)).getFCWorker()) == null) {
            throw new Error("xxx " + curMethod);
        }
        JimpleBody methodBody = Jimple.v().newBody();
        ArrayList<RefType> paramList = new ArrayList<RefType>();
        paramList.add(this.habHFWorker.getType());
        SootMethod execMethod = new SootMethod("execute", paramList, VoidType.v(), 1);
        execMethod.addException(this.habHFSpawnFrameStolenException);
        methodBody.setMethod(execMethod);
        execMethod.setActiveBody(methodBody);
        execMethod.setDeclaringClass(activityClass);
        activityClass.addMethod(execMethod);
        Local thisLocal = Jimple.v().newLocal("tl", activityClass.getType());
        methodBody.getLocals().add(thisLocal);
        Local outerThisLocal = null;
        if (!body.getMethod().isStatic()) {
            outerThisLocal = body.getThisLocal();
        }
        Local fcWorkerLocal = this.addLocal(methodBody, "$worker", this.habHFWorker.getType());
        ArrayList<Stmt> removeStmts = new ArrayList<Stmt>();
        Stmt regionExitStmt = asyncRegionStmt.getConnect();
        if (asyncRegionStmt instanceof Region1TStmt) {
            RegionStmt labelStmt = ((Region1TStmt)asyncRegionStmt).getLabel();
            unitIter = body.getUnits().iterator(body.getUnits().getSuccOf(labelStmt), body.getUnits().getPredOf(regionExitStmt));
            removeStmts.add(labelStmt);
        } else {
            unitIter = body.getUnits().iterator(body.getUnits().getSuccOf(asyncRegionStmt), body.getUnits().getPredOf(regionExitStmt));
        }
        HashChain outerMethodLocals = (HashChain)body.getLocals();
        HashChain methodLocals = (HashChain)methodBody.getLocals();
        Stmt predStmt = (Stmt)body.getUnits().getPredOf(asyncRegionStmt);
        Stmt succStmt = (Stmt)body.getUnits().getSuccOf(regionExitStmt);
        removeStmts.add(asyncRegionStmt);
        removeStmts.add(regionExitStmt);
        while (unitIter.hasNext()) {
            Stmt stmt = (Stmt)unitIter.next();
            Unit newStmt = null;
            if (newStmt != null) {
                stmt.redirectJumpsToThisTo(newStmt);
                methodBody.getUnits().add(newStmt);
            } else if (stmt instanceof AssignStmt && ((AssignStmt)stmt).getRightOp() instanceof HjOperator) {
                Value retValue = ((AssignStmt)stmt).getLeftOp();
                methodBody.getUnits().add(Jimple.v().newAssignStmt(retValue, Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habHFWorker.getMethodByName("place").makeRef(), Collections.EMPTY_LIST)));
            } else {
                methodBody.getUnits().add(stmt);
            }
            this.checkUses(stmt, outerMethodLocals, methodLocals, classParams);
            this.checkDefs(stmt, outerMethodLocals, methodLocals, classParams);
            removeStmts.add(stmt);
        }
        Iterator<SootField> fieldIter = classParams.values().iterator();
        while (fieldIter.hasNext()) {
            try {
                activityClass.addField(fieldIter.next());
            }
            catch (Exception e) {}
        }
        for (Local local : classParams.keySet()) {
            SootField field = classParams.get(local);
            if (!methodBody.getLocals().contains(local)) continue;
            InstanceFieldRef fieldRef = Jimple.v().newInstanceFieldRef(thisLocal, field.makeRef());
            AssignStmt assignStmt = Jimple.v().newAssignStmt(local, fieldRef);
            methodBody.getUnits().addFirst(assignStmt);
        }
        if (!origMethod.isStatic() && !classParams.containsKey(outerThisLocal)) {
            SootField field = this.createField(outerThisLocal);
            classParams.put(outerThisLocal, field);
            activityClass.addField(field);
        }
        SootMethod initMethod = this.buildInitMethod(activityClass, classParams, null);
        ArrayList<Stmt> rtStmtList = new ArrayList<Stmt>();
        LocalGenerator lg = new LocalGenerator(body);
        Place placeObj = ((AsyncRegionExpr)asyncRegionStmt.getRegionExpr()).getPlace();
        Local placeLocal = null;
        this.installExecCon(activityClass, initMethod, workerLocal, placeLocal, classParams, lg, rtStmtList);
        Iterator<Stmt> stmtIter = rtStmtList.iterator();
        while (stmtIter.hasNext()) {
            body.getUnits().insertBefore(stmtIter.next(), (Unit)succStmt);
        }
        methodBody.getUnits().addFirst(Jimple.v().newIdentityStmt(fcWorkerLocal, Jimple.v().newParameterRef(this.habHFWorker.getType(), 0)));
        methodBody.getUnits().addFirst(Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newThisRef(activityClass.getType())));
        ReturnVoidStmt retStmt = Jimple.v().newReturnVoidStmt();
        methodBody.getUnits().addLast(retStmt);
        asyncRegionStmt.redirectJumpsToThisTo(rtStmtList.get(0));
        regionExitStmt.redirectJumpsToThisTo(retStmt);
        this.checkTraps(body, methodBody, body.getTraps(), asyncRegionStmt, regionExitStmt);
        HabAttrBox newHabBox = new HabAttrBox(true);
        newHabBox.setFastClone(execMethod);
        newHabBox.setFCWorker(fcWorkerLocal);
        contMethodMap.put(execMethod, newHabBox);
        Iterator removeIter = removeStmts.iterator();
        while (removeIter.hasNext()) {
            body.getUnits().removeLow(removeIter.next());
        }
        return execMethod;
    }

    protected void checkTraps(Body body, Body methodBody, Chain<Trap> traps, Stmt regionEntryStmt, Stmt regionExitStmt) {
        for (Trap trap : traps) {
            Stmt beginStmt = (Stmt)trap.getBeginUnit();
            if (body.getUnits().contains(beginStmt) && (!body.getUnits().follows(beginStmt, regionEntryStmt) || !body.getUnits().follows(regionExitStmt, beginStmt))) continue;
            methodBody.getTraps().add(trap);
        }
        Iterator<Trap> trapIter = methodBody.getTraps().iterator();
        while (trapIter.hasNext()) {
            body.getTraps().remove(trapIter.next());
        }
    }

    @Override
    protected void checkUses(Stmt s, HashChain<Local> outerMethodLocals, HashChain<Local> methodLocals, HashMap<Local, SootField> classParams) {
        Object[] uses = s.getUseBoxes().toArray();
        for (int i = 0; i < uses.length; ++i) {
            Local local;
            Value value = ((ValueBox)uses[i]).getValue();
            if (!(value instanceof Local) || methodLocals.contains(local = (Local)value) || !outerMethodLocals.contains(local)) continue;
            methodLocals.add(local);
            if (classParams.containsKey(local)) continue;
            classParams.put(local, this.createField(local));
        }
    }

    @Override
    protected void checkDefs(Stmt s, HashChain<Local> outerMethodLocals, HashChain<Local> methodLocals, HashMap<Local, SootField> classParams) {
        Object[] defs = s.getDefBoxes().toArray();
        for (int i = 0; i < defs.length; ++i) {
            Local local;
            Value value = ((ValueBox)defs[i]).getValue();
            if (!(value instanceof Local) || methodLocals.contains(local = (Local)value) || !outerMethodLocals.contains(local)) continue;
            methodLocals.add(local);
            outerMethodLocals.remove(local);
        }
    }

    public SootMethod createFCMethod(SootMethod method, HabAttrBox habBox) {
        SootMethod fcMethod = new SootMethod(method.getName(), method.getParameterTypes(), method.getReturnType(), method.getModifiers());
        fcMethod.setActiveBody(method.retrieveActiveBody());
        fcMethod.setRSTNode(method.getRSTNode());
        fcMethod.addExceptionIfAbsent(this.habHFSpawnFrameStolenException);
        this.incParamRef(fcMethod);
        JimpleLocal fcWorkerLocal = new JimpleLocal("$worker", this.habHFWorker.getType());
        method.retrieveActiveBody().getLocals().add(fcWorkerLocal);
        habBox.setFCWorker(fcWorkerLocal);
        ArrayList<RefType> params = new ArrayList<RefType>();
        params.add(0, this.habHFWorker.getType());
        params.addAll(method.getParameterTypes());
        fcMethod.setParameterTypes(params);
        IdentityStmt identityStmt = Jimple.v().newIdentityStmt(fcWorkerLocal, Jimple.v().newParameterRef(this.habHFWorker.getType(), 0));
        JimpleBody methodBody = (JimpleBody)method.retrieveActiveBody();
        Stmt firstNonIdentityStmt = methodBody.getFirstNonIdentityStmt();
        Stmt labelStmt = (Stmt)methodBody.getUnits().getPredOf(firstNonIdentityStmt);
        if (labelStmt == null) {
            labelStmt = firstNonIdentityStmt;
            methodBody.getUnits().insertBefore(identityStmt, (Unit)labelStmt);
        } else {
            methodBody.getUnits().insertAfter(identityStmt, (Unit)labelStmt);
        }
        method.getDeclaringClass().addMethod(fcMethod);
        return fcMethod;
    }

    public SootMethod createSCMethod(SootMethod method, Body scBody) {
        ArrayList<RefType> paramTypeList = new ArrayList<RefType>();
        paramTypeList.add(this.habHFWorker.getType());
        paramTypeList.add(this.habHFFrame.getType());
        SootMethod scMethod = new SootMethod(method.getName() + "Slow", paramTypeList, VoidType.v(), method.getModifiers());
        scMethod.setActiveBody(scBody);
        scMethod.addExceptionIfAbsent(this.habHFSpawnFrameStolenException);
        SootClass declClass = method.getDeclaringClass();
        scMethod.setDeclaringClass(declClass);
        declClass.addMethod(scMethod);
        return scMethod;
    }

    public SootMethod genFastClone(SootMethod origMethod, SootClass frameClass, SootMethod frameConMethod, Map contMethodMap, HabAttrBox habBox) {
        SootClass declClass = origMethod.getDeclaringClass();
        SootMethod fcMethod = habBox.getFastClone();
        JimpleBody fcBody = (JimpleBody)fcMethod.getActiveBody();
        Local fcWorkerLocal = habBox.getFCWorker();
        Stmt labelStmt = (Stmt)fcBody.getUnits().getPredOf(fcBody.getFirstNonIdentityStmt());
        LocalGenerator fcLg = new LocalGenerator(fcBody);
        Local fcFrameLocal = fcLg.generateLocal("frame", frameClass.getType());
        ArrayList<Stmt> contList = new ArrayList<Stmt>();
        int currentPC = 1;
        this.handleMethodBody(fcMethod.getRSTNode(), frameClass, fcMethod, fcBody, fcWorkerLocal, fcFrameLocal, fcLg, contMethodMap, habBox, contList, currentPC);
        contList.add(0, fcBody.getFirstNonIdentityStmt());
        habBox.setContList(contList);
        Stmt tempLabel = (Stmt)fcBody.getUnits().getPredOf(fcBody.getFirstNonIdentityStmt());
        Local pcLocal = fcLg.generateLocal(IntType.v());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(pcLocal, Jimple.v().newInstanceFieldRef(fcFrameLocal, this.habHFFramePC.makeRef()));
        fcBody.getUnits().insertAfter(assignStmt, (Unit)tempLabel);
        tempLabel = assignStmt;
        Stmt defaultLabel = (Stmt)fcBody.getUnits().getLast();
        fcBody.getUnits().insertBefore(Jimple.v().newNopStmt(), (Unit)defaultLabel);
        TableSwitchStmt switchStmt = Jimple.v().newTableSwitchStmt((Value)pcLocal, 0, contList.size() - 1, contList, defaultLabel);
        fcBody.getUnits().insertAfter(switchStmt, (Unit)tempLabel);
        fcBody.getUnits().addFirst(Jimple.v().newAssignStmt(fcFrameLocal, fcWorkerLocal));
        JimpleBody scBody = (JimpleBody)fcBody.clone();
        fcBody.getUnits().remove(fcBody.getUnits().getFirst());
        fcBody.getUnits().remove(fcBody.getFirstNonIdentityStmt());
        fcBody.getUnits().remove(fcBody.getFirstNonIdentityStmt());
        tempLabel = (Stmt)fcBody.getUnits().getPredOf(fcBody.getFirstNonIdentityStmt());
        assignStmt = Jimple.v().newAssignStmt(fcFrameLocal, Jimple.v().newNewExpr(frameClass.getType()));
        fcBody.getUnits().insertAfter(assignStmt, (Unit)tempLabel);
        tempLabel = assignStmt;
        ArrayList<Local> fcParamList = new ArrayList<Local>();
        if (!fcMethod.isStatic()) {
            fcParamList.add(fcBody.getThisLocal());
        }
        for (int i = 1; i < fcMethod.getParameterCount(); ++i) {
            fcParamList.add(fcBody.getParameterLocal(i));
        }
        InvokeStmt frameInitStmt = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(fcFrameLocal, frameConMethod.makeRef(), fcParamList));
        fcBody.getUnits().insertAfter(frameInitStmt, (Unit)tempLabel);
        tempLabel = frameInitStmt;
        InvokeStmt virtualInvoke = Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habHFWorkerBeginMethod.makeRef(), fcFrameLocal));
        fcBody.getUnits().insertAfter(virtualInvoke, (Unit)tempLabel);
        tempLabel = virtualInvoke;
        this.genEndMethodFast(fcWorkerLocal, fcBody);
        SootMethod scMethod = this.createSCMethod(origMethod, scBody);
        habBox.setSlowClone(scMethod);
        LocalGenerator scLg = new LocalGenerator(scBody);
        Stmt scSpecLabel = (Stmt)scBody.getUnits().getFirst();
        Local scWorkerLocal = (Local)((AssignStmt)scSpecLabel).getRightOp();
        Local scFrameLocal = (Local)((AssignStmt)scSpecLabel).getLeftOp();
        scBody.getUnits().remove(scSpecLabel);
        habBox.setSCWorker(scWorkerLocal);
        habBox.setSCFrame(scFrameLocal);
        this.removeIdentityStmt(scBody, 0);
        this.genEndMethodSlow(scWorkerLocal, scBody, scLg);
        tempLabel = scBody.getFirstNonIdentityStmt();
        Local tempFrameLocal = scLg.generateLocal(this.habHFFrame.getType());
        IdentityStmt identityStmt = Jimple.v().newIdentityStmt(tempFrameLocal, Jimple.v().newParameterRef(this.habHFFrame.getType(), 1));
        scBody.getUnits().insertBefore(identityStmt, (Unit)tempLabel);
        assignStmt = Jimple.v().newAssignStmt(scFrameLocal, Jimple.v().newCastExpr(tempFrameLocal, frameClass.getType()));
        scBody.getUnits().insertBefore(assignStmt, (Unit)tempLabel);
        for (Local local : scBody.getLocals()) {
            if (!frameClass.declaresField(local.getName(), local.getType())) continue;
            SootField field = frameClass.getField(local.getName(), local.getType());
            assignStmt = Jimple.v().newAssignStmt(local, Jimple.v().newInstanceFieldRef(scFrameLocal, field.makeRef()));
            scBody.getUnits().insertBefore(assignStmt, (Unit)tempLabel);
        }
        return fcMethod;
    }

    public void resetMethodInvoke(RSTNode rstNode, HabAttrBox habBox, Map contMethodMap) {
        for (RSTNode subNode : rstNode.getSubNodes()) {
            ValueBox valueBox;
            if (!subNode.isMethodNode()) continue;
            Stmt invokeStmt = subNode.getNodeStmt();
            if (invokeStmt instanceof InvokeStmt) {
                valueBox = ((InvokeStmt)invokeStmt).getInvokeExprBox();
            } else if (invokeStmt instanceof AssignStmt) {
                valueBox = ((AssignStmt)invokeStmt).getRightOpBox();
            } else {
                throw new RuntimeException("Unsupport invoke stmt: " + invokeStmt.getClass().getName());
            }
            InvokeExpr invokeExpr = (InvokeExpr)valueBox.getValue();
            if ((invokeExpr = this.handleInvoke(invokeExpr, habBox.getFCWorker(), contMethodMap)) == null) continue;
            valueBox.setValue(invokeExpr);
        }
    }

    public void resetMethodInvoke_(SootMethod method, HabAttrBox habBox, Map contMethodMap) {
        Body body = method.getActiveBody();
        for (Stmt stmt : body.getUnits()) {
            if (!stmt.containsInvokeExpr()) continue;
            InvokeExpr invokeExpr = stmt.getInvokeExpr();
            if ((invokeExpr = this.handleInvoke(invokeExpr, habBox.getFCWorker(), contMethodMap)) == null) continue;
            stmt.getInvokeExprBox().setValue(invokeExpr);
        }
    }

    protected int handleMethodBody(RSTNode rstNode, SootClass frameClass, SootMethod fcMethod, JimpleBody fcBody, Local fcWorkerLocal, Local fcFrameLocal, LocalGenerator fcLg, Map contMethodMap, HabAttrBox habBox, ArrayList<Stmt> contList, int currentPC) {
        for (RSTNode subNode : rstNode.getSubNodes()) {
            ValueBox valueBox;
            Stmt invokeStmt;
            if (subNode.isFinishNode()) {
                currentPC = this.handleMethodBody(subNode, frameClass, fcMethod, fcBody, fcWorkerLocal, fcFrameLocal, fcLg, contMethodMap, habBox, contList, currentPC);
                RegionStmt regionEntryStmt = subNode.getRegionStmt();
                Stmt regionExitStmt = regionEntryStmt.getConnect();
                InvokeStmt invokeStmt2 = Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habHFWorkerStartFinish.makeRef()));
                fcBody.getUnits().insertBefore(invokeStmt2, (Unit)regionEntryStmt);
                fcBody.getUnits().remove(regionEntryStmt);
                Stmt followStmt = (Stmt)fcBody.getUnits().getSuccOf(regionExitStmt);
                if (this.hasContinuation(subNode, contMethodMap, false)) {
                    Stmt tempLabel = regionExitStmt;
                    for (Local local : fcBody.getLocals()) {
                        if (!frameClass.declaresField(local.getName(), local.getType()) || !this.wsTool.shouldSave(tempLabel, local)) continue;
                        SootField field = frameClass.getField(local.getName(), local.getType());
                        AssignStmt assignStmt = Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(fcFrameLocal, field.makeRef()), local);
                        fcBody.getUnits().insertBefore(assignStmt, (Unit)tempLabel);
                    }
                    AssignStmt pcUpdateStmt = Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(fcFrameLocal, this.habHFFramePC.makeRef()), IntConstant.v(currentPC));
                    fcBody.getUnits().insertBefore(pcUpdateStmt, (Unit)tempLabel);
                    Local checkLocal = fcLg.generateLocal(BooleanType.v());
                    AssignStmt stopFinishStmt = Jimple.v().newAssignStmt(checkLocal, Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habHFWorkerStopFinishSlow.makeRef()));
                    fcBody.getUnits().insertBefore(stopFinishStmt, (Unit)tempLabel);
                    NopStmt contLabel = Jimple.v().newNopStmt();
                    fcBody.getUnits().insertAfter(contLabel, (Unit)regionExitStmt);
                    contList.add(contLabel);
                    ++currentPC;
                } else {
                    InvokeStmt stopFinishStmt = Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habHFWorkerStopFinishSlow.makeRef()));
                    fcBody.getUnits().insertAfter(stopFinishStmt, (Unit)regionExitStmt);
                }
                fcBody.getUnits().remove(regionExitStmt);
                continue;
            }
            if (!subNode.isMethodNode()) continue;
            Stmt tempLabel = invokeStmt = subNode.getNodeStmt();
            if (invokeStmt instanceof InvokeStmt) {
                valueBox = ((InvokeStmt)invokeStmt).getInvokeExprBox();
            } else if (invokeStmt instanceof AssignStmt) {
                valueBox = ((AssignStmt)invokeStmt).getRightOpBox();
            } else {
                throw new RuntimeException("Unsupport invoke stmt: " + invokeStmt.getClass().getName());
            }
            InvokeExpr invokeExpr = (InvokeExpr)valueBox.getValue();
            if ((invokeExpr = this.handleInvoke(invokeExpr, fcWorkerLocal, contMethodMap)) == null) continue;
            valueBox.setValue(invokeExpr);
            for (Local local : fcBody.getLocals()) {
                if (!frameClass.declaresField(local.getName(), local.getType()) || !this.wsTool.shouldSave(tempLabel, local)) continue;
                SootField field = frameClass.getField(local.getName(), local.getType());
                AssignStmt assignStmt = Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(fcFrameLocal, field.makeRef()), local);
                fcBody.getUnits().insertBefore(assignStmt, (Unit)tempLabel);
            }
            AssignStmt pcUpdateStmt = Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(fcFrameLocal, this.habHFFramePC.makeRef()), IntConstant.v(currentPC));
            fcBody.getUnits().insertBefore(pcUpdateStmt, (Unit)tempLabel);
            NopStmt contLabel = Jimple.v().newNopStmt();
            fcBody.getUnits().insertAfter(contLabel, (Unit)invokeStmt);
            contList.add(contLabel);
            if (invokeStmt instanceof AssignStmt) {
                habBox.addCallCont(contLabel, invokeStmt);
            }
            ++currentPC;
        }
        return currentPC;
    }

    protected void genEndMethodFast(Local fcWorkerLocal, JimpleBody fcBody) {
        Iterator<Unit> unitIter = fcBody.getUnits().snapshotIterator();
        while (unitIter.hasNext()) {
            Stmt retStmt = (Stmt)unitIter.next();
            if (retStmt instanceof ReturnVoidStmt || retStmt instanceof ReturnStmt) {
                InvokeStmt endFastStmt = Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habHFWorkerEndMethodFast.makeRef()));
                fcBody.getUnits().insertBefore(endFastStmt, (Unit)retStmt);
                continue;
            }
            if (!(retStmt instanceof AssignStmt) || !(((AssignStmt)retStmt).getRightOp() instanceof HjDistHere)) continue;
            Value retValue = ((AssignStmt)retStmt).getLeftOp();
            fcBody.getUnits().insertBefore(Jimple.v().newAssignStmt(retValue, Jimple.v().newVirtualInvokeExpr(fcWorkerLocal, this.habHFWorker.getMethodByName("place").makeRef(), Collections.EMPTY_LIST)), (Unit)retStmt);
            fcBody.getUnits().remove(retStmt);
        }
    }

    protected void genEndMethodSlow(Local scWorkerLocal, JimpleBody scBody, LocalGenerator scLg) {
        Iterator<Unit> unitIter = scBody.getUnits().snapshotIterator();
        while (unitIter.hasNext()) {
            Stmt tempLabel;
            Stmt retStmt = (Stmt)unitIter.next();
            if (retStmt instanceof ReturnVoidStmt) {
                tempLabel = (Stmt)scBody.getUnits().getPredOf(retStmt);
                InvokeStmt endSlowStmt = Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(scWorkerLocal, this.habHFWorkerEndMethodSlow.makeRef()));
                scBody.getUnits().insertAfter(endSlowStmt, (Unit)tempLabel);
                continue;
            }
            if (retStmt instanceof ReturnStmt) {
                tempLabel = (Stmt)scBody.getUnits().getPredOf(retStmt);
                Value retValue = ((ReturnStmt)retStmt).getOp();
                Stmt objStmt = this.genReturnObject(retValue, scLg);
                if (objStmt != null) {
                    scBody.getUnits().insertAfter(objStmt, (Unit)tempLabel);
                    tempLabel = objStmt;
                    retValue = (Local)((AssignStmt)objStmt).getLeftOp();
                }
                InvokeStmt endSlowStmt = Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(scWorkerLocal, this.habHFWorkerEndMethodSlowObject.makeRef(), retValue));
                scBody.getUnits().insertAfter(endSlowStmt, (Unit)tempLabel);
                ReturnVoidStmt retVoidStmt = Jimple.v().newReturnVoidStmt();
                scBody.getUnits().swapWith(retStmt, retVoidStmt);
                continue;
            }
            if (!(retStmt instanceof AssignStmt) || !(((AssignStmt)retStmt).getRightOp() instanceof HjDistHere)) continue;
            Value retValue = ((AssignStmt)retStmt).getLeftOp();
            scBody.getUnits().insertBefore(Jimple.v().newAssignStmt(retValue, Jimple.v().newVirtualInvokeExpr(scWorkerLocal, this.habHFWorker.getMethodByName("place").makeRef(), Collections.EMPTY_LIST)), (Unit)retStmt);
            scBody.getUnits().remove(retStmt);
        }
    }

    protected void removeIdentityStmt(JimpleBody methodBody, int paramIndex) {
        ArrayList<Stmt> removeStmts = new ArrayList<Stmt>();
        Iterator<Unit> unitIter = methodBody.getUnits().iterator(methodBody.getUnits().getFirst(), methodBody.getFirstNonIdentityStmt());
        while (unitIter.hasNext()) {
            Value value;
            Stmt stmt = (Stmt)unitIter.next();
            if (!(stmt instanceof IdentityStmt) || !((value = ((IdentityStmt)stmt).getRightOp()) instanceof ParameterRef) || ((ParameterRef)value).getIndex() <= paramIndex) continue;
            removeStmts.add(stmt);
        }
        Iterator stmtIter = removeStmts.iterator();
        while (stmtIter.hasNext()) {
            methodBody.getUnits().remove(stmtIter.next());
        }
    }

    protected InvokeExpr handleInvoke(InvokeExpr invokeExpr, Local workerLocal, Map contMethodMap) {
        SootMethodRef methodRef = invokeExpr.getMethodRef();
        HabAttrBox habBox = null;
        SootMethod origMethod = methodNameMap.get(methodRef.resolve().toString());
        if (origMethod != null) {
            habBox = (HabAttrBox)contMethodMap.get(origMethod);
        }
        if (habBox == null) {
            return null;
        }
        SootMethod method = habBox.getFastClone();
        ArrayList<Local> params = new ArrayList<Local>();
        params.add(workerLocal);
        params.addAll(invokeExpr.getArgs());
        if (invokeExpr instanceof InstanceInvokeExpr) {
            Local baseLocal = (Local)((InstanceInvokeExpr)invokeExpr).getBase();
            if (invokeExpr instanceof VirtualInvokeExpr) {
                return Jimple.v().newVirtualInvokeExpr(baseLocal, method.makeRef(), params);
            }
            if (invokeExpr instanceof InterfaceInvokeExpr) {
                return Jimple.v().newInterfaceInvokeExpr(baseLocal, method.makeRef(), params);
            }
            if (invokeExpr instanceof SpecialInvokeExpr) {
                return Jimple.v().newSpecialInvokeExpr(baseLocal, method.makeRef(), params);
            }
            throw new RuntimeException("Unsupport invoke: " + invokeExpr.getClass().getName());
        }
        if (invokeExpr instanceof StaticInvokeExpr) {
            return Jimple.v().newStaticInvokeExpr(method.makeRef(), params);
        }
        throw new RuntimeException("Unsupport invoke: " + invokeExpr.getClass().getName());
    }

    protected Stmt genReturnObject(Value retValue, LocalGenerator lg) {
        if (retValue.getType() instanceof IntegerType) {
            Local retLocal = lg.generateLocal(this.javaLangInteger.getType());
            return Jimple.v().newAssignStmt(retLocal, Jimple.v().newStaticInvokeExpr(this.integerValueOf.makeRef(), retValue));
        }
        if (retValue.getType() instanceof ByteType) {
            Local retLocal = lg.generateLocal(this.javaLangByte.getType());
            return Jimple.v().newAssignStmt(retLocal, Jimple.v().newStaticInvokeExpr(this.byteValueOf.makeRef(), retValue));
        }
        if (retValue.getType() instanceof ShortType) {
            Local retLocal = lg.generateLocal(this.javaLangShort.getType());
            return Jimple.v().newAssignStmt(retLocal, Jimple.v().newStaticInvokeExpr(this.shortValueOf.makeRef(), retValue));
        }
        if (retValue.getType() instanceof LongType) {
            Local retLocal = lg.generateLocal(this.javaLangLong.getType());
            return Jimple.v().newAssignStmt(retLocal, Jimple.v().newStaticInvokeExpr(this.longValueOf.makeRef(), retValue));
        }
        if (retValue.getType() instanceof FloatType) {
            Local retLocal = lg.generateLocal(this.javaLangFloat.getType());
            return Jimple.v().newAssignStmt(retLocal, Jimple.v().newStaticInvokeExpr(this.floatValueOf.makeRef(), retValue));
        }
        if (retValue.getType() instanceof DoubleType) {
            Local retLocal = lg.generateLocal(this.javaLangDouble.getType());
            return Jimple.v().newAssignStmt(retLocal, Jimple.v().newStaticInvokeExpr(this.doubleValueOf.makeRef(), retValue));
        }
        if (retValue.getType() instanceof BooleanType) {
            Local retLocal = lg.generateLocal(this.javaLangBoolean.getType());
            return Jimple.v().newAssignStmt(retLocal, Jimple.v().newStaticInvokeExpr(this.booleanValueOf.makeRef(), retValue));
        }
        if (retValue.getType() instanceof RefType) {
            return null;
        }
        throw new RuntimeException("Unsupport return type: " + retValue.getType());
    }

    public SootMethod buildMainFunc(SootClass declClass, HabAttrBox habBox) {
        SootMethod mainMethod = new SootMethod("main", Arrays.asList(ArrayType.v(RefType.v("java.lang.String"), 1)), VoidType.v(), 9);
        JimpleBody mainBody = Jimple.v().newBody(mainMethod);
        mainMethod.setActiveBody(mainBody);
        declClass.addMethod(mainMethod);
        LocalGenerator lg = new LocalGenerator(mainBody);
        Local argsLocal = lg.generateLocal("args", mainMethod.getParameterType(0));
        mainBody.getUnits().add(Jimple.v().newIdentityStmt(argsLocal, Jimple.v().newParameterRef(mainMethod.getParameterType(0), 0)));
        Local numProcLocal = lg.generateLocal("numProc", IntType.v());
        mainBody.getUnits().add(Jimple.v().newAssignStmt(numProcLocal, IntConstant.v(0)));
        Local argsLenLocal = lg.generateLocal("argsLength", IntType.v());
        AssignStmt argsLenStmt = Jimple.v().newAssignStmt(argsLenLocal, Jimple.v().newLengthExpr(argsLocal));
        mainBody.getUnits().add(argsLenStmt);
        Local arg0Local = lg.generateLocal("arg0", RefType.v("java.lang.String"));
        mainBody.getUnits().add(Jimple.v().newAssignStmt(arg0Local, Jimple.v().newArrayRef(argsLocal, IntConstant.v(0))));
        Local condLocal = lg.generateLocal("equalsCond", BooleanType.v());
        AssignStmt equalsCondStmt = Jimple.v().newAssignStmt(condLocal, Jimple.v().newVirtualInvokeExpr(arg0Local, Scene.v().getSootClass("java.lang.String").getMethod("boolean equals(java.lang.Object)").makeRef(), StringConstant.v("--nproc")));
        mainBody.getUnits().add(equalsCondStmt);
        Local arg1Local = lg.generateLocal("arg1", RefType.v("java.lang.String"));
        mainBody.getUnits().add(Jimple.v().newAssignStmt(arg1Local, Jimple.v().newArrayRef(argsLocal, IntConstant.v(1))));
        AssignStmt assignStParse = Jimple.v().newAssignStmt(numProcLocal, Jimple.v().newStaticInvokeExpr(Scene.v().getSootClass("java.lang.Integer").getMethod("int parseInt(java.lang.String)").makeRef(), arg1Local));
        mainBody.getUnits().add(assignStParse);
        Local restArgsLenLocal = lg.generateLocal("restArgsLength", IntType.v());
        mainBody.getUnits().add(Jimple.v().newAssignStmt(restArgsLenLocal, Jimple.v().newSubExpr(argsLenLocal, IntConstant.v(2))));
        Local restArgsLocal = lg.generateLocal("restArgs", mainMethod.getParameterType(0));
        mainBody.getUnits().add(Jimple.v().newAssignStmt(restArgsLocal, Jimple.v().newNewArrayExpr(RefType.v("java.lang.String"), restArgsLenLocal)));
        mainBody.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(Scene.v().getSootClass("java.lang.System").getMethodByName("arraycopy").makeRef(), Arrays.asList(argsLocal, IntConstant.v(2), restArgsLocal, IntConstant.v(0), restArgsLenLocal))));
        AssignStmt argsAssignStmt = Jimple.v().newAssignStmt(argsLocal, restArgsLocal);
        mainBody.getUnits().add(argsAssignStmt);
        Local numFormatExcpLocal = lg.generateLocal("numberFormatException", RefType.v("java.lang.NumberFormatException"));
        IdentityStmt caughtExcpStmt = Jimple.v().newIdentityStmt(numFormatExcpLocal, Jimple.v().newCaughtExceptionRef());
        mainBody.getUnits().add(caughtExcpStmt);
        AssignStmt assignStmt1 = Jimple.v().newAssignStmt(numProcLocal, IntConstant.v(1));
        mainBody.getUnits().add(assignStmt1);
        AssignStmt thenLastStmt = assignStmt1;
        AssignStmt assignStmt2 = Jimple.v().newAssignStmt(numProcLocal, IntConstant.v(2));
        mainBody.getUnits().add(assignStmt2);
        IfStmt firstIfStmt = Jimple.v().newIfStmt((Value)Jimple.v().newLtExpr(argsLenLocal, IntConstant.v(2)), assignStmt2);
        mainBody.getUnits().insertAfter(firstIfStmt, (Unit)argsLenStmt);
        IfStmt secIfStmt = Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr(condLocal, IntConstant.v(0)), assignStmt2);
        mainBody.getUnits().insertAfter(secIfStmt, (Unit)equalsCondStmt);
        Local runtimeLocal = lg.generateLocal("runtime", this.habHFRuntime.getType());
        AssignStmt newRuntimeStmt = Jimple.v().newAssignStmt(runtimeLocal, Jimple.v().newNewExpr(this.habHFRuntime.getType()));
        mainBody.getUnits().add(newRuntimeStmt);
        GotoStmt gotoStmt = Jimple.v().newGotoStmt(newRuntimeStmt);
        mainBody.getUnits().insertAfter(gotoStmt, (Unit)argsAssignStmt);
        mainBody.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(runtimeLocal, this.habHFRuntime.getMethod("void <init>(int,boolean,boolean)").makeRef(), Arrays.asList(numProcLocal, IntConstant.v(0), IntConstant.v(0)))));
        mainBody.getUnits().insertAfter(Jimple.v().newGotoStmt(newRuntimeStmt), (Unit)thenLastStmt);
        SootClass mainFrameClass = habBox.getFrameClass();
        SootMethod mainFrameConMethod = habBox.getFrameCon();
        Local mainFrameLocal = lg.generateLocal("mainframe", mainFrameClass.getType());
        mainBody.getUnits().add(Jimple.v().newAssignStmt(mainFrameLocal, Jimple.v().newNewExpr(mainFrameClass.getType())));
        mainBody.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(mainFrameLocal, mainFrameConMethod.makeRef(), argsLocal)));
        InvokeStmt startWorkerStmt = Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(runtimeLocal, this.habHFRuntimeStartWorkers.makeRef(), mainFrameLocal));
        mainBody.getUnits().add(startWorkerStmt);
        mainBody.getTraps().add(Jimple.v().newTrap(Scene.v().getSootClass("java.lang.NumberFormatException"), argsLenStmt, gotoStmt, caughtExcpStmt));
        mainBody.getUnits().add(Jimple.v().newReturnVoidStmt());
        return mainMethod;
    }

    public boolean hasContinuation(RSTNode rstNode, Map contMethodMap, boolean isFinishNode) {
        if (rstNode.isFinishNode()) {
            isFinishNode = true;
        }
        for (RSTNode subNode : rstNode.getSubNodes()) {
            if (subNode.isAsyncNode()) {
                return true;
            }
            if (subNode.isMethodNode() && methodNameMap.containsKey(subNode.getNodeMethod().toString())) {
                return true;
            }
            if (!this.hasContinuation(subNode, contMethodMap, isFinishNode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAsync(RSTNode rstNode) {
        for (RSTNode subNode : rstNode.getSubNodes()) {
            if (subNode.isAsyncNode()) {
                return true;
            }
            if (!this.hasAsync(subNode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasContinuation(RSTNode rstNode, boolean isFinishNode) {
        if (rstNode.isFinishNode()) {
            isFinishNode = true;
        }
        for (RSTNode subNode : rstNode.getSubNodes()) {
            if (subNode.isAsyncNode()) {
                return true;
            }
            if (!this.hasContinuation(subNode, isFinishNode)) continue;
            return true;
        }
        return false;
    }

    protected SootMethod buildSetReturn(SootClass frameClass, Map local2FieldMap, HabAttrBox habBox) {
        List<Stmt> contList = habBox.getContList();
        SootMethod setRetMethod = new SootMethod("setReturnResult", Arrays.asList(this.javaLangObject.getType()), VoidType.v(), 1);
        frameClass.addMethod(setRetMethod);
        JimpleBody setRetBody = Jimple.v().newBody(setRetMethod);
        setRetMethod.setActiveBody(setRetBody);
        LocalGenerator lg = new LocalGenerator(setRetBody);
        Local thisLocal = lg.generateLocal(frameClass.getType());
        setRetBody.getUnits().add(Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newThisRef(frameClass.getType())));
        Local retObjLocal = lg.generateLocal(this.javaLangObject.getType());
        setRetBody.getUnits().add(Jimple.v().newIdentityStmt(retObjLocal, Jimple.v().newParameterRef(this.javaLangObject.getType(), 0)));
        ArrayList<Stmt> targetList = new ArrayList<Stmt>();
        for (int i = 0; i < contList.size(); ++i) {
            Stmt contStmt = contList.get(i);
            Stmt callContStmt = habBox.getCallCont(contStmt);
            if (callContStmt != null) {
                Local retLocal = (Local)((AssignStmt)callContStmt).getLeftOp();
                SootField retField = (SootField)local2FieldMap.get(retLocal);
                if (retField == null) {
                    throw new RuntimeException("Can't find corresponding frame class field for local: " + retLocal);
                }
                Stmt targetStmt = this.createAssign(retLocal.getType(), lg, retObjLocal, setRetBody, thisLocal, retField);
                targetList.add(targetStmt);
                setRetBody.getUnits().add(Jimple.v().newReturnVoidStmt());
                continue;
            }
            ReturnVoidStmt retStmt = Jimple.v().newReturnVoidStmt();
            setRetBody.getUnits().add(retStmt);
            targetList.add(retStmt);
        }
        ReturnVoidStmt retStmt = Jimple.v().newReturnVoidStmt();
        setRetBody.getUnits().add(retStmt);
        Stmt tempLabel = (Stmt)setRetBody.getUnits().getPredOf(setRetBody.getFirstNonIdentityStmt());
        Local pcLocal = lg.generateLocal(IntType.v());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(pcLocal, Jimple.v().newInstanceFieldRef(thisLocal, this.habHFFramePC.makeRef()));
        setRetBody.getUnits().insertAfter(assignStmt, (Unit)tempLabel);
        tempLabel = assignStmt;
        if (targetList.size() == 0) {
            return setRetMethod;
        }
        TableSwitchStmt switchStmt = Jimple.v().newTableSwitchStmt((Value)pcLocal, 0, targetList.size() - 1, targetList, retStmt);
        setRetBody.getUnits().insertAfter(switchStmt, (Unit)tempLabel);
        return setRetMethod;
    }

    protected Stmt createAssign(Type type, LocalGenerator lg, Local retObjLocal, Body setRetBody, Local thisLocal, SootField retField) {
        AssignStmt segStmt = null;
        if (type instanceof IntegerType) {
            Local defLocal = lg.generateLocal(type);
            Local defIntegerLocal = lg.generateLocal(this.javaLangInteger.getType());
            segStmt = Jimple.v().newAssignStmt(defIntegerLocal, Jimple.v().newCastExpr(retObjLocal, this.javaLangInteger.getType()));
            setRetBody.getUnits().add(segStmt);
            AssignStmt assignStmt = Jimple.v().newAssignStmt(defLocal, Jimple.v().newVirtualInvokeExpr(defIntegerLocal, this.integerIntValue.makeRef()));
            setRetBody.getUnits().add(assignStmt);
            assignStmt = Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(thisLocal, retField.makeRef()), defLocal);
            setRetBody.getUnits().add(assignStmt);
        } else if (type instanceof RefType) {
            Local defLocal = lg.generateLocal(type);
            segStmt = Jimple.v().newAssignStmt(defLocal, Jimple.v().newCastExpr(retObjLocal, type));
            setRetBody.getUnits().add(segStmt);
            AssignStmt assignStmt = Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(thisLocal, retField.makeRef()), defLocal);
            setRetBody.getUnits().add(assignStmt);
        } else {
            throw new RuntimeException("Unsupport set return result type: " + type);
        }
        return segStmt;
    }

    protected void genFrameClassFields(SootMethod origMethod, SootClass frameClass, Map local2FieldMap, Map field2LocalMap) {
        Body methodBody = origMethod.retrieveActiveBody();
        for (Local local : methodBody.getLocals()) {
            if (!this.isLocalNeededInFrame(local) || !origMethod.isStatic() && methodBody.getThisLocal() == local) continue;
            SootField sootField = new SootField(local.getName(), local.getType());
            frameClass.addField(sootField);
            local2FieldMap.put(local, sootField);
            field2LocalMap.put(sootField, local);
        }
        for (Stmt stmt : methodBody.getUnits()) {
            Local retLocal;
            InvokeExpr invokeExpr;
            if (!(stmt instanceof AssignStmt) || !stmt.containsInvokeExpr() || (invokeExpr = stmt.getInvokeExpr()) instanceof HjDistHere || !methodNameMap.containsKey(invokeExpr.getMethodRef().resolve().toString()) || local2FieldMap.containsKey(retLocal = (Local)((AssignStmt)stmt).getLeftOp())) continue;
            SootField field = new SootField(retLocal.getName(), retLocal.getType());
            frameClass.addField(field);
            local2FieldMap.put(retLocal, field);
            field2LocalMap.put(field, retLocal);
        }
    }

    public SootClass buildFrameClass(SootMethod origMethod, Map contMethodMap, HabAttrBox habBox, Map local2FieldMap, Map field2LocalMap) {
        SootClass declClass = origMethod.getDeclaringClass();
        SootMethod fcMethod = habBox.getFastClone();
        SootClass frameClass = new SootClass(declClass.getName() + "$" + origMethod.getName() + "frame", fcMethod.getModifiers());
        this.wsTool = new HjWSTool(origMethod.getActiveBody());
        frameClass.setOuterClass(declClass);
        frameClass.setSuperclass(Scene.v().getSootClass("hj.runtime.wst.adaptive.ActivationFrame"));
        Scene.v().addClass(frameClass);
        frameClass.setApplicationClass();
        this.genFrameClassFields(origMethod, frameClass, local2FieldMap, field2LocalMap);
        SootField frameThisOuter = null;
        if (!origMethod.isStatic()) {
            frameThisOuter = new SootField("this$0", declClass.getType());
        }
        SootMethod frameConMethod = this.buildFrameConSC(frameClass, declClass, fcMethod, origMethod, frameThisOuter, habBox, local2FieldMap);
        habBox.setFrameCon(frameConMethod);
        this.genFastClone(origMethod, frameClass, frameConMethod, contMethodMap, habBox);
        SootMethod frameExecMethod = this.buildFrameExecSlow(frameClass, declClass, fcMethod, habBox.getSlowClone(), frameThisOuter);
        this.buildSetReturn(frameClass, local2FieldMap, habBox);
        return frameClass;
    }

    public SootMethod buildFrameConSC(SootClass frameClass, SootClass declClass, SootMethod fcMethod, SootMethod origMethod, SootField frameThisOuter, HabAttrBox habBox, Map local2FieldMap) {
        ArrayList<RefType> paramTypeList = new ArrayList<RefType>();
        if (!origMethod.isStatic()) {
            paramTypeList.add(0, declClass.getType());
        }
        if (!habBox.isExecMethod()) {
            paramTypeList.addAll(origMethod.getParameterTypes());
        }
        SootMethod frameCon = new SootMethod("<init>", paramTypeList, VoidType.v(), 1);
        frameClass.addMethod(frameCon);
        JimpleBody conBody = Jimple.v().newBody(frameCon);
        frameCon.setActiveBody(conBody);
        LocalGenerator lg = new LocalGenerator(conBody);
        Local conThisLocal = lg.generateLocal("this", frameClass.getType());
        conBody.getUnits().add(Jimple.v().newIdentityStmt(conThisLocal, Jimple.v().newThisRef(frameClass.getType())));
        SootMethod superConMethod = frameClass.getSuperclass().getMethodByName("<init>");
        InvokeStmt superConStmt = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(conThisLocal, superConMethod.makeRef()));
        conBody.getUnits().add(superConStmt);
        int paramCounter = 0;
        InvokeStmt tempLabel = superConStmt;
        if (!origMethod.isStatic()) {
            frameClass.addField(frameThisOuter);
            Local outerThisLocal = lg.generateLocal(declClass.getType());
            IdentityStmt identityStmt = Jimple.v().newIdentityStmt(outerThisLocal, Jimple.v().newParameterRef(declClass.getType(), paramCounter++));
            conBody.getUnits().insertBefore(identityStmt, (Unit)tempLabel);
            AssignStmt assignStmt = Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(conThisLocal, frameThisOuter.makeRef()), outerThisLocal);
            conBody.getUnits().insertAfter(assignStmt, (Unit)tempLabel);
        }
        if (!habBox.isExecMethod()) {
            for (int i = 0; i < origMethod.getParameterCount(); ++i) {
                Local paramLocal = origMethod.getActiveBody().getParameterLocal(i + 1);
                SootField paramField = (SootField)local2FieldMap.get(paramLocal);
                Local conParamLocal = lg.generateLocal(paramLocal.getType());
                IdentityStmt identityStmt = Jimple.v().newIdentityStmt(conParamLocal, Jimple.v().newParameterRef(declClass.getType(), paramCounter++));
                conBody.getUnits().insertBefore(identityStmt, (Unit)tempLabel);
                AssignStmt assignStmt = Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(conThisLocal, paramField.makeRef()), conParamLocal);
                conBody.getUnits().insertAfter(assignStmt, (Unit)tempLabel);
            }
        }
        conBody.getUnits().add(Jimple.v().newReturnVoidStmt());
        return frameCon;
    }

    public SootMethod buildFrameExecSlow(SootClass frameClass, SootClass declClass, SootMethod fcMethod, SootMethod scMethod, SootField frameThisOuter) {
        SootMethod frameExecSlow = new SootMethod("execute", Arrays.asList(this.habHFWorker.getType()), VoidType.v(), 1);
        frameClass.addMethod(frameExecSlow);
        JimpleBody execBody = Jimple.v().newBody(frameExecSlow);
        frameExecSlow.setActiveBody(execBody);
        frameExecSlow.addException(this.habHFSpawnFrameStolenException);
        LocalGenerator lg = new LocalGenerator(execBody);
        Local execThis = Jimple.v().newLocal("this", frameClass.getType());
        execBody.getLocals().add(execThis);
        execBody.getUnits().add(Jimple.v().newIdentityStmt(execThis, Jimple.v().newThisRef(frameClass.getType())));
        Local worker = Jimple.v().newLocal("worker", this.habHFWorker.getType());
        execBody.getLocals().add(worker);
        execBody.getUnits().add(Jimple.v().newIdentityStmt(worker, Jimple.v().newParameterRef(this.habHFWorker.getType(), 0)));
        if (fcMethod.isStatic()) {
            InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(scMethod.makeRef(), worker, execBody.getThisLocal()));
            execBody.getUnits().add(invokeStmt);
        } else {
            Local outerObject = lg.generateLocal(declClass.getType());
            AssignStmt assignStmt = Jimple.v().newAssignStmt(outerObject, Jimple.v().newInstanceFieldRef(execThis, frameThisOuter.makeRef()));
            execBody.getUnits().add(assignStmt);
            InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(outerObject, scMethod.makeRef(), worker, execThis));
            execBody.getUnits().add(invokeStmt);
        }
        execBody.getUnits().add(Jimple.v().newReturnVoidStmt());
        return frameExecSlow;
    }

    public Local addLocalParamRefStmt(Body body, String name, Type paramType, int paramID) {
        Local newLocal = Jimple.v().newLocal(name, paramType);
        body.getLocals().add(newLocal);
        Stmt thisStmt = null;
        if (body.getUnits().size() > 0) {
            thisStmt = (Stmt)body.getUnits().getFirst();
        }
        if (thisStmt != null && thisStmt instanceof IdentityStmt && ((IdentityStmt)thisStmt).getRightOp() instanceof ThisRef) {
            body.getUnits().insertAfter(Jimple.v().newIdentityStmt(newLocal, Jimple.v().newParameterRef(paramType, paramID)), (Unit)thisStmt);
        } else {
            body.getUnits().addFirst(Jimple.v().newIdentityStmt(newLocal, Jimple.v().newParameterRef(paramType, paramID)));
        }
        return newLocal;
    }

    protected void incParamRef(SootMethod method) {
        Body body = method.getActiveBody();
        int paramCount = method.getParameterCount();
        Iterator<Unit> unitIter = body.getUnits().iterator();
        while (paramCount > 0) {
            IdentityStmt identityStmt;
            Value value;
            assert (unitIter.hasNext());
            Stmt stmt = (Stmt)unitIter.next();
            if (!(stmt instanceof IdentityStmt) || !((value = (identityStmt = (IdentityStmt)stmt).getRightOp()) instanceof ParameterRef)) continue;
            ParameterRef paramRef = (ParameterRef)value;
            paramRef.setIndex(paramRef.getIndex() + 1);
            --paramCount;
        }
    }

    protected void incParamRef(SootMethod method, int fromParam) {
        Body body = method.getActiveBody();
        for (Stmt stmt : body.getUnits()) {
            ParameterRef paramRef;
            IdentityStmt identityStmt;
            Value value;
            if (!(stmt instanceof IdentityStmt) || !((value = (identityStmt = (IdentityStmt)stmt).getRightOp()) instanceof ParameterRef) || (paramRef = (ParameterRef)value).getIndex() < fromParam) continue;
            paramRef.setIndex(paramRef.getIndex() + 1);
        }
    }

    public boolean isUserSpecifiedLocal(Local local) {
        return local.getName().charAt(0) != '$';
    }

    public boolean isThisParameter(Local local) {
        return local.getName().equals("this");
    }

    public boolean isThrowableObject(Local local) {
        return local.getType().equals(RefType.v("java.lang.Throwable"));
    }

    public boolean isLocalNeededInFrame(Local local) {
        if (this.isThisParameter(local)) {
            return false;
        }
        if (this.isThrowableObject(local)) {
            return false;
        }
        return local.getType() != this.habHFWorker.getType();
    }

    public Local addLocalAndParamRefStmt(Body body, String name, Type paramType, int paramNum) {
        Local newLocal = this.addLocal(body, name, paramType);
        this.addParamRefStmt(body, newLocal, paramType, paramNum);
        return newLocal;
    }

    public Local addLocalAndThisRefStmt(Body body, String name, RefType rType) {
        Local thisLocal = this.addLocal(body, name, rType);
        this.addThisRefStmt(body, thisLocal, rType);
        return thisLocal;
    }

    public Local addLocal(Body body, String name, Type type) {
        Local newLocal = Jimple.v().newLocal(name, type);
        body.getLocals().add(newLocal);
        return newLocal;
    }

    public void addParamRefStmt(Body body, Local leftOp, Type paramType, int paramNum) {
        Stmt thisStmt = null;
        if (body.getUnits().size() > 0) {
            thisStmt = (Stmt)body.getUnits().getFirst();
        }
        if (thisStmt != null && thisStmt instanceof IdentityStmt && ((IdentityStmt)thisStmt).getRightOp() instanceof ThisRef) {
            body.getUnits().insertAfter(Jimple.v().newIdentityStmt(leftOp, Jimple.v().newParameterRef(paramType, paramNum)), (Unit)thisStmt);
        } else {
            body.getUnits().addFirst(Jimple.v().newIdentityStmt(leftOp, Jimple.v().newParameterRef(paramType, paramNum)));
        }
    }

    public void addThisRefStmt(Body body, Local leftOp, RefType rType) {
        body.getUnits().addFirst(Jimple.v().newIdentityStmt(leftOp, Jimple.v().newThisRef(rType)));
    }
}

