/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.HjToJimple.jimple.RegionStmt;
import soot.HjToJimple.util.RSTNode;
import soot.Local;
import soot.Singletons;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.Jimple;
import soot.jimple.Stmt;

public class HjFEMotionTranslator
extends BodyTransformer {
    private HashSet usesSet = new HashSet();

    public HjFEMotionTranslator(Singletons.Global g) {
    }

    public static HjFEMotionTranslator v() {
        return G.v().soot_HjToJimple_jimple_HjFEMotionTranslator();
    }

    protected void internalTransform(Body body, String phaseName, Map opts) {
        SootMethod method = body.getMethod();
        this.hjFEMotionTransform(body, phaseName, opts);
    }

    private void hjFEMotionTransform(Body body, String phaseName, Map opts) {
        RSTNode rootNode = body.getMethod().getRSTNode();
        this.forEachMotion(rootNode, body);
    }

    private void forEachMotion(RSTNode rstNode, Body body) {
        Iterator<RSTNode> nodeIter = rstNode.getSubNodes().iterator();
        while (nodeIter.hasNext()) {
            this.forEachMotion(nodeIter.next(), body);
        }
        this.usesSet.clear();
        ArrayList<Stmt> motionStmts = null;
        if (rstNode.isForEachNode()) {
            RegionStmt entryStmt = rstNode.getRegionStmt();
            Stmt exitStmt = entryStmt.getConnect();
            Iterator<Unit> stmtIter = body.getUnits().iterator(entryStmt, exitStmt);
            while (stmtIter.hasNext()) {
                Stmt stmt = (Stmt)stmtIter.next();
                if (!(stmt instanceof AssignStmt)) continue;
                Value leftOp = ((AssignStmt)stmt).getLeftOp();
                Value rightOp = ((AssignStmt)stmt).getRightOp();
                if (!(rightOp instanceof FieldRef)) continue;
                SootField field = ((FieldRef)rightOp).getField();
                if (field.isStatic() && field.isFinal() && !this.usesSet.contains(leftOp)) {
                    if (motionStmts != null) {
                        motionStmts.add(stmt);
                        continue;
                    }
                    motionStmts = new ArrayList<Stmt>();
                    motionStmts.add(stmt);
                    continue;
                }
                Iterator<ValueBox> usesBoxIter = stmt.getUseBoxes().iterator();
                while (usesBoxIter.hasNext()) {
                    Value value = usesBoxIter.next().getValue();
                    if (!(value instanceof Local) || this.usesSet.contains(value)) continue;
                    this.usesSet.add(value);
                }
                Iterator<ValueBox> defsBoxIter = stmt.getDefBoxes().iterator();
                while (defsBoxIter.hasNext()) {
                    Value value = defsBoxIter.next().getValue();
                    if (!(value instanceof Local) || this.usesSet.contains(value)) continue;
                    this.usesSet.add(value);
                }
            }
            if (motionStmts != null) {
                Stmt predStmt = (Stmt)body.getUnits().getPredOf(entryStmt);
                Iterator motionStmtIter = motionStmts.iterator();
                while (stmtIter.hasNext()) {
                    Stmt motionStmt = (Stmt)motionStmtIter.next();
                    body.getUnits().insertAfter(Jimple.v().newNopStmt(), (Unit)motionStmt);
                    body.getUnits().remove(motionStmt);
                    body.getUnits().insertAfter(motionStmt, (Unit)predStmt);
                }
            }
        }
    }
}

