/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import soot.G;
import soot.HjToJimple.jimple.HabAttrBox;
import soot.HjToJimple.jimple.HabRTClassBuilder;
import soot.HjToJimple.jimple.HabRTWFClassBuilder;
import soot.HjToJimple.jimple.HjRSTTranslator;
import soot.HjToJimple.jimple.HjRedundantAsyncElim;
import soot.HjToJimple.jimple.TargetedHjRuntime;
import soot.HjToJimple.util.RSTNode;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.JimpleBody;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjWSTranslator
extends SceneTransformer {
    protected ArrayList<SootClass> extraClasses = new ArrayList();
    protected HabRTClassBuilder habRTClassBuilder;

    public HjWSTranslator(Singletons.Global g) {
    }

    public static HjWSTranslator v() {
        return G.v().soot_HjToJimple_jimple_HjWSTranslator();
    }

    @Override
    protected void internalTransform(String phaseName, Map opts) {
        HjRedundantAsyncElim.v().raeTransform();
        if (TargetedHjRuntime.isRuntimeWorkStealingWorkFirst()) {
            this.habRTClassBuilder = HabRTWFClassBuilder.v();
        } else if (TargetedHjRuntime.isRuntimeWorkStealingHelpFirst()) {
            this.habRTClassBuilder = HabRTClassBuilder.v();
        } else {
            throw new RuntimeException("Unrecognized work-stealing code generation policy");
        }
        this.hjWSTransform(phaseName, opts);
    }

    protected void hjWSTransform(String phaseName, Map opts) {
        HashSet<SootMethod> appMethodSet = new HashSet<SootMethod>();
        HashMap<SootMethod, HabAttrBox> contMethodMap = new HashMap<SootMethod, HabAttrBox>();
        HashSet<SootMethod> methodContSet = new HashSet<SootMethod>();
        this.collectAppMethods(appMethodSet);
        this.rebuildRST(appMethodSet);
        int size = 0;
        do {
            size = contMethodMap.keySet().size();
            this.collectContMethods(appMethodSet, contMethodMap, methodContSet);
            this.collectAbstractConts(contMethodMap);
        } while (size == contMethodMap.keySet().size());
        this.extractAsyncs(contMethodMap);
        HashMap local2FieldMap = new HashMap();
        HashMap field2LocalMap = new HashMap();
        HabAttrBox mainHabBox = null;
        for (SootMethod method : contMethodMap.keySet()) {
            if (!method.isConcrete()) continue;
            HabAttrBox habBox = contMethodMap.get(method);
            if (method.getSubSignature().equals("void main(java.lang.String[])")) {
                mainHabBox = habBox;
            }
            if (this.habRTClassBuilder.hasContinuation(method.getRSTNode(), contMethodMap, false) || habBox.isExecMethod()) {
                // empty if block
            }
            if (habBox.isExecMethod()) {
                HjRSTTranslator.v().rebuildRST(method.retrieveActiveBody(), null, null);
                if (!TargetedHjRuntime.isRuntimeWorkStealingAdaptive() || !this.habRTClassBuilder.hasAsync(method.getRSTNode())) {
                    // empty if block
                }
            }
            local2FieldMap.clear();
            field2LocalMap.clear();
            SootClass frameClass = this.habRTClassBuilder.buildFrameClass(method, contMethodMap, habBox, local2FieldMap, field2LocalMap);
            habBox.setFrameClass(frameClass);
        }
        this.cleanMethods(contMethodMap);
        this.refineNoContMethods(appMethodSet, contMethodMap);
    }

    protected void extractAsyncs(HashMap<SootMethod, HabAttrBox> contMethodMap) {
        Iterator<SootMethod> methodIter = contMethodMap.keySet().iterator();
        ArrayList<SootMethod> methodList = new ArrayList<SootMethod>();
        while (methodIter.hasNext()) {
            methodList.add(methodIter.next());
        }
        methodIter = methodList.iterator();
        int methodCounter = 0;
        while (methodIter.hasNext()) {
            SootMethod method = methodIter.next();
            if (!method.isConcrete()) continue;
            this.habRTClassBuilder.identityLocals(method);
            this.habRTClassBuilder.extractAsync(method, method, method.getRSTNode(), contMethodMap, methodCounter += 10);
        }
    }

    protected void cleanMethods(HashMap<SootMethod, HabAttrBox> contMethodMap) {
        for (SootMethod method : contMethodMap.keySet()) {
            HabAttrBox habBox = contMethodMap.get(method);
            if (habBox.isExecMethod()) continue;
            method.releaseActiveBody();
            method.getDeclaringClass().removeMethod(method);
        }
    }

    protected void rebuildRST(HashSet<SootMethod> appMethodSet) {
        Iterator<SootMethod> methodIter = appMethodSet.iterator();
        while (methodIter.hasNext()) {
            HjRSTTranslator.v().rebuildRST(methodIter.next().retrieveActiveBody(), null, null);
        }
    }

    protected void collectAppMethods(HashSet<SootMethod> appMethodSet) {
        for (SootClass appClass : Scene.v().getApplicationClasses()) {
            ListIterator<SootMethod> methodIter = appClass.getMethods().listIterator();
            while (methodIter.hasNext()) {
                SootMethod method = (SootMethod)methodIter.next();
                if (method.getName().startsWith("<init>") || !method.hasActiveBody() || this.isConcreteMethod(method, appClass.getSuperclass())) continue;
                appMethodSet.add(method);
            }
        }
    }

    protected void collectAbstractConts(HashMap<SootMethod, HabAttrBox> contMethodMap) {
        HashMap<SootMethod, HabAttrBox> tmpContMap = new HashMap<SootMethod, HabAttrBox>();
        for (SootMethod method : contMethodMap.keySet()) {
            Iterator<SootClass> interfaceIter = method.getDeclaringClass().getInterfaces().iterator();
            while (interfaceIter.hasNext()) {
                this.checkInterfaces(interfaceIter.next(), method, tmpContMap);
            }
            this.checkInterfaces(method.getDeclaringClass().getSuperclass(), method, tmpContMap);
        }
        contMethodMap.putAll(tmpContMap);
    }

    protected void checkInterfaces(SootClass interfaceClass, SootMethod method, HashMap<SootMethod, HabAttrBox> tmpContMap) {
        if (interfaceClass.declaresMethodByName(method.getName()) && (interfaceClass.isInterface() || interfaceClass.isAbstract())) {
            try {
                SootMethod abstractMethod = interfaceClass.getMethod(method.getName(), method.getParameterTypes());
                int modifiers = abstractMethod.getModifiers();
                ArrayList<RefType> typeList = new ArrayList<RefType>();
                typeList.add(HabRTClassBuilder.v().habHFWorker.getType());
                typeList.addAll(method.getParameterTypes());
                SootMethod newMethod = new SootMethod(method.getName(), typeList, method.getReturnType(), modifiers);
                newMethod.setDeclaringClass(interfaceClass);
                interfaceClass.addMethod(newMethod);
                HabAttrBox habBox = new HabAttrBox();
                habBox.setFastClone(newMethod);
                tmpContMap.put(abstractMethod, habBox);
                HabRTClassBuilder.v().addContMethod(abstractMethod);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void refineNoContMethods(HashSet<SootMethod> appMethodSet, HashMap<SootMethod, HabAttrBox> contMethodMap) {
        for (SootMethod method : appMethodSet) {
            SootClass declClass;
            if (contMethodMap.containsKey(method) || (declClass = method.getDeclaringClass()).getInterfaces().size() == 0 && !declClass.getSuperclass().isAbstract()) continue;
            ArrayList<RefType> typeList = new ArrayList<RefType>();
            typeList.add(HabRTClassBuilder.v().habHFWorker.getType());
            typeList.addAll(method.getParameterTypes());
            boolean reset = false;
            for (SootClass interfaceClass : declClass.getInterfaces()) {
                if (!interfaceClass.declaresMethod(method.getName(), typeList, method.getReturnType())) continue;
                this.createFakeMethod(declClass, typeList, method);
                reset = true;
                break;
            }
            if (reset) continue;
            typeList = new ArrayList();
            typeList.add(HabRTClassBuilder.v().habHFWorker.getType());
            typeList.addAll(method.getParameterTypes());
            SootClass superClass = declClass.getSuperclass();
            if (!superClass.declaresMethod(method.getName(), typeList, method.getReturnType())) continue;
            this.createFakeMethod(declClass, typeList, method);
        }
    }

    protected void createFakeMethod(SootClass declClass, ArrayList typeList, SootMethod method) {
        SootMethod fakeMethod = new SootMethod(method.getName(), typeList, method.getReturnType(), method.getModifiers());
        fakeMethod.setDeclaringClass(declClass);
        declClass.addMethod(fakeMethod);
        JimpleBody methodBody = (JimpleBody)method.getActiveBody().clone();
        fakeMethod.setActiveBody(methodBody);
    }

    protected void collectContMethods(HashSet<SootMethod> appMethodSet, HashMap<SootMethod, HabAttrBox> contMethodMap, HashSet<SootMethod> methodContSet) {
        for (SootMethod method : appMethodSet) {
            SootMethod fcMethod;
            HabAttrBox habBox;
            if (contMethodMap.containsKey(method)) continue;
            if (appMethodSet.contains(method) && this.checkFinishAsync(method.getRSTNode())) {
                habBox = new HabAttrBox();
                fcMethod = this.habRTClassBuilder.createFCMethod(method, habBox);
                habBox.setFastClone(fcMethod);
                contMethodMap.put(method, habBox);
                methodContSet.add(method);
                continue;
            }
            if (!method.getSubSignature().equals("void main(java.lang.String[])")) continue;
            habBox = new HabAttrBox();
            fcMethod = this.habRTClassBuilder.createFCMethod(method, habBox);
            habBox.setFastClone(fcMethod);
            contMethodMap.put(method, habBox);
            methodContSet.add(method);
        }
        CallGraph cg = Scene.v().getCallGraph();
        boolean change = true;
        while (change) {
            change = false;
            block2: for (SootMethod method : appMethodSet) {
                if (contMethodMap.containsKey(method)) continue;
                Iterator<Edge> edgeIter = cg.edgesOutOf(method);
                while (edgeIter.hasNext()) {
                    Edge edge = edgeIter.next();
                    if (!contMethodMap.containsKey(edge.tgt())) continue;
                    HabAttrBox habBox = new HabAttrBox();
                    SootMethod fcMethod = this.habRTClassBuilder.createFCMethod(method, habBox);
                    habBox.setFastClone(fcMethod);
                    contMethodMap.put(method, habBox);
                    change = true;
                    continue block2;
                }
            }
        }
    }

    protected boolean checkFinishAsync(RSTNode rstNode) {
        return this.habRTClassBuilder.hasContinuation(rstNode, false);
    }

    protected boolean isConcreteMethod(SootMethod method, SootClass checkClass) {
        if (checkClass.declaresMethod(method.getSubSignature())) {
            return checkClass.getMethod(method.getSubSignature()).isConcrete();
        }
        return false;
    }
}

