/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple.ext.complex;

import soot.ArrayType;
import soot.ComplexDoubleType;
import soot.ComplexFloatType;
import soot.DoubleType;
import soot.FloatType;
import soot.HjToJimple.jimple.HjArrayViewConstructor;
import soot.HjToJimple.jimple.utils.ArrayViewUtils;
import soot.Type;
import soot.Value;
import soot.jimple.ComplexDoubleConstant;
import soot.jimple.ComplexFloatConstant;

public class ComplexUtils {
    public static boolean isComplex(Type type) {
        return ComplexUtils.isComplexFloatType(type) || ComplexUtils.isComplexDoubleType(type);
    }

    public static boolean isComplexDoubleType(Type type) {
        return type instanceof ComplexDoubleType;
    }

    public static boolean isComplexFloatType(Type type) {
        return type instanceof ComplexFloatType;
    }

    public static boolean isComplexConstant(Value v) {
        return ComplexUtils.isComplexFloatConstant(v) || ComplexUtils.isComplexDoubleConstant(v);
    }

    public static boolean isComplexFloatConstant(Value v) {
        return v instanceof ComplexFloatConstant;
    }

    public static boolean isComplexDoubleConstant(Value v) {
        return v instanceof ComplexDoubleConstant;
    }

    public static boolean isComplex(Value value) {
        Type type = value.getType();
        return ComplexUtils.isComplex(type);
    }

    public static boolean isComplex(ArrayType arrayType) {
        return ComplexUtils.isComplex(arrayType.baseType);
    }

    public static boolean isComplexArrayView(HjArrayViewConstructor arrayType) {
        return ComplexUtils.isComplexArrayView(arrayType.getType());
    }

    public static boolean isComplexArrayView(Type type) {
        return ArrayViewUtils.isComplexArrayView(type);
    }

    public static Type getComplexBaseType(Type complexType) {
        if (ComplexUtils.isComplexFloatType(complexType)) {
            return FloatType.v();
        }
        if (ComplexUtils.isComplexDoubleType(complexType)) {
            return DoubleType.v();
        }
        throw new RuntimeException("Trying to get complex base type from non complex type: " + complexType);
    }

    public static Type getComplexBaseType(Value value) {
        return ComplexUtils.getComplexBaseType(value.getType());
    }

    public static Type getComplexBaseType(ArrayType complexType) {
        return ComplexUtils.getComplexBaseType(complexType.baseType);
    }
}

