/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.ArrayList;
import soot.ArrayType;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Access;
import soot.JastAddJ.ArrayInit;
import soot.JastAddJ.ArrayTypeAccess;
import soot.JastAddJ.ArrayTypeWithSizeAccess;
import soot.JastAddJ.Body;
import soot.JastAddJ.NameType;
import soot.JastAddJ.Opt;
import soot.JastAddJ.PrimaryExpr;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.Value;
import soot.jimple.Jimple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayCreationExpr
extends PrimaryExpr
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;
    protected boolean numArrays_computed = false;
    protected int numArrays_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
        this.numArrays_computed = false;
    }

    @Override
    public ArrayCreationExpr clone() throws CloneNotSupportedException {
        ArrayCreationExpr node = (ArrayCreationExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.numArrays_computed = false;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ArrayCreationExpr copy() {
        try {
            ArrayCreationExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ArrayCreationExpr fullCopy() {
        ArrayCreationExpr res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
        }
        return res;
    }

    @Override
    public void toString(StringBuffer s) {
        s.append("new ");
        this.getTypeAccess().toString(s);
        if (this.hasArrayInit()) {
            this.getArrayInit().toString(s);
        }
    }

    @Override
    public Value eval(Body b) {
        if (this.hasArrayInit()) {
            return this.getArrayInit().eval(b);
        }
        ArrayList list = new ArrayList();
        this.getTypeAccess().addArraySize(b, list);
        if (this.numArrays() == 1) {
            Value size = (Value)list.get(0);
            return Jimple.v().newNewArrayExpr(this.type().componentType().getSootType(), this.asImmediate(b, size));
        }
        return Jimple.v().newNewMultiArrayExpr((ArrayType)this.type().getSootType(), list);
    }

    public ArrayCreationExpr() {
        this.setChild(new Opt(), 1);
    }

    public ArrayCreationExpr(Access p0, Opt<ArrayInit> p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setTypeAccess(Access node) {
        this.setChild(node, 0);
    }

    public Access getTypeAccess() {
        return (Access)this.getChild(0);
    }

    public Access getTypeAccessNoTransform() {
        return (Access)this.getChildNoTransform(0);
    }

    public void setArrayInitOpt(Opt<ArrayInit> opt) {
        this.setChild(opt, 1);
    }

    public boolean hasArrayInit() {
        return this.getArrayInitOpt().getNumChild() != 0;
    }

    public ArrayInit getArrayInit() {
        return (ArrayInit)this.getArrayInitOpt().getChild(0);
    }

    public void setArrayInit(ArrayInit node) {
        this.getArrayInitOpt().setChild(node, 0);
    }

    public Opt<ArrayInit> getArrayInitOpt() {
        return (Opt)this.getChild(1);
    }

    public Opt<ArrayInit> getArrayInitOptNoTransform() {
        return (Opt)this.getChildNoTransform(1);
    }

    public boolean isDAafterCreation(Variable v) {
        boolean isDAafterCreation_Variable_value = this.isDAafterCreation_compute(v);
        return isDAafterCreation_Variable_value;
    }

    private boolean isDAafterCreation_compute(Variable v) {
        return this.getTypeAccess().isDAafter(v);
    }

    @Override
    public boolean isDAafter(Variable v) {
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.hasArrayInit() ? this.getArrayInit().isDAafter(v) : this.isDAafterCreation(v);
    }

    public boolean isDUafterCreation(Variable v) {
        boolean isDUafterCreation_Variable_value = this.isDUafterCreation_compute(v);
        return isDUafterCreation_Variable_value;
    }

    private boolean isDUafterCreation_compute(Variable v) {
        return this.getTypeAccess().isDUafter(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.hasArrayInit() ? this.getArrayInit().isDUafter(v) : this.isDUafterCreation(v);
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.getTypeAccess().type();
    }

    public int numArrays() {
        if (this.numArrays_computed) {
            return this.numArrays_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.numArrays_value = this.numArrays_compute();
        if (isFinal && num == boundariesCrossed) {
            this.numArrays_computed = true;
        }
        return this.numArrays_value;
    }

    private int numArrays_compute() {
        int i = this.type().dimension();
        Access a = this.getTypeAccess();
        while (a instanceof ArrayTypeAccess && !(a instanceof ArrayTypeWithSizeAccess)) {
            --i;
            a = ((ArrayTypeAccess)a).getAccess();
        }
        return i;
    }

    @Override
    public TypeDecl Define_TypeDecl_expectedType(ASTNode caller, ASTNode child) {
        if (caller == this.getArrayInitOptNoTransform()) {
            return this.type().componentType();
        }
        return this.getParent().Define_TypeDecl_expectedType(this, caller);
    }

    @Override
    public TypeDecl Define_TypeDecl_declType(ASTNode caller, ASTNode child) {
        if (caller == this.getArrayInitOptNoTransform()) {
            return this.type();
        }
        return this.getParent().Define_TypeDecl_declType(this, caller);
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getTypeAccessNoTransform()) {
            return NameType.TYPE_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getArrayInitOptNoTransform()) {
            return this.isDAafterCreation(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getArrayInitOptNoTransform()) {
            return this.isDUafterCreation(v);
        }
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

