/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.Immediate;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.AssignAdditiveExpr;
import soot.JastAddJ.Body;
import soot.JastAddJ.Expr;
import soot.JastAddJ.TypeDecl;
import soot.Local;
import soot.Scene;
import soot.Value;
import soot.jimple.Jimple;

public class AssignPlusExpr
extends AssignAdditiveExpr
implements Cloneable {
    public void flushCache() {
        super.flushCache();
    }

    public AssignPlusExpr clone() throws CloneNotSupportedException {
        AssignPlusExpr node = (AssignPlusExpr)super.clone();
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public AssignPlusExpr copy() {
        try {
            AssignPlusExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public AssignPlusExpr fullCopy() {
        AssignPlusExpr res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
        }
        return res;
    }

    public void typeCheck() {
        if (!this.getDest().isVariable()) {
            this.error("left hand side is not a variable");
        } else {
            if (this.getSource().type().isUnknown() || this.getDest().type().isUnknown()) {
                return;
            }
            if (this.getDest().type().isString() && !this.getSource().type().isVoid()) {
                return;
            }
            if (this.getSource().type().isBoolean() || this.getDest().type().isBoolean()) {
                this.error("Operator + does not operate on boolean types");
            } else {
                if (this.getSource().type().isPrimitive() && this.getDest().type().isPrimitive()) {
                    return;
                }
                this.error("can not assign " + this.getDest() + " of type " + this.getDest().type().typeName() + " a value of type " + this.sourceType().typeName());
            }
        }
    }

    public Value eval(Body b) {
        TypeDecl dest = this.getDest().type();
        TypeDecl source = this.getSource().type();
        if (dest.isString()) {
            Value lvalue = this.getDest().eval(b);
            Immediate v = this.asImmediate(b, lvalue);
            Local local = b.newTemp(Jimple.v().newNewExpr(this.lookupType("java.lang", "StringBuffer").sootRef()));
            b.setLine(this);
            b.add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(local, Scene.v().getMethod("<java.lang.StringBuffer: void <init>(java.lang.String)>").makeRef(), v)));
            Local rightResult = b.newTemp(Jimple.v().newVirtualInvokeExpr(local, this.lookupType("java.lang", "StringBuffer").methodWithArgs("append", new TypeDecl[]{source.stringPromotion()}).sootRef(), this.asImmediate(b, this.getSource().eval(b))));
            Local result = b.newTemp(Jimple.v().newVirtualInvokeExpr(rightResult, Scene.v().getMethod("<java.lang.StringBuffer: java.lang.String toString()>").makeRef()));
            Value v2 = lvalue instanceof Local ? lvalue : (Value)lvalue.clone();
            this.getDest().emitStore(b, v2, result);
            return result;
        }
        return super.eval(b);
    }

    public Value createAssignOp(Body b, Value fst, Value snd) {
        return Jimple.v().newAddExpr(this.asImmediate(b, fst), this.asImmediate(b, snd));
    }

    public AssignPlusExpr() {
    }

    public AssignPlusExpr(Expr p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    protected int numChildren() {
        return 2;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setDest(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getDest() {
        return (Expr)this.getChild(0);
    }

    public Expr getDestNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public void setSource(Expr node) {
        this.setChild(node, 1);
    }

    public Expr getSource() {
        return (Expr)this.getChild(1);
    }

    public Expr getSourceNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    public String printOp() {
        String printOp_value = this.printOp_compute();
        return printOp_value;
    }

    private String printOp_compute() {
        return " += ";
    }

    public TypeDecl sourceType() {
        TypeDecl sourceType_value = this.sourceType_compute();
        return sourceType_value;
    }

    private TypeDecl sourceType_compute() {
        TypeDecl left = this.getDest().type();
        TypeDecl right = this.getSource().type();
        if (!left.isString() && !right.isString()) {
            return super.sourceType();
        }
        if (left.isVoid() || right.isVoid()) {
            return this.unknownType();
        }
        return left.isString() ? left : right;
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

