/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.ArrayList;
import java.util.Stack;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.TypeDecl;
import soot.Local;
import soot.PatchingChain;
import soot.Type;
import soot.Value;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.tagkit.LineNumberTag;

public class Body {
    int nextTempIndex = 0;
    JimpleBody body;
    Stack chains;
    TypeDecl typeDecl;
    private LineNumberTag lineTag;
    Local thisName;
    ArrayList list = null;

    public Body(TypeDecl typeDecl, JimpleBody body, ASTNode container2) {
        this.typeDecl = typeDecl;
        this.body = body;
        this.chains = new Stack();
        this.chains.push(body.getUnits());
        this.setLine(container2);
        if (!body.getMethod().isStatic()) {
            this.emitThis(typeDecl);
        }
    }

    public Local getParam(int i) {
        return this.body.getParameterLocal(i);
    }

    public Local newTemp(Type type) {
        Local local = Jimple.v().newLocal("temp$" + this.nextTempIndex++, type);
        this.body.getLocals().add(local);
        return local;
    }

    public Local newTemp(Value v) {
        if (v == NullConstant.v()) {
            throw new UnsupportedOperationException("Cannot create a temporary local for null literal");
        }
        Local local = this.newTemp(v.getType());
        if (v instanceof ParameterRef) {
            this.add(Jimple.v().newIdentityStmt(local, (ParameterRef)v));
        } else {
            this.add(Jimple.v().newAssignStmt(local, v));
        }
        return local;
    }

    public Local newLocal(String name, Type type) {
        Local local = Jimple.v().newLocal(name, type);
        this.body.getLocals().add(local);
        if (name.equals("this") && this.thisName == null) {
            this.thisName = local;
        }
        return local;
    }

    public void setLine(ASTNode node) {
        this.lineTag = new LineNumberTag(node.lineNumber());
    }

    private LineNumberTag currentSourceRangeTag() {
        return this.lineTag;
    }

    public Body add(Stmt stmt) {
        IdentityStmt idstmt;
        if (this.list != null) {
            this.list.add(stmt);
            this.list = null;
        }
        stmt.addTag(this.currentSourceRangeTag());
        PatchingChain chain = (PatchingChain)this.chains.peek();
        if (stmt instanceof IdentityStmt && chain.size() != 0 && !((idstmt = (IdentityStmt)stmt).getRightOp() instanceof CaughtExceptionRef)) {
            Object s = chain.getFirst();
            while (s instanceof IdentityStmt) {
                s = chain.getSuccOf(s);
            }
            if (s != null) {
                chain.insertBefore(stmt, s);
                return this;
            }
        }
        chain.add(stmt);
        return this;
    }

    public void pushBlock(PatchingChain c) {
        this.chains.push(c);
    }

    public void popBlock() {
        this.chains.pop();
    }

    public Stmt newLabel() {
        return Jimple.v().newNopStmt();
    }

    public Body addLabel(Stmt label) {
        this.add(label);
        return this;
    }

    public Local emitThis(TypeDecl typeDecl) {
        if (this.thisName == null) {
            this.thisName = this.newLocal("this", typeDecl.getSootType());
            if (this.body.getMethod().isStatic()) {
                this.add(Jimple.v().newIdentityStmt(this.thisName, Jimple.v().newParameterRef(typeDecl.getSootType(), 0)));
            } else {
                this.add(Jimple.v().newIdentityStmt(this.thisName, Jimple.v().newThisRef(typeDecl.sootRef())));
            }
        }
        return this.thisName;
    }

    public Body addTrap(TypeDecl type, Stmt firstStmt, Stmt lastStmt, Stmt handler) {
        this.body.getTraps().add(Jimple.v().newTrap(type.getSootClassDecl(), firstStmt, lastStmt, handler));
        return this;
    }

    public Stmt previousStmt() {
        PatchingChain o = (PatchingChain)this.chains.lastElement();
        return (Stmt)o.getLast();
    }

    public void addNextStmt(ArrayList list) {
        this.list = list;
    }
}

