/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Body;
import soot.JastAddJ.Constant;
import soot.JastAddJ.Literal;
import soot.JastAddJ.TypeDecl;
import soot.Value;
import soot.jimple.DoubleConstant;

public class DoubleLiteral
extends Literal
implements Cloneable {
    public int LITERALstart;
    public int LITERALend;
    protected boolean isZero_computed = false;
    protected boolean isZero_value;
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    public void flushCache() {
        super.flushCache();
        this.isZero_computed = false;
        this.constant_computed = false;
        this.constant_value = null;
        this.type_computed = false;
        this.type_value = null;
    }

    public DoubleLiteral clone() throws CloneNotSupportedException {
        DoubleLiteral node = (DoubleLiteral)super.clone();
        node.isZero_computed = false;
        node.constant_computed = false;
        node.constant_value = null;
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public DoubleLiteral copy() {
        try {
            DoubleLiteral node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public DoubleLiteral fullCopy() {
        DoubleLiteral res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
        }
        return res;
    }

    public void toString(StringBuffer s) {
        s.append(this.getLITERAL());
        s.append("D");
    }

    public void typeCheck() {
        if (!this.isZero() && this.constant().doubleValue() == 0.0) {
            this.error("It is an error for nonzero floating-point " + this.getLITERAL() + " to round to zero");
        }
        if (this.constant().doubleValue() == Double.NEGATIVE_INFINITY || this.constant().doubleValue() == Double.POSITIVE_INFINITY) {
            this.error("It is an error for floating-point " + this.getLITERAL() + " to round to an infinity");
        }
    }

    public Value eval(Body b) {
        return DoubleConstant.v(this.constant().doubleValue());
    }

    public DoubleLiteral() {
    }

    public DoubleLiteral(String p0) {
        this.setLITERAL(p0);
    }

    public DoubleLiteral(Symbol p0) {
        this.setLITERAL(p0);
    }

    protected int numChildren() {
        return 0;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setLITERAL(String value) {
        this.tokenString_LITERAL = value;
    }

    public void setLITERAL(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLITERAL is only valid for String lexemes");
        }
        this.tokenString_LITERAL = (String)symbol.value;
        this.LITERALstart = symbol.getStart();
        this.LITERALend = symbol.getEnd();
    }

    public String getLITERAL() {
        return this.tokenString_LITERAL != null ? this.tokenString_LITERAL : "";
    }

    public boolean isZero() {
        if (this.isZero_computed) {
            return this.isZero_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isZero_value = this.isZero_compute();
        if (isFinal && num == boundariesCrossed) {
            this.isZero_computed = true;
        }
        return this.isZero_value;
    }

    private boolean isZero_compute() {
        char c;
        String s = this.getLITERAL();
        for (int i = 0; i < s.length() && (c = s.charAt(i)) != 'E' && c != 'e'; ++i) {
            if (!Character.isDigit(c) || c == '0') continue;
            return false;
        }
        return true;
    }

    public Constant constant() {
        if (this.constant_computed) {
            return this.constant_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.constant_value = this.constant_compute();
        if (isFinal && num == boundariesCrossed) {
            this.constant_computed = true;
        }
        return this.constant_value;
    }

    private Constant constant_compute() {
        try {
            return Constant.create(Double.parseDouble(this.getLITERAL()));
        }
        catch (NumberFormatException e) {
            Constant c = Constant.create(0.0);
            c.error = true;
            return c;
        }
    }

    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeDouble();
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

