/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.BytecodeReader;
import soot.JastAddJ.CompilationUnit;
import soot.JastAddJ.JavaParser;
import soot.JastAddJ.Program;

public class Frontend {
    protected Program program;

    protected Frontend() {
        ASTNode.reset();
        this.program = new Program();
    }

    public boolean process(String[] args, BytecodeReader reader, JavaParser parser) {
        this.program.initBytecodeReader(reader);
        this.program.initJavaParser(parser);
        this.initOptions();
        this.processArgs(args);
        Collection files = this.program.files();
        if (Program.hasOption("-version")) {
            this.printVersion();
            return false;
        }
        if (Program.hasOption("-help") || files.isEmpty()) {
            this.printUsage();
            return false;
        }
        try {
            for (String name : files) {
                if (!new File(name).exists()) {
                    System.out.println("WARNING: file \"" + name + "\" does not exist");
                }
                this.program.addSourceFile(name);
            }
            Iterator iter = this.program.compilationUnitIterator();
            while (iter.hasNext()) {
                LinkedList warnings;
                Collection errors;
                CompilationUnit unit;
                block12: {
                    block11: {
                        unit = (CompilationUnit)iter.next();
                        if (!unit.fromSource()) continue;
                        errors = unit.parseErrors();
                        warnings = new LinkedList();
                        if (errors.isEmpty()) break block11;
                        if (!Program.hasOption("-recover")) break block12;
                    }
                    unit.errorCheck(errors, warnings);
                }
                if (!errors.isEmpty()) {
                    this.processErrors(errors, unit);
                    return false;
                }
                this.processWarnings(warnings, unit);
                this.processNoErrors(unit);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        return true;
    }

    protected void initOptions() {
        Frontend frontend = this;
        frontend.program.initOptions();
        this.program.addKeyOption("-version");
        this.program.addKeyOption("-print");
        this.program.addKeyOption("-g");
        this.program.addKeyOption("-g:none");
        this.program.addKeyOption("-g:lines,vars,source");
        this.program.addKeyOption("-nowarn");
        this.program.addKeyOption("-verbose");
        this.program.addKeyOption("-deprecation");
        this.program.addKeyValueOption("-classpath");
        this.program.addKeyValueOption("-sourcepath");
        this.program.addKeyValueOption("-bootclasspath");
        this.program.addKeyValueOption("-extdirs");
        this.program.addKeyValueOption("-d");
        this.program.addKeyValueOption("-encoding");
        this.program.addKeyValueOption("-source");
        this.program.addKeyValueOption("-target");
        this.program.addKeyOption("-help");
        this.program.addKeyOption("-O");
        this.program.addKeyOption("-J-Xmx128M");
        this.program.addKeyOption("-recover");
    }

    protected void processArgs(String[] args) {
        this.program.addOptions(args);
    }

    protected void processErrors(Collection errors, CompilationUnit unit) {
        System.out.println("Errors:");
        Iterator iter2 = errors.iterator();
        while (iter2.hasNext()) {
            System.out.println(iter2.next());
        }
    }

    protected void processWarnings(Collection warnings, CompilationUnit unit) {
        Iterator iter2 = warnings.iterator();
        while (iter2.hasNext()) {
            System.out.println(iter2.next());
        }
    }

    protected void processNoErrors(CompilationUnit unit) {
    }

    protected void printUsage() {
        this.printVersion();
        System.out.println("\n" + this.name() + "\n\n" + "Usage: java " + this.name() + " <options> <source files>\n" + "  -verbose                  Output messages about what the compiler is doing\n" + "  -classpath <path>         Specify where to find user class files\n" + "  -sourcepath <path>        Specify where to find input source files\n" + "  -bootclasspath <path>     Override location of bootstrap class files\n" + "  -extdirs <dirs>           Override location of installed extensions\n" + "  -d <directory>            Specify where to place generated class files\n" + "  -help                     Print a synopsis of standard options\n" + "  -version                  Print version information\n");
    }

    protected void printVersion() {
        System.out.println(this.name() + " " + this.url() + " Version " + this.version());
    }

    protected String name() {
        return "Java1.4Frontend";
    }

    protected String url() {
        return "(http://jastadd.cs.lth.se)";
    }

    protected String version() {
        return "R20070504";
    }
}

