/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Access;
import soot.JastAddJ.ClassInstanceExpr;
import soot.JastAddJ.NameType;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.TypeDecl;

public class PackageAccess
extends Access
implements Cloneable {
    protected String tokenString_Package;
    public int Packagestart;
    public int Packageend;

    public void flushCache() {
        super.flushCache();
    }

    public PackageAccess clone() throws CloneNotSupportedException {
        PackageAccess node = (PackageAccess)super.clone();
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public PackageAccess copy() {
        try {
            PackageAccess node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public PackageAccess fullCopy() {
        PackageAccess res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
        }
        return res;
    }

    public void nameCheck() {
        if (!this.hasPackage(this.packageName())) {
            this.error(this.packageName() + " not found");
        }
    }

    public PackageAccess(String name, int start, int end) {
        this(name);
        this.start = start;
        this.end = end;
    }

    public void toString(StringBuffer s) {
        s.append(this.getPackage());
    }

    public PackageAccess() {
    }

    public PackageAccess(String p0) {
        this.setPackage(p0);
    }

    public PackageAccess(Symbol p0) {
        this.setPackage(p0);
    }

    protected int numChildren() {
        return 0;
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public void setPackage(String value) {
        this.tokenString_Package = value;
    }

    public void setPackage(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setPackage is only valid for String lexemes");
        }
        this.tokenString_Package = (String)symbol.value;
        this.Packagestart = symbol.getStart();
        this.Packageend = symbol.getEnd();
    }

    public String getPackage() {
        return this.tokenString_Package != null ? this.tokenString_Package : "";
    }

    public boolean hasQualifiedPackage(String packageName) {
        boolean hasQualifiedPackage_String_value = this.hasQualifiedPackage_compute(packageName);
        return hasQualifiedPackage_String_value;
    }

    private boolean hasQualifiedPackage_compute(String packageName) {
        return this.hasPackage(this.packageName() + "." + packageName);
    }

    public SimpleSet qualifiedLookupType(String name) {
        SimpleSet qualifiedLookupType_String_value = this.qualifiedLookupType_compute(name);
        return qualifiedLookupType_String_value;
    }

    private SimpleSet qualifiedLookupType_compute(String name) {
        SimpleSet c = SimpleSet.emptySet;
        TypeDecl typeDecl = this.lookupType(this.packageName(), name);
        if (this.nextAccess() instanceof ClassInstanceExpr) {
            if (typeDecl != null && typeDecl.accessibleFrom(this.hostType())) {
                c = c.add(typeDecl);
            }
            return c;
        }
        if (typeDecl != null) {
            if (this.hostType() != null && typeDecl.accessibleFrom(this.hostType())) {
                c = c.add(typeDecl);
            } else if (this.hostType() == null && typeDecl.accessibleFromPackage(this.hostPackage())) {
                c = c.add(typeDecl);
            }
        }
        return c;
    }

    public SimpleSet qualifiedLookupVariable(String name) {
        SimpleSet qualifiedLookupVariable_String_value = this.qualifiedLookupVariable_compute(name);
        return qualifiedLookupVariable_String_value;
    }

    private SimpleSet qualifiedLookupVariable_compute(String name) {
        return SimpleSet.emptySet;
    }

    public String dumpString() {
        String dumpString_value = this.dumpString_compute();
        return dumpString_value;
    }

    private String dumpString_compute() {
        return this.getClass().getName() + " [" + this.getPackage() + "]";
    }

    public String name() {
        String name_value = this.name_compute();
        return name_value;
    }

    private String name_compute() {
        return this.getPackage();
    }

    public String packageName() {
        String packageName_value = this.packageName_compute();
        return packageName_value;
    }

    private String packageName_compute() {
        StringBuffer s = new StringBuffer();
        if (this.hasPrevExpr()) {
            s.append(this.prevExpr().packageName());
            s.append(".");
        }
        s.append(this.getPackage());
        return s.toString();
    }

    public boolean isPackageAccess() {
        boolean isPackageAccess_value = this.isPackageAccess_compute();
        return isPackageAccess_value;
    }

    private boolean isPackageAccess_compute() {
        return true;
    }

    public NameType predNameType() {
        NameType predNameType_value = this.predNameType_compute();
        return predNameType_value;
    }

    private NameType predNameType_compute() {
        return NameType.PACKAGE_NAME;
    }

    public boolean isUnknown() {
        boolean isUnknown_value = this.isUnknown_compute();
        return isUnknown_value;
    }

    private boolean isUnknown_compute() {
        return !this.hasPackage(this.packageName());
    }

    public boolean hasPackage(String packageName) {
        boolean hasPackage_String_value = this.getParent().Define_boolean_hasPackage(this, null, packageName);
        return hasPackage_String_value;
    }

    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

