/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import java.util.HashMap;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Body;
import soot.JastAddJ.BodyDecl;
import soot.JastAddJ.List;
import soot.JastAddJ.Modifiers;
import soot.JastAddJ.NullType;
import soot.JastAddJ.PrimitiveType;
import soot.JastAddJ.TypeDecl;
import soot.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferenceType
extends TypeDecl
implements Cloneable {
    public int IDstart;
    public int IDend;
    private int getNumBodyDecl = 0;

    @Override
    public void flushCache() {
        super.flushCache();
        this.narrowingConversionTo_TypeDecl_values = null;
        this.unboxed_computed = false;
        this.unboxed_value = null;
        this.jvmName_computed = false;
        this.jvmName_value = null;
    }

    @Override
    public ReferenceType clone() throws CloneNotSupportedException {
        ReferenceType node = (ReferenceType)super.clone();
        node.narrowingConversionTo_TypeDecl_values = null;
        node.unboxed_computed = false;
        node.unboxed_value = null;
        node.jvmName_computed = false;
        node.jvmName_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public Value emitCastTo(Body b, Value v, TypeDecl type) {
        if (this == type) {
            return v;
        }
        if (type instanceof PrimitiveType) {
            return type.boxed().emitUnboxingOperation(b, this.emitCastTo(b, v, type.boxed()));
        }
        return super.emitCastTo(b, v, type);
    }

    public ReferenceType() {
        this.setChild(new List(), 1);
    }

    public ReferenceType(Modifiers p0, String p1, List<BodyDecl> p2) {
        this.setChild(p0, 0);
        this.setID(p1);
        this.setChild(p2, 1);
    }

    public ReferenceType(Modifiers p0, Symbol p1, List<BodyDecl> p2) {
        this.setChild(p0, 0);
        this.setID(p1);
        this.setChild(p2, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setModifiers(Modifiers node) {
        this.setChild(node, 0);
    }

    @Override
    public Modifiers getModifiers() {
        return (Modifiers)this.getChild(0);
    }

    @Override
    public Modifiers getModifiersNoTransform() {
        return (Modifiers)this.getChildNoTransform(0);
    }

    @Override
    public void setID(String value) {
        this.tokenString_ID = value;
    }

    @Override
    public void setID(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol.value;
        this.IDstart = symbol.getStart();
        this.IDend = symbol.getEnd();
    }

    @Override
    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    @Override
    public void setBodyDeclList(List<BodyDecl> list) {
        this.setChild(list, 1);
    }

    @Override
    public int getNumBodyDecl() {
        return this.getBodyDeclList().getNumChild();
    }

    @Override
    public BodyDecl getBodyDecl(int i) {
        return (BodyDecl)this.getBodyDeclList().getChild(i);
    }

    @Override
    public void addBodyDecl(BodyDecl node) {
        List<BodyDecl> list = this.getBodyDeclList();
        list.addChild(node);
    }

    @Override
    public void setBodyDecl(BodyDecl node, int i) {
        List<BodyDecl> list = this.getBodyDeclList();
        list.setChild(node, i);
    }

    @Override
    public List<BodyDecl> getBodyDecls() {
        return this.getBodyDeclList();
    }

    @Override
    public List<BodyDecl> getBodyDeclsNoTransform() {
        return this.getBodyDeclListNoTransform();
    }

    @Override
    public List<BodyDecl> getBodyDeclList() {
        return (List)this.getChild(1);
    }

    @Override
    public List<BodyDecl> getBodyDeclListNoTransform() {
        return (List)this.getChildNoTransform(1);
    }

    @Override
    public boolean wideningConversionTo(TypeDecl type) {
        boolean wideningConversionTo_TypeDecl_value = this.wideningConversionTo_compute(type);
        return wideningConversionTo_TypeDecl_value;
    }

    private boolean wideningConversionTo_compute(TypeDecl type) {
        return this.instanceOf(type);
    }

    @Override
    public boolean narrowingConversionTo(TypeDecl type) {
        TypeDecl _parameters = type;
        if (this.narrowingConversionTo_TypeDecl_values == null) {
            this.narrowingConversionTo_TypeDecl_values = new HashMap(4);
        }
        if (this.narrowingConversionTo_TypeDecl_values.containsKey(_parameters)) {
            return (Boolean)this.narrowingConversionTo_TypeDecl_values.get(_parameters);
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean narrowingConversionTo_TypeDecl_value = this.narrowingConversionTo_compute(type);
        if (isFinal && num == boundariesCrossed) {
            this.narrowingConversionTo_TypeDecl_values.put(_parameters, narrowingConversionTo_TypeDecl_value);
        }
        return narrowingConversionTo_TypeDecl_value;
    }

    private boolean narrowingConversionTo_compute(TypeDecl type) {
        if (type.instanceOf(this)) {
            return true;
        }
        if (this.isClassDecl() && !this.getModifiers().isFinal() && type.isInterfaceDecl()) {
            return true;
        }
        if (this.isInterfaceDecl() && type.isClassDecl() && !type.getModifiers().isFinal()) {
            return true;
        }
        if (this.isInterfaceDecl() && type.instanceOf(this)) {
            return true;
        }
        if (this.fullName().equals("java.lang.Object") && type.isInterfaceDecl()) {
            return true;
        }
        return this.isArrayDecl() && type.isArrayDecl() && this.elementType().instanceOf(type.elementType());
    }

    @Override
    public boolean isReferenceType() {
        boolean isReferenceType_value = this.isReferenceType_compute();
        return isReferenceType_value;
    }

    private boolean isReferenceType_compute() {
        return true;
    }

    @Override
    public boolean isSupertypeOfNullType(NullType type) {
        boolean isSupertypeOfNullType_NullType_value = this.isSupertypeOfNullType_compute(type);
        return isSupertypeOfNullType_NullType_value;
    }

    private boolean isSupertypeOfNullType_compute(NullType type) {
        return true;
    }

    @Override
    public boolean isValidAnnotationMethodReturnType() {
        boolean isValidAnnotationMethodReturnType_value = this.isValidAnnotationMethodReturnType_compute();
        return isValidAnnotationMethodReturnType_value;
    }

    private boolean isValidAnnotationMethodReturnType_compute() {
        if (this.isString()) {
            return true;
        }
        if (this.fullName().equals("java.lang.Class")) {
            return true;
        }
        return this.erasure().fullName().equals("java.lang.Class");
    }

    @Override
    public boolean unboxingConversionTo(TypeDecl typeDecl) {
        boolean unboxingConversionTo_TypeDecl_value = this.unboxingConversionTo_compute(typeDecl);
        return unboxingConversionTo_TypeDecl_value;
    }

    private boolean unboxingConversionTo_compute(TypeDecl typeDecl) {
        return this.unboxed() == typeDecl;
    }

    @Override
    public TypeDecl unboxed() {
        if (this.unboxed_computed) {
            return this.unboxed_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.unboxed_value = this.unboxed_compute();
        if (isFinal && num == boundariesCrossed) {
            this.unboxed_computed = true;
        }
        return this.unboxed_value;
    }

    private TypeDecl unboxed_compute() {
        if (this.packageName().equals("java.lang") && this.isTopLevelType()) {
            String n = this.name();
            if (n.equals("Boolean")) {
                return this.typeBoolean();
            }
            if (n.equals("Byte")) {
                return this.typeByte();
            }
            if (n.equals("Character")) {
                return this.typeChar();
            }
            if (n.equals("Short")) {
                return this.typeShort();
            }
            if (n.equals("Integer")) {
                return this.typeInt();
            }
            if (n.equals("Long")) {
                return this.typeLong();
            }
            if (n.equals("Float")) {
                return this.typeFloat();
            }
            if (n.equals("Double")) {
                return this.typeDouble();
            }
        }
        return this.unknownType();
    }

    @Override
    public TypeDecl unaryNumericPromotion() {
        TypeDecl unaryNumericPromotion_value = this.unaryNumericPromotion_compute();
        return unaryNumericPromotion_value;
    }

    private TypeDecl unaryNumericPromotion_compute() {
        return this.isNumericType() && !this.isUnknown() ? this.unboxed().unaryNumericPromotion() : this;
    }

    @Override
    public TypeDecl binaryNumericPromotion(TypeDecl type) {
        TypeDecl binaryNumericPromotion_TypeDecl_value = this.binaryNumericPromotion_compute(type);
        return binaryNumericPromotion_TypeDecl_value;
    }

    private TypeDecl binaryNumericPromotion_compute(TypeDecl type) {
        return this.unboxed().binaryNumericPromotion(type);
    }

    @Override
    public boolean isNumericType() {
        boolean isNumericType_value = this.isNumericType_compute();
        return isNumericType_value;
    }

    private boolean isNumericType_compute() {
        return !this.unboxed().isUnknown() && this.unboxed().isNumericType();
    }

    @Override
    public boolean isIntegralType() {
        boolean isIntegralType_value = this.isIntegralType_compute();
        return isIntegralType_value;
    }

    private boolean isIntegralType_compute() {
        return !this.unboxed().isUnknown() && this.unboxed().isIntegralType();
    }

    @Override
    public boolean isPrimitive() {
        boolean isPrimitive_value = this.isPrimitive_compute();
        return isPrimitive_value;
    }

    private boolean isPrimitive_compute() {
        return !this.unboxed().isUnknown() && this.unboxed().isPrimitive();
    }

    @Override
    public boolean isBoolean() {
        boolean isBoolean_value = this.isBoolean_compute();
        return isBoolean_value;
    }

    private boolean isBoolean_compute() {
        return this.fullName().equals("java.lang.Boolean") && this.unboxed().isBoolean();
    }

    @Override
    public boolean supertypeNullType(NullType type) {
        boolean supertypeNullType_NullType_value = this.supertypeNullType_compute(type);
        return supertypeNullType_NullType_value;
    }

    private boolean supertypeNullType_compute(NullType type) {
        return true;
    }

    @Override
    public TypeDecl stringPromotion() {
        TypeDecl stringPromotion_value = this.stringPromotion_compute();
        return stringPromotion_value;
    }

    private TypeDecl stringPromotion_compute() {
        return this.typeObject();
    }

    @Override
    public String jvmName() {
        if (this.jvmName_computed) {
            return this.jvmName_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.jvmName_value = this.jvmName_compute();
        if (isFinal && num == boundariesCrossed) {
            this.jvmName_computed = true;
        }
        return this.jvmName_value;
    }

    private String jvmName_compute() {
        if (!this.isNestedType()) {
            return this.fullName();
        }
        if (this.isAnonymous() || this.isLocalClass()) {
            return this.enclosingType().jvmName() + "$" + this.uniqueIndex() + this.name();
        }
        return this.enclosingType().jvmName() + "$" + this.name();
    }

    @Override
    public String referenceClassFieldName() {
        String referenceClassFieldName_value = this.referenceClassFieldName_compute();
        return referenceClassFieldName_value;
    }

    private String referenceClassFieldName_compute() {
        return "class$" + this.jvmName().replace('[', '$').replace('.', '$').replace(';', ' ').trim();
    }

    public TypeDecl typeBoolean() {
        TypeDecl typeBoolean_value = this.getParent().Define_TypeDecl_typeBoolean(this, null);
        return typeBoolean_value;
    }

    public TypeDecl typeByte() {
        TypeDecl typeByte_value = this.getParent().Define_TypeDecl_typeByte(this, null);
        return typeByte_value;
    }

    public TypeDecl typeChar() {
        TypeDecl typeChar_value = this.getParent().Define_TypeDecl_typeChar(this, null);
        return typeChar_value;
    }

    public TypeDecl typeShort() {
        TypeDecl typeShort_value = this.getParent().Define_TypeDecl_typeShort(this, null);
        return typeShort_value;
    }

    @Override
    public TypeDecl typeInt() {
        TypeDecl typeInt_value = this.getParent().Define_TypeDecl_typeInt(this, null);
        return typeInt_value;
    }

    public TypeDecl typeLong() {
        TypeDecl typeLong_value = this.getParent().Define_TypeDecl_typeLong(this, null);
        return typeLong_value;
    }

    public TypeDecl typeFloat() {
        TypeDecl typeFloat_value = this.getParent().Define_TypeDecl_typeFloat(this, null);
        return typeFloat_value;
    }

    public TypeDecl typeDouble() {
        TypeDecl typeDouble_value = this.getParent().Define_TypeDecl_typeDouble(this, null);
        return typeDouble_value;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

