/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import soot.Immediate;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Body;
import soot.JastAddJ.ClassDecl;
import soot.JastAddJ.ConstructorAccess;
import soot.JastAddJ.ConstructorDecl;
import soot.JastAddJ.Expr;
import soot.JastAddJ.List;
import soot.JastAddJ.NameType;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.Local;
import soot.Type;
import soot.Value;
import soot.jimple.Jimple;
import soot.jimple.NullConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperConstructorAccess
extends ConstructorAccess
implements Cloneable {
    public int IDstart;
    public int IDend;
    private int getNumArg = 0;

    @Override
    public void flushCache() {
        super.flushCache();
        this.decls_computed = false;
        this.decls_value = null;
    }

    @Override
    public SuperConstructorAccess clone() throws CloneNotSupportedException {
        SuperConstructorAccess node = (SuperConstructorAccess)super.clone();
        node.decls_computed = false;
        node.decls_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public SuperConstructorAccess copy() {
        try {
            SuperConstructorAccess node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    @Override
    public SuperConstructorAccess fullCopy() {
        SuperConstructorAccess res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
        }
        return res;
    }

    @Override
    public void nameCheck() {
        TypeDecl s;
        super.nameCheck();
        TypeDecl c = this.hostType();
        TypeDecl typeDecl = s = c.isClassDecl() && ((ClassDecl)c).hasSuperclass() ? ((ClassDecl)c).superclass() : this.unknownType();
        if (this.isQualified()) {
            if (!s.isInnerType() || s.inStaticContext()) {
                this.error("the super type " + s.typeName() + " of " + c.typeName() + " is not an inner class");
            } else if (!this.qualifier().type().instanceOf(s.enclosingType())) {
                this.error("The type of this primary expression, " + this.qualifier().type().typeName() + " is not enclosing the super type, " + s.typeName() + ", of " + c.typeName());
            }
        }
        if (!this.isQualified() && s.isInnerType() && !c.isInnerType()) {
            this.error("no enclosing instance for " + s.typeName() + " when accessed in " + this);
        }
        if (s.isInnerType() && this.hostType().instanceOf(s.enclosingType())) {
            this.error("cannot reference this before supertype constructor has been called");
        }
    }

    @Override
    public void transformation() {
        this.addEnclosingVariables();
        if (this.decl().isPrivate() && this.decl().hostType() != this.hostType()) {
            this.decl().createAccessor();
        }
        super.transformation();
    }

    @Override
    public void collectTypesToSignatures(Collection<Type> set) {
        super.collectTypesToSignatures(set);
        this.addDependencyIfNeeded(set, this.decl().erasedConstructor().hostType());
    }

    public SuperConstructorAccess() {
        this.setChild(new List(), 0);
    }

    public SuperConstructorAccess(String p0, List<Expr> p1) {
        this.setID(p0);
        this.setChild(p1, 0);
    }

    public SuperConstructorAccess(Symbol p0, List<Expr> p1) {
        this.setID(p0);
        this.setChild(p1, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setID(String value) {
        this.tokenString_ID = value;
    }

    @Override
    public void setID(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol.value;
        this.IDstart = symbol.getStart();
        this.IDend = symbol.getEnd();
    }

    @Override
    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    @Override
    public void setArgList(List<Expr> list) {
        this.setChild(list, 0);
    }

    @Override
    public int getNumArg() {
        return this.getArgList().getNumChild();
    }

    @Override
    public Expr getArg(int i) {
        return (Expr)this.getArgList().getChild(i);
    }

    @Override
    public void addArg(Expr node) {
        List<Expr> list = this.getArgList();
        list.addChild(node);
    }

    @Override
    public void setArg(Expr node, int i) {
        List<Expr> list = this.getArgList();
        list.setChild(node, i);
    }

    @Override
    public List<Expr> getArgs() {
        return this.getArgList();
    }

    @Override
    public List<Expr> getArgsNoTransform() {
        return this.getArgListNoTransform();
    }

    @Override
    public List<Expr> getArgList() {
        return (List)this.getChild(0);
    }

    @Override
    public List<Expr> getArgListNoTransform() {
        return (List)this.getChildNoTransform(0);
    }

    @Override
    public Value eval(Body b) {
        ConstructorDecl c = this.decl().erasedConstructor();
        Local base = b.emitThis(this.hostType());
        boolean index = false;
        ArrayList<Immediate> list = new ArrayList<Immediate>();
        if (c.needsEnclosing()) {
            if (this.hasPrevExpr() && !this.prevExpr().isTypeAccess()) {
                list.add(this.asImmediate(b, this.prevExpr().eval(b)));
            } else if (this.hostType().needsSuperEnclosing()) {
                Type type = ((ClassDecl)this.hostType()).superclass().enclosingType().getSootType();
                if (this.hostType().needsEnclosing()) {
                    list.add(this.asImmediate(b, Jimple.v().newParameterRef(type, 1)));
                } else {
                    list.add(this.asImmediate(b, Jimple.v().newParameterRef(type, 0)));
                }
            } else {
                list.add(this.emitThis(b, this.superConstructorQualifier(c.hostType().enclosingType())));
            }
        }
        for (int i = 0; i < this.getNumArg(); ++i) {
            list.add(this.asImmediate(b, this.getArg(i).type().emitCastTo(b, this.getArg(i), c.getParameter(i).type())));
        }
        if (this.decl().isPrivate() && this.decl().hostType() != this.hostType()) {
            list.add(this.asImmediate(b, NullConstant.v()));
            b.add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(base, this.decl().erasedConstructor().createAccessor().sootRef(), list)));
            return base;
        }
        return Jimple.v().newSpecialInvokeExpr(base, c.sootRef(), list);
    }

    @Override
    public boolean isDAafter(Variable v) {
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.isDAbefore(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.isDUbefore(v);
    }

    @Override
    public SimpleSet decls() {
        if (this.decls_computed) {
            return this.decls_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.decls_value = this.decls_compute();
        if (isFinal && num == boundariesCrossed) {
            this.decls_computed = true;
        }
        return this.decls_value;
    }

    private SimpleSet decls_compute() {
        Collection c = this.hasPrevExpr() && !this.prevExpr().isTypeAccess() ? this.hostType().lookupSuperConstructor() : this.lookupSuperConstructor();
        return this.chooseConstructor(c, this.getArgList());
    }

    @Override
    public String name() {
        String name_value = this.name_compute();
        return name_value;
    }

    private String name_compute() {
        return "super";
    }

    @Override
    public boolean isSuperConstructorAccess() {
        boolean isSuperConstructorAccess_value = this.isSuperConstructorAccess_compute();
        return isSuperConstructorAccess_value;
    }

    private boolean isSuperConstructorAccess_compute() {
        return true;
    }

    @Override
    public NameType predNameType() {
        NameType predNameType_value = this.predNameType_compute();
        return predNameType_value;
    }

    private NameType predNameType_compute() {
        return NameType.EXPRESSION_NAME;
    }

    public Collection lookupSuperConstructor() {
        Collection lookupSuperConstructor_value = this.getParent().Define_Collection_lookupSuperConstructor(this, null);
        return lookupSuperConstructor_value;
    }

    public TypeDecl enclosingInstance() {
        TypeDecl enclosingInstance_value = this.getParent().Define_TypeDecl_enclosingInstance(this, null);
        return enclosingInstance_value;
    }

    @Override
    public SimpleSet Define_SimpleSet_lookupVariable(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.unqualifiedScope().lookupVariable(name);
        }
        return super.Define_SimpleSet_lookupVariable(caller, child, name);
    }

    @Override
    public boolean Define_boolean_hasPackage(ASTNode caller, ASTNode child, String packageName) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.unqualifiedScope().hasPackage(packageName);
        }
        return super.Define_boolean_hasPackage(caller, child, packageName);
    }

    @Override
    public boolean Define_boolean_inExplicitConstructorInvocation(ASTNode caller, ASTNode child) {
        if (caller == this.getArgListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return true;
        }
        return super.Define_boolean_inExplicitConstructorInvocation(caller, child);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

