/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.LinkedList;
import polyglot.ext.hj.types.HjParsedClassType;
import soot.AnySubType;
import soot.G;
import soot.RefLikeType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootResolver;
import soot.Type;
import soot.TypeSwitch;
import soot.UnknownType;
import soot.util.Switch;

public class RefType
extends RefLikeType
implements Comparable {
    protected String className;
    protected SootClass sootClass;
    protected AnySubType anySubType;
    protected HjParsedClassType hjType;

    public RefType(Singletons.Global g) {
        this.className = "";
    }

    public static RefType v() {
        return G.v().soot_RefType();
    }

    public String getClassName() {
        return this.className;
    }

    public RefType() {
    }

    private RefType(String className, HjParsedClassType hjType) {
        this(className);
        this.hjType = hjType;
    }

    private RefType(String className) {
        if (className.startsWith("[")) {
            throw new RuntimeException("Attempt to create RefType whose name starts with [ --> " + className);
        }
        if (className.indexOf("/") >= 0) {
            throw new RuntimeException("Attempt to create RefType containing a / --> " + className);
        }
        if (className.indexOf(";") >= 0) {
            throw new RuntimeException("Attempt to create RefType containing a ; --> " + className);
        }
        this.className = className;
    }

    public static RefType v(String className) {
        RefType ret = Scene.v().getRefType(className);
        if (ret == null) {
            ret = new RefType(className);
            Scene.v().addRefType(ret);
        }
        return ret;
    }

    public int compareTo(Object o) throws ClassCastException {
        RefType t = (RefType)o;
        return this.toString().compareTo(t.toString());
    }

    public static RefType v(SootClass c) {
        return RefType.v(c.getName());
    }

    public SootClass getSootClass() {
        if (this.sootClass == null) {
            this.sootClass = SootResolver.v().makeClassRef(this.className);
        }
        return this.sootClass;
    }

    public boolean hasSootClass() {
        return this.sootClass != null;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setSootClass(SootClass sootClass) {
        this.sootClass = sootClass;
    }

    public boolean equals(Object t) {
        return t instanceof RefType && this.className.equals(((RefType)t).className);
    }

    public String toString() {
        return this.className;
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public void apply(Switch sw) {
        ((TypeSwitch)sw).caseRefType(this);
    }

    public Type merge(Type other, Scene cm) {
        if (other.equals(UnknownType.v()) || this.equals(other)) {
            return this;
        }
        if (!(other instanceof RefType)) {
            throw new RuntimeException("illegal type merge: " + this + " and " + other);
        }
        SootClass thisClass = cm.getSootClass(this.className);
        SootClass otherClass = cm.getSootClass(((RefType)other).className);
        SootClass javalangObject = cm.getSootClass("java.lang.Object");
        LinkedList<SootClass> thisHierarchy = new LinkedList<SootClass>();
        LinkedList<SootClass> otherHierarchy = new LinkedList<SootClass>();
        SootClass SootClass2 = thisClass;
        while (true) {
            thisHierarchy.addFirst(SootClass2);
            if (SootClass2 == javalangObject) break;
            SootClass2 = SootClass2.getSuperclass();
        }
        SootClass2 = otherClass;
        while (true) {
            otherHierarchy.addFirst(SootClass2);
            if (SootClass2 == javalangObject) break;
            SootClass2 = SootClass2.getSuperclass();
        }
        SootClass commonClass = null;
        while (!otherHierarchy.isEmpty() && !thisHierarchy.isEmpty() && otherHierarchy.getFirst() == thisHierarchy.getFirst()) {
            commonClass = (SootClass)otherHierarchy.removeFirst();
            thisHierarchy.removeFirst();
        }
        return RefType.v(commonClass.getName());
    }

    public Type getArrayElementType() {
        if (this.className.equals("java.lang.Object") || this.className.equals("java.io.Serializable") || this.className.equals("java.lang.Cloneable")) {
            return RefType.v("java.lang.Object");
        }
        throw new RuntimeException("Attempt to get array base type of a non-array");
    }

    public AnySubType getAnySubType() {
        return this.anySubType;
    }

    public void setAnySubType(AnySubType anySubType) {
        this.anySubType = anySubType;
    }

    public RefType makeVariant(HjParsedClassType hjType) {
        return new RefType(this.className, hjType);
    }

    public HjParsedClassType getHjType() {
        return this.hjType;
    }
}

