/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.AbstractSootFieldRef;
import soot.AbstractSootMethodRef;
import soot.ArrayType;
import soot.EntryPoints;
import soot.FastHierarchy;
import soot.G;
import soot.Hierarchy;
import soot.Kind;
import soot.MethodOrMethodContext;
import soot.PointsToAnalysis;
import soot.RefType;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.SootResolver;
import soot.SourceLocator;
import soot.Type;
import soot.VoidType;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.ContextSensitiveCallGraph;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.pointer.DumbPointerAnalysis;
import soot.jimple.toolkits.pointer.SideEffectAnalysis;
import soot.options.Options;
import soot.toolkits.exceptions.PedanticThrowAnalysis;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.exceptions.UnitThrowAnalysis;
import soot.util.ArrayNumberer;
import soot.util.Chain;
import soot.util.HashChain;
import soot.util.MapNumberer;
import soot.util.Numberer;
import soot.util.SingletonList;
import soot.util.StringNumberer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scene {
    private final RefType OBJECT_TYPE;
    Chain<SootClass> classes = new HashChain<SootClass>();
    Chain<SootClass> applicationClasses = new HashChain<SootClass>();
    Chain<SootClass> libraryClasses = new HashChain<SootClass>();
    Chain<SootClass> phantomClasses = new HashChain<SootClass>();
    private final Map<String, Type> nameToClass = new HashMap<String, Type>();
    ArrayNumberer kindNumberer = new ArrayNumberer();
    ArrayNumberer typeNumberer = new ArrayNumberer();
    ArrayNumberer methodNumberer = new ArrayNumberer();
    Numberer unitNumberer = new MapNumberer();
    Numberer contextNumberer = null;
    ArrayNumberer fieldNumberer = new ArrayNumberer();
    ArrayNumberer classNumberer = new ArrayNumberer();
    StringNumberer subSigNumberer = new StringNumberer();
    ArrayNumberer localNumberer = new ArrayNumberer();
    private Hierarchy activeHierarchy;
    private FastHierarchy activeFastHierarchy;
    private CallGraph activeCallGraph;
    private ReachableMethods reachableMethods;
    private PointsToAnalysis activePointsToAnalysis;
    private SideEffectAnalysis activeSideEffectAnalysis;
    private List<SootMethod> entryPoints;
    boolean allowsPhantomRefs = false;
    SootClass mainClass;
    String sootClassPath = null;
    private ThrowAnalysis defaultThrowAnalysis = null;
    Set<String> reservedNames = new HashSet<String>();
    private int stateCount;
    public ArrayList<SootClass> extraClasses = new ArrayList();
    private ContextSensitiveCallGraph cscg;
    private final Set<String>[] basicclasses = new Set[4];
    private List<SootClass> dynamicClasses;
    ArrayList<String> pkgList;
    private boolean doneResolving = false;

    public Scene(Singletons.Global g) {
        this.setReservedNames();
        String scp = System.getProperty("soot.class.path");
        if (scp != null) {
            this.setSootClassPath(scp);
        }
        this.kindNumberer.add(Kind.INVALID);
        this.kindNumberer.add(Kind.STATIC);
        this.kindNumberer.add(Kind.VIRTUAL);
        this.kindNumberer.add(Kind.INTERFACE);
        this.kindNumberer.add(Kind.SPECIAL);
        this.kindNumberer.add(Kind.CLINIT);
        this.kindNumberer.add(Kind.THREAD);
        this.kindNumberer.add(Kind.FINALIZE);
        this.kindNumberer.add(Kind.INVOKE_FINALIZE);
        this.kindNumberer.add(Kind.PRIVILEGED);
        this.kindNumberer.add(Kind.NEWINSTANCE);
        this.addSootBasicClasses();
        this.OBJECT_TYPE = this.getRefType("java.lang.Object");
    }

    public static Scene v() {
        return G.v().soot_Scene();
    }

    public void setMainClass(SootClass m) {
        this.mainClass = m;
        if (!m.declaresMethod(Scene.v().getSubSigNumberer().findOrAdd("void main(java.lang.String[])"))) {
            throw new RuntimeException("Main-class has no main method!");
        }
    }

    public Set<String> getReservedNames() {
        return this.reservedNames;
    }

    public String quotedNameOf(String s) {
        if (this.reservedNames.contains(s)) {
            return "'" + s + "'";
        }
        return s;
    }

    public SootClass getMainClass() {
        if (this.mainClass == null) {
            this.setMainClassFromOptions();
        }
        if (this.mainClass == null) {
            throw new RuntimeException("There is no main class set!");
        }
        return this.mainClass;
    }

    public SootMethod getMainMethod() {
        if (this.mainClass == null) {
            throw new RuntimeException("There is no main class set!");
        }
        if (!this.mainClass.declaresMethod("main", new SingletonList(ArrayType.v(RefType.v("java.lang.String"), 1)), VoidType.v())) {
            throw new RuntimeException("Main class declares no main method!");
        }
        return this.mainClass.getMethod("main", new SingletonList(ArrayType.v(RefType.v("java.lang.String"), 1)), VoidType.v());
    }

    public void setSootClassPath(String p) {
        this.sootClassPath = p;
        SourceLocator.v().invalidateClassPath();
    }

    public String getSootClassPath() {
        if (this.sootClassPath == null) {
            String optionscp = Options.v().soot_classpath();
            String optionssp = Options.v().sourcepath();
            if (optionscp.length() > 0) {
                this.sootClassPath = optionscp;
            }
            if (optionssp.length() > 0) {
                this.sootClassPath = this.sootClassPath != null ? this.sootClassPath + File.pathSeparator + optionssp : optionssp;
            }
            String defaultSootClassPath = this.defaultClassPath();
            if (this.sootClassPath == null) {
                this.sootClassPath = defaultSootClassPath;
            } else if (Options.v().prepend_classpath()) {
                this.sootClassPath = this.sootClassPath + File.pathSeparator + defaultSootClassPath;
            }
        }
        return this.sootClassPath;
    }

    private String j9DefaultClasspath(String prefix) {
        String j9Classpath = "" + prefix + "lib/ppc64/default/jclSC160/vm.jar" + prefix + "lib/java.util.jar" + prefix + "lib/annotation.jar" + prefix + "lib/ibmpkcs.jar" + prefix + "lib/logging.jar" + prefix + "lib/xml.jar" + prefix + "lib/beans.jar" + prefix + "lib/ibmcertpathfw.jar" + prefix + "lib/annotation.jar" + prefix + "lib/beans.jar" + prefix + "lib/charsets.jar" + prefix + "lib/deploy.jar" + prefix + "lib/ibmcertpathfw.jar" + prefix + "lib/ibmcertpathprovider.jar" + prefix + "lib/ibmcfw.jar" + prefix + "lib/ibmjcefw.jar" + prefix + "lib/ibmjgssfw.jar" + prefix + "lib/ibmjgssprovider.jar" + prefix + "lib/ibmjssefw.jar" + prefix + "lib/ibmjsseprovider2.jar" + prefix + "lib/ibmorbapi.jar" + prefix + "lib/ibmorb.jar" + prefix + "lib/ibmpkcs.jar" + prefix + "lib/ibmsaslfw.jar" + prefix + "lib/ibmxmlcrypto.jar" + prefix + "lib/j9zip.jar" + prefix + "lib/javascript.jar" + prefix + "lib/java.util.jar" + prefix + "lib/javaws.jar" + prefix + "lib/jlm.jar" + prefix + "lib/jndi.jar" + prefix + "lib/logging.jar" + prefix + "lib/management-agent.jar" + prefix + "lib/resources.jar" + prefix + "lib/rt.jar" + prefix + "lib/security.jar" + prefix + "lib/sql.jar" + prefix + "lib/xmldsigfw.jar" + prefix + "lib/xml.jar";
        return j9Classpath;
    }

    public String defaultClassPath() {
        String javaHome = System.getProperty("java.home");
        String prefix = File.pathSeparator + javaHome + File.separator;
        String defaultSootClassPath = System.getProperty("java.class.path") + prefix + "lib" + File.separator + "rt.jar" + this.j9DefaultClasspath(prefix) + prefix + ".." + File.separator + "Classes" + File.separator + "classes.jar";
        if (Options.v().whole_program()) {
            defaultSootClassPath = defaultSootClassPath + prefix + "lib" + File.separator + "jce.jar";
        }
        return defaultSootClassPath;
    }

    public int getState() {
        return this.stateCount;
    }

    private void modifyHierarchy() {
        ++this.stateCount;
        this.activeHierarchy = null;
        this.activeFastHierarchy = null;
        this.activeSideEffectAnalysis = null;
        this.activePointsToAnalysis = null;
    }

    public void addClass(SootClass c) {
        if (c.isInScene()) {
            throw new RuntimeException("already managed: " + c.getName());
        }
        if (this.containsClass(c.getName())) {
            throw new RuntimeException("duplicate class: " + c.getName());
        }
        this.classes.add(c);
        c.setLibraryClass();
        this.nameToClass.put(c.getName(), c.getType());
        c.getType().setSootClass(c);
        c.setInScene(true);
        this.modifyHierarchy();
    }

    public void removeClass(SootClass c) {
        if (!c.isInScene()) {
            throw new RuntimeException();
        }
        this.classes.remove(c);
        if (c.isLibraryClass()) {
            this.libraryClasses.remove(c);
        } else if (c.isPhantomClass()) {
            this.phantomClasses.remove(c);
        } else if (c.isApplicationClass()) {
            this.applicationClasses.remove(c);
        }
        c.getType().setSootClass(null);
        c.setInScene(false);
        this.modifyHierarchy();
    }

    public boolean containsClass(String className) {
        RefType type = (RefType)this.nameToClass.get(className);
        if (type == null) {
            return false;
        }
        if (!type.hasSootClass()) {
            return false;
        }
        SootClass c = type.getSootClass();
        return c.isInScene();
    }

    public String signatureToClass(String sig) {
        if (sig.charAt(0) != '<') {
            throw new RuntimeException("oops " + sig);
        }
        if (sig.charAt(sig.length() - 1) != '>') {
            throw new RuntimeException("oops " + sig);
        }
        int index = sig.indexOf(":");
        if (index < 0) {
            throw new RuntimeException("oops " + sig);
        }
        return sig.substring(1, index);
    }

    public String signatureToSubsignature(String sig) {
        if (sig.charAt(0) != '<') {
            throw new RuntimeException("oops " + sig);
        }
        if (sig.charAt(sig.length() - 1) != '>') {
            throw new RuntimeException("oops " + sig);
        }
        int index = sig.indexOf(":");
        if (index < 0) {
            throw new RuntimeException("oops " + sig);
        }
        return sig.substring(index + 2, sig.length() - 1);
    }

    private SootField grabField(String fieldSignature) {
        String cname = this.signatureToClass(fieldSignature);
        String fname = this.signatureToSubsignature(fieldSignature);
        if (!this.containsClass(cname)) {
            return null;
        }
        SootClass c = this.getSootClass(cname);
        if (!c.declaresField(fname)) {
            return null;
        }
        return c.getField(fname);
    }

    public boolean containsField(String fieldSignature) {
        return this.grabField(fieldSignature) != null;
    }

    private SootMethod grabMethod(String methodSignature) {
        String cname = this.signatureToClass(methodSignature);
        String mname = this.signatureToSubsignature(methodSignature);
        if (!this.containsClass(cname)) {
            return null;
        }
        SootClass c = this.getSootClass(cname);
        if (!c.declaresMethod(mname)) {
            return null;
        }
        return c.getMethod(mname);
    }

    public boolean containsMethod(String methodSignature) {
        return this.grabMethod(methodSignature) != null;
    }

    public SootField getField(String fieldSignature) {
        SootField f = this.grabField(fieldSignature);
        if (f != null) {
            return f;
        }
        throw new RuntimeException("tried to get nonexistent field " + fieldSignature);
    }

    public SootMethod getMethod(String methodSignature) {
        SootMethod m = this.grabMethod(methodSignature);
        if (m != null) {
            return m;
        }
        throw new RuntimeException("tried to get nonexistent method " + methodSignature);
    }

    public SootClass tryLoadClass(String className, int desiredLevel) {
        Scene.v().setPhantomRefs(true);
        if (!this.getPhantomRefs() && SourceLocator.v().getClassSource(className) == null) {
            Scene.v().setPhantomRefs(false);
            return null;
        }
        SootResolver resolver = SootResolver.v();
        SootClass toReturn = resolver.resolveClass(className, desiredLevel);
        Scene.v().setPhantomRefs(false);
        return toReturn;
    }

    public SootClass loadClassAndSupport(String className) {
        SootClass ret = this.loadClass(className, 2);
        if (!ret.isPhantom()) {
            ret = this.loadClass(className, 3);
        }
        return ret;
    }

    public SootClass loadClass(String className, int desiredLevel) {
        Scene.v().setPhantomRefs(true);
        SootResolver resolver = SootResolver.v();
        SootClass toReturn = resolver.resolveClass(className, desiredLevel);
        Scene.v().setPhantomRefs(false);
        return toReturn;
    }

    public RefType getRefType(String className) {
        return (RefType)this.nameToClass.get(className);
    }

    public RefType getObjectType() {
        return this.OBJECT_TYPE;
    }

    public void addRefType(RefType type) {
        this.nameToClass.put(type.getClassName(), type);
    }

    public SootClass getSootClass(String className) {
        RefType type = (RefType)this.nameToClass.get(className);
        if (type != null) {
            return type.getSootClass();
        }
        if (Scene.v().allowsPhantomRefs()) {
            SootClass c = new SootClass(className);
            c.setPhantom(true);
            this.addClass(c);
            return c;
        }
        throw new RuntimeException(System.getProperty("line.separator") + "Aborting: can't find classfile " + className);
    }

    public Chain<SootClass> getClasses() {
        return this.classes;
    }

    public Chain<SootClass> getApplicationClasses() {
        return this.applicationClasses;
    }

    public Chain<SootClass> getLibraryClasses() {
        return this.libraryClasses;
    }

    public Chain<SootClass> getPhantomClasses() {
        return this.phantomClasses;
    }

    Chain<SootClass> getContainingChain(SootClass c) {
        if (c.isApplicationClass()) {
            return this.getApplicationClasses();
        }
        if (c.isLibraryClass()) {
            return this.getLibraryClasses();
        }
        if (c.isPhantomClass()) {
            return this.getPhantomClasses();
        }
        return null;
    }

    public SideEffectAnalysis getSideEffectAnalysis() {
        if (!this.hasSideEffectAnalysis()) {
            this.setSideEffectAnalysis(new SideEffectAnalysis(this.getPointsToAnalysis(), this.getCallGraph()));
        }
        return this.activeSideEffectAnalysis;
    }

    public void setSideEffectAnalysis(SideEffectAnalysis sea) {
        this.activeSideEffectAnalysis = sea;
    }

    public boolean hasSideEffectAnalysis() {
        return this.activeSideEffectAnalysis != null;
    }

    public void releaseSideEffectAnalysis() {
        this.activeSideEffectAnalysis = null;
    }

    public PointsToAnalysis getPointsToAnalysis() {
        if (!this.hasPointsToAnalysis()) {
            return DumbPointerAnalysis.v();
        }
        return this.activePointsToAnalysis;
    }

    public void setPointsToAnalysis(PointsToAnalysis pa) {
        this.activePointsToAnalysis = pa;
    }

    public boolean hasPointsToAnalysis() {
        return this.activePointsToAnalysis != null;
    }

    public void releasePointsToAnalysis() {
        this.activePointsToAnalysis = null;
    }

    public FastHierarchy getOrMakeFastHierarchy() {
        if (!this.hasFastHierarchy()) {
            this.setFastHierarchy(new FastHierarchy());
        }
        return this.getFastHierarchy();
    }

    public FastHierarchy getFastHierarchy() {
        if (!this.hasFastHierarchy()) {
            throw new RuntimeException("no active FastHierarchy present for scene");
        }
        return this.activeFastHierarchy;
    }

    public void setFastHierarchy(FastHierarchy hierarchy) {
        this.activeFastHierarchy = hierarchy;
    }

    public boolean hasFastHierarchy() {
        return this.activeFastHierarchy != null;
    }

    public void releaseFastHierarchy() {
        this.activeFastHierarchy = null;
    }

    public Hierarchy getActiveHierarchy() {
        if (!this.hasActiveHierarchy()) {
            this.setActiveHierarchy(new Hierarchy());
        }
        return this.activeHierarchy;
    }

    public void setActiveHierarchy(Hierarchy hierarchy) {
        this.activeHierarchy = hierarchy;
    }

    public boolean hasActiveHierarchy() {
        return this.activeHierarchy != null;
    }

    public void releaseActiveHierarchy() {
        this.activeHierarchy = null;
    }

    public List<SootMethod> getEntryPoints() {
        if (this.entryPoints == null) {
            this.entryPoints = EntryPoints.v().all();
        }
        return this.entryPoints;
    }

    public void setEntryPoints(List<SootMethod> entryPoints) {
        this.entryPoints = entryPoints;
    }

    public ContextSensitiveCallGraph getContextSensitiveCallGraph() {
        if (this.cscg == null) {
            throw new RuntimeException("No context-sensitive call graph present in Scene. You can bulid one with Paddle.");
        }
        return this.cscg;
    }

    public void setContextSensitiveCallGraph(ContextSensitiveCallGraph cscg) {
        this.cscg = cscg;
    }

    public CallGraph getCallGraph() {
        if (!this.hasCallGraph()) {
            throw new RuntimeException("No call graph present in Scene. Maybe you want Whole Program mode (-w).");
        }
        return this.activeCallGraph;
    }

    public void setCallGraph(CallGraph cg) {
        this.reachableMethods = null;
        this.activeCallGraph = cg;
    }

    public boolean hasCallGraph() {
        return this.activeCallGraph != null;
    }

    public void releaseCallGraph() {
        this.activeCallGraph = null;
        this.reachableMethods = null;
    }

    public ReachableMethods getReachableMethods() {
        if (this.reachableMethods == null) {
            this.reachableMethods = new ReachableMethods(this.getCallGraph(), new ArrayList<MethodOrMethodContext>(this.getEntryPoints()));
        }
        this.reachableMethods.update();
        return this.reachableMethods;
    }

    public void setReachableMethods(ReachableMethods rm) {
        this.reachableMethods = rm;
    }

    public boolean hasReachableMethods() {
        return this.reachableMethods != null;
    }

    public void releaseReachableMethods() {
        this.reachableMethods = null;
    }

    public boolean getPhantomRefs() {
        if (!Options.v().allow_phantom_refs()) {
            return false;
        }
        return this.allowsPhantomRefs;
    }

    public void setPhantomRefs(boolean value) {
        this.allowsPhantomRefs = value;
    }

    public boolean allowsPhantomRefs() {
        return this.getPhantomRefs();
    }

    public Numberer kindNumberer() {
        return this.kindNumberer;
    }

    public ArrayNumberer getTypeNumberer() {
        return this.typeNumberer;
    }

    public ArrayNumberer getMethodNumberer() {
        return this.methodNumberer;
    }

    public Numberer getContextNumberer() {
        return this.contextNumberer;
    }

    public Numberer getUnitNumberer() {
        return this.unitNumberer;
    }

    public ArrayNumberer getFieldNumberer() {
        return this.fieldNumberer;
    }

    public ArrayNumberer getClassNumberer() {
        return this.classNumberer;
    }

    public StringNumberer getSubSigNumberer() {
        return this.subSigNumberer;
    }

    public ArrayNumberer getLocalNumberer() {
        return this.localNumberer;
    }

    public void setContextNumberer(Numberer n) {
        if (this.contextNumberer != null) {
            throw new RuntimeException("Attempt to set context numberer when it is already set.");
        }
        this.contextNumberer = n;
    }

    public ThrowAnalysis getDefaultThrowAnalysis() {
        if (this.defaultThrowAnalysis == null) {
            int optionsThrowAnalysis = Options.v().throw_analysis();
            switch (optionsThrowAnalysis) {
                case 1: {
                    this.defaultThrowAnalysis = PedanticThrowAnalysis.v();
                    break;
                }
                case 2: {
                    this.defaultThrowAnalysis = UnitThrowAnalysis.v();
                    break;
                }
                default: {
                    throw new IllegalStateException("Options.v().throw_analysi() == " + Options.v().throw_analysis());
                }
            }
        }
        return this.defaultThrowAnalysis;
    }

    public void setDefaultThrowAnalysis(ThrowAnalysis ta) {
        this.defaultThrowAnalysis = ta;
    }

    private void setReservedNames() {
        Set<String> rn = this.getReservedNames();
        rn.add("newarray");
        rn.add("newmultiarray");
        rn.add("nop");
        rn.add("ret");
        rn.add("specialinvoke");
        rn.add("staticinvoke");
        rn.add("tableswitch");
        rn.add("virtualinvoke");
        rn.add("null_type");
        rn.add("unknown");
        rn.add("cmp");
        rn.add("cmpg");
        rn.add("cmpl");
        rn.add("entermonitor");
        rn.add("exitmonitor");
        rn.add("interfaceinvoke");
        rn.add("lengthof");
        rn.add("lookupswitch");
        rn.add("neg");
        rn.add("if");
        rn.add("abstract");
        rn.add("annotation");
        rn.add("boolean");
        rn.add("break");
        rn.add("byte");
        rn.add("case");
        rn.add("catch");
        rn.add("char");
        rn.add("class");
        rn.add("final");
        rn.add("native");
        rn.add("public");
        rn.add("protected");
        rn.add("private");
        rn.add("static");
        rn.add("synchronized");
        rn.add("transient");
        rn.add("volatile");
        rn.add("interface");
        rn.add("void");
        rn.add("short");
        rn.add("int");
        rn.add("long");
        rn.add("float");
        rn.add("double");
        rn.add("extends");
        rn.add("implements");
        rn.add("breakpoint");
        rn.add("default");
        rn.add("goto");
        rn.add("instanceof");
        rn.add("new");
        rn.add("return");
        rn.add("throw");
        rn.add("throws");
        rn.add("null");
        rn.add("from");
        rn.add("to");
    }

    private void addSootBasicClasses() {
        this.basicclasses[1] = new HashSet<String>();
        this.basicclasses[2] = new HashSet<String>();
        this.basicclasses[3] = new HashSet<String>();
        this.addBasicClass("java.lang.Object");
        this.addBasicClass("java.lang.Class", 2);
        this.addBasicClass("java.lang.Void", 2);
        this.addBasicClass("java.lang.Boolean", 2);
        this.addBasicClass("java.lang.Byte", 2);
        this.addBasicClass("java.lang.Character", 2);
        this.addBasicClass("java.lang.Short", 2);
        this.addBasicClass("java.lang.Integer", 2);
        this.addBasicClass("java.lang.Long", 2);
        this.addBasicClass("java.lang.Float", 2);
        this.addBasicClass("java.lang.Double", 2);
        this.addBasicClass("java.lang.String");
        this.addBasicClass("java.lang.StringBuffer", 2);
        this.addBasicClass("java.lang.Error");
        this.addBasicClass("java.lang.AssertionError", 2);
        this.addBasicClass("java.lang.Throwable", 2);
        this.addBasicClass("java.lang.NoClassDefFoundError", 2);
        this.addBasicClass("java.lang.ExceptionInInitializerError");
        this.addBasicClass("java.lang.RuntimeException");
        this.addBasicClass("java.lang.ClassNotFoundException");
        this.addBasicClass("java.lang.ArithmeticException");
        this.addBasicClass("java.lang.ArrayStoreException");
        this.addBasicClass("java.lang.ClassCastException");
        this.addBasicClass("java.lang.IllegalMonitorStateException");
        this.addBasicClass("java.lang.IndexOutOfBoundsException");
        this.addBasicClass("java.lang.ArrayIndexOutOfBoundsException");
        this.addBasicClass("java.lang.NegativeArraySizeException");
        this.addBasicClass("java.lang.NullPointerException");
        this.addBasicClass("java.lang.InstantiationError");
        this.addBasicClass("java.lang.InternalError");
        this.addBasicClass("java.lang.OutOfMemoryError");
        this.addBasicClass("java.lang.StackOverflowError");
        this.addBasicClass("java.lang.UnknownError");
        this.addBasicClass("java.lang.ThreadDeath");
        this.addBasicClass("java.lang.ClassCircularityError");
        this.addBasicClass("java.lang.ClassFormatError");
        this.addBasicClass("java.lang.IllegalAccessError");
        this.addBasicClass("java.lang.IncompatibleClassChangeError");
        this.addBasicClass("java.lang.LinkageError");
        this.addBasicClass("java.lang.VerifyError");
        this.addBasicClass("java.lang.NoSuchFieldError");
        this.addBasicClass("java.lang.AbstractMethodError");
        this.addBasicClass("java.lang.NoSuchMethodError");
        this.addBasicClass("java.lang.UnsatisfiedLinkError");
        this.addBasicClass("java.lang.Thread");
        this.addBasicClass("java.lang.Runnable");
        this.addBasicClass("java.lang.Cloneable");
        this.addBasicClass("java.io.Serializable");
        this.addBasicClass("java.lang.ref.Finalizer");
        this.addBasicClass("java.util.List");
        this.addBasicClass("java.util.Iterator");
        this.addBasicClass("java.util.LinkedList");
        this.addBasicClass("java.util.Collection");
        this.addBasicClass("hj.lang.place");
        this.addBasicClass("hj.lang.Runtime");
        this.addBasicClass("hj.lang.activity");
        this.addBasicClass("hj.runtime.wsh.Activity");
        this.addBasicClass("hj.runtime.wsh.WshRuntime_c");
        this.addBasicClass("hj.lang.Future");
        this.addBasicClass("hj.lang.phaser");
        this.addBasicClass("hj.lang.PhaserAbst");
        this.addBasicClass("hj.runtime.wsh.PhaserImpl");
        this.addBasicClass("hj.runtime.wsh.phaser.PhaserRegMode");
        this.addBasicClass("hj.runtime.wsh.PhaserImpl$Mode");
        this.addBasicClass("hj.lang.phaserMode");
        this.addBasicClass("hj.array.view.ShortArrayView");
        this.addBasicClass("hj.array.view.IntArrayView");
        this.addBasicClass("hj.array.view.LongArrayView");
        this.addBasicClass("hj.array.view.DoubleArrayView");
        this.addBasicClass("hj.array.view.FloatArrayView");
        this.addBasicClass("hj.array.view.BooleanArrayView");
        this.addBasicClass("hj.array.view.CharArrayView");
        this.addBasicClass("hj.array.view.ByteArrayView");
        this.addBasicClass("hj.array.view.ComplexDoubleArrayView");
        this.addBasicClass("hj.array.view.ComplexDoubleArrayView");
        this.addBasicClass("hj.compilergenerated.BoxedInteger");
        this.addBasicClass("hj.compilergenerated.BoxedBoolean");
        this.addBasicClass("hj.compilergenerated.BoxedByte");
        this.addBasicClass("hj.compilergenerated.BoxedDouble");
        this.addBasicClass("hj.compilergenerated.BoxedFloat");
        this.addBasicClass("hj.compilergenerated.BoxedLong");
        this.addBasicClass("hj.compilergenerated.BoxedShort");
        this.addBasicClass("hj.array.sharedmemory.SpecializedArrayFactory");
        this.addBasicClass("hj.runtime.wst.adaptive.Runtime");
        this.addBasicClass("hj.runtime.wst.adaptive.Worker");
        this.addBasicClass("hj.runtime.wst.adaptive.Closure");
        this.addBasicClass("hj.runtime.wst.adaptive.ActivationFrame");
        this.addBasicClass("hj.runtime.wst.basic.Worker");
        this.addBasicClass("hj.runtime.wst.adaptive.BfAsyncFrame");
        this.addBasicClass("hj.runtime.wst.adaptive.DelayedAsync");
        this.addBasicClass("hj.lang.point");
        this.addBasicClass("hj.lang.dist");
        this.addBasicClass("hj.lang.region");
        this.addBasicClass("hj.lang.region$factory");
        this.addBasicClass("hj.array.Operator$Pointwise");
    }

    public void addBasicClass(String name) {
        this.addBasicClass(name, 1);
    }

    public void addBasicClass(String name, int level) {
        this.basicclasses[level].add(name);
    }

    public void loadBasicClasses() {
        for (int i = 3; i >= 1; --i) {
            for (String name : this.basicclasses[i]) {
                this.tryLoadClass(name, i);
            }
        }
    }

    public Collection<SootClass> dynamicClasses() {
        return this.dynamicClasses;
    }

    private void loadNecessaryClass(String name) {
        SootClass c = Scene.v().loadClassAndSupport(name);
        c.setApplicationClass();
    }

    public void loadNecessaryClasses() {
        this.loadBasicClasses();
        LinkedList ll = Options.v().classes();
        while (!ll.isEmpty()) {
            String name = (String)ll.removeFirst();
            this.loadNecessaryClass(name);
        }
        this.loadDynamicClasses();
        for (String path : Options.v().process_dir()) {
            for (String cl : SourceLocator.v().getClassesUnder(path)) {
                Scene.v().loadClassAndSupport(cl).setApplicationClass();
            }
        }
        this.prepareClasses();
        this.setDoneResolving();
    }

    private void showListValues(List<String> values) {
        for (String className : values) {
            System.out.println("list values: " + className);
        }
    }

    public void loadDynamicClasses() {
        this.dynamicClasses = new ArrayList<SootClass>();
        HashSet<String> dynClasses = new HashSet<String>();
        dynClasses.addAll(Options.v().dynamic_class());
        for (String path : Options.v().dynamic_dir()) {
            dynClasses.addAll(SourceLocator.v().getClassesUnder(path));
        }
        for (String pkg : Options.v().dynamic_package()) {
            dynClasses.addAll(SourceLocator.v().classesInDynamicPackage(pkg));
        }
        for (String className : dynClasses) {
            this.dynamicClasses.add(Scene.v().loadClassAndSupport(className));
        }
    }

    private void prepareClasses() {
        LinkedList<String> excludedPackages = new LinkedList<String>();
        if (Options.v().exclude() != null) {
            excludedPackages.addAll(Options.v().exclude());
        }
        if (!Options.v().include_all()) {
            excludedPackages.add("java.");
            excludedPackages.add("sun.");
            excludedPackages.add("javax.");
            excludedPackages.add("com.sun.");
            excludedPackages.add("com.ibm.");
            excludedPackages.add("org.xml.");
            excludedPackages.add("org.w3c.");
            excludedPackages.add("org.apache.");
        }
        HashSet<SootClass> processedClasses = new HashSet<SootClass>();
        block0: while (true) {
            HashSet<SootClass> unprocessedClasses = new HashSet<SootClass>(Scene.v().getClasses());
            unprocessedClasses.removeAll(processedClasses);
            if (unprocessedClasses.isEmpty()) break;
            processedClasses.addAll(unprocessedClasses);
            Iterator i$ = unprocessedClasses.iterator();
            while (true) {
                if (!i$.hasNext()) continue block0;
                SootClass s = (SootClass)i$.next();
                if (s.isPhantom()) continue;
                if (Options.v().app()) {
                    s.setApplicationClass();
                }
                if (Options.v().classes().contains(s.getName())) {
                    s.setApplicationClass();
                    continue;
                }
                for (String pkg : excludedPackages) {
                    if (!s.isApplicationClass() || !s.getPackageName().startsWith(pkg)) continue;
                    s.setLibraryClass();
                }
                for (String pkg : Options.v().include()) {
                    if (!s.getPackageName().startsWith(pkg)) continue;
                    s.setApplicationClass();
                }
                if (!s.isApplicationClass()) continue;
                Scene.v().loadClassAndSupport(s.getName());
            }
            break;
        }
    }

    public void setPkgList(ArrayList<String> list) {
        this.pkgList = list;
    }

    public ArrayList<String> getPkgList() {
        return this.pkgList;
    }

    public SootMethodRef makeMethodRef(SootClass declaringClass, String name, List<Type> parameterTypes, Type returnType, boolean isStatic) {
        return new AbstractSootMethodRef(declaringClass, name, parameterTypes, returnType, isStatic);
    }

    public SootMethodRef makeConstructorRef(SootClass declaringClass, List<Type> parameterTypes) {
        return this.makeMethodRef(declaringClass, "<init>", parameterTypes, VoidType.v(), false);
    }

    public SootFieldRef makeFieldRef(SootClass declaringClass, String name, Type type, boolean isStatic) {
        return new AbstractSootFieldRef(declaringClass, name, type, isStatic);
    }

    public List<SootClass> getClasses(int desiredLevel) {
        ArrayList<SootClass> ret = new ArrayList<SootClass>();
        for (SootClass cl : this.getClasses()) {
            if (cl.resolvingLevel() < desiredLevel) continue;
            ret.add(cl);
        }
        return ret;
    }

    public boolean doneResolving() {
        return this.doneResolving;
    }

    public void setDoneResolving() {
        this.doneResolving = true;
    }

    public void setMainClassFromOptions() {
        if (this.mainClass != null) {
            return;
        }
        if (Options.v().main_class() != null && Options.v().main_class().length() > 0) {
            this.setMainClass(this.getSootClass(Options.v().main_class()));
        } else {
            for (SootClass c : this.getApplicationClasses()) {
                if (!c.declaresMethod("main", new SingletonList(ArrayType.v(RefType.v("java.lang.String"), 1)), VoidType.v())) continue;
                G.v().out.println("No main class given. Inferred '" + c.getName() + "' as main class.");
                this.setMainClass(c);
                break;
            }
        }
    }
}

